/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox;

import com.yusaki.lammailbox.command.LmbCommandExecutor;
import com.yusaki.lammailbox.command.LmbTabComplete;
import com.yusaki.lammailbox.config.MailBoxConfigUpdater;
import com.yusaki.lammailbox.gui.ConfigMailGuiFactory;
import com.yusaki.lammailbox.gui.InventoryClickHandler;
import com.yusaki.lammailbox.gui.MailGuiFactory;
import com.yusaki.lammailbox.lib.folialib.FoliaLib;
import com.yusaki.lammailbox.repository.MailRepository;
import com.yusaki.lammailbox.repository.YamlMailRepository;
import com.yusaki.lammailbox.service.DefaultMailService;
import com.yusaki.lammailbox.service.MailDelivery;
import com.yusaki.lammailbox.service.MailService;
import com.yusaki.lammailbox.session.MailCreationController;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LamMailBox
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private MailRepository mailRepository;
    private MailService mailService;
    private FileConfiguration database;
    private Map<UUID, MailCreationSession> mailSessions;
    private Map<UUID, String> awaitingInput;
    private Map<UUID, Boolean> inMailCreation;
    private Map<UUID, String> deleteConfirmations;
    private Map<UUID, String> viewingAsPlayer;
    private FoliaLib foliaLib;
    private InventoryClickHandler inventoryClickHandler;
    private MailGuiFactory mailGuiFactory;
    private MailCreationController mailCreationController;
    private MailBoxConfigUpdater configUpdater;

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        this.configUpdater = new MailBoxConfigUpdater(this);
        this.configUpdater.updateConfigs();
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.mailRepository = new YamlMailRepository(this);
        this.database = this.mailRepository.getBackingConfiguration();
        this.mailService = new DefaultMailService(this, this.mailRepository, this.foliaLib);
        this.mailSessions = new HashMap<UUID, MailCreationSession>();
        this.awaitingInput = new HashMap<UUID, String>();
        this.inMailCreation = new HashMap<UUID, Boolean>();
        this.deleteConfirmations = new HashMap<UUID, String>();
        this.viewingAsPlayer = new HashMap<UUID, String>();
        this.inventoryClickHandler = new InventoryClickHandler(this);
        this.mailGuiFactory = new ConfigMailGuiFactory(this);
        this.mailCreationController = new MailCreationController(this);
        LmbCommandExecutor lmbCommandExecutor = new LmbCommandExecutor(this);
        this.getCommand("lmb").setExecutor((CommandExecutor)lmbCommandExecutor);
        this.getCommand("lmb").setTabCompleter((TabCompleter)new LmbTabComplete(this));
        this.getCommand("lmbreload").setExecutor((sender, cmd, label, args) -> {
            if (!sender.hasPermission(this.config.getString("settings.permissions.reload"))) {
                sender.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
                return true;
            }
            this.configUpdater.updateConfigs();
            this.reloadConfig();
            this.config = this.getConfig();
            sender.sendMessage(this.colorize(this.config.getString("messages.reload-success")));
            return true;
        });
        this.foliaLib.getScheduler().runTimer(() -> this.checkScheduledMails(), 1200L, 1200L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startCleanupTask();
    }

    private void checkScheduledMails() {
        List<MailDelivery> toNotify = this.mailService.schedulePendingMails();
        toNotify.forEach(delivery -> this.notifyRecipients(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName()));
    }

    private void startCleanupTask() {
        this.foliaLib.getScheduler().runTimer(() -> this.cleanupExpiredMails(), 72000L, 72000L);
    }

    private void cleanupExpiredMails() {
        this.mailService.removeExpiredMails();
    }

    public void openMainGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.open"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createMailbox(player));
    }

    public void openMailboxAsPlayer(Player admin, Player targetPlayer) {
        if (!admin.hasPermission(this.config.getString("settings.permissions.view-as"))) {
            admin.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        this.viewingAsPlayer.put(admin.getUniqueId(), targetPlayer.getName());
        admin.openInventory(this.mailGuiFactory.createMailboxAs(admin, targetPlayer));
    }

    public void openSentMailGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.open"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createSentMailbox(player));
    }

    public void openSentMailView(Player player, String mailId) {
        player.openInventory(this.mailGuiFactory.createSentMailView(player, mailId));
    }

    public void handleSentMailDelete(Player player, String mailId) {
        if (!player.hasPermission(this.config.getString("settings.permissions.delete"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        String confirmingMailId = this.deleteConfirmations.get(player.getUniqueId());
        if (confirmingMailId != null && confirmingMailId.equals(mailId)) {
            this.mailService.deleteMail(mailId);
            this.deleteConfirmations.remove(player.getUniqueId());
            player.closeInventory();
            this.openSentMailGUI(player);
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.mail-deleted")));
        } else {
            this.deleteConfirmations.put(player.getUniqueId(), mailId);
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.delete-confirmation")));
        }
    }

    public void openCreateMailGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.compose"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createMailCreation(player));
    }

    public void openItemsGUI(Player player) {
        this.inMailCreation.put(player.getUniqueId(), true);
        player.openInventory(this.mailGuiFactory.createItemsEditor(player));
    }

    private void checkPlayerMails(Player player) {
        if (!this.database.contains("mails")) {
            return;
        }
        ConfigurationSection mailsSection = this.database.getConfigurationSection("mails");
        for (String mailId : mailsSection.getKeys(false)) {
            String receiver = this.database.getString("mails." + mailId + ".receiver");
            boolean isActive = this.database.getBoolean("mails." + mailId + ".active", true);
            List claimedPlayers = this.database.getStringList("mails." + mailId + ".claimed-players");
            if (!isActive || !this.shouldNotifyPlayer(player, receiver, claimedPlayers)) continue;
            String sender = this.database.getString("mails." + mailId + ".sender");
            this.sendMailNotification(player, mailId, sender);
        }
    }

    private boolean shouldNotifyPlayer(Player player, String receiver, List<String> claimedPlayers) {
        if (receiver.equals("all")) {
            return !claimedPlayers.contains(player.getName());
        }
        if (receiver.contains(";")) {
            return Arrays.asList(receiver.split(";")).contains(player.getName());
        }
        return receiver.equals(player.getName());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("settings.join-notification")) {
            return;
        }
        Player player = event.getPlayer();
        this.checkPlayerMails(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        this.inventoryClickHandler.handleClick(event);
    }

    public void openMailView(Player player, String mailId) {
        player.openInventory(this.mailGuiFactory.createMailView(player, mailId));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String inputType = this.awaitingInput.remove(player.getUniqueId());
        if (inputType == null) {
            return;
        }
        event.setCancelled(true);
        MailCreationSession session = this.mailSessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        boolean success = true;
        String customSubtitle = null;
        String message = event.getMessage();
        switch (inputType) {
            case "receiver": {
                success = this.mailCreationController.handleReceiverInput(player, message, session);
                customSubtitle = success ? this.config.getString("messages.current-receiver").replace("%receiver%", message) : this.config.getString("messages.invalid-receiver");
                break;
            }
            case "message": {
                session.setMessage(message.replace("\\n", "\n"));
                customSubtitle = this.config.getString("messages.current-message");
                this.mailCreationController.reopenCreationAsync(player);
                break;
            }
            case "command": {
                success = this.mailCreationController.handleCommandInput(player, message, session);
                customSubtitle = this.config.getString("messages.command-format-display").replace("%command%", message);
                this.mailCreationController.reopenCreationAsync(player);
                break;
            }
            case "schedule-date": {
                success = this.mailCreationController.handleDateInput(player, message, session, true);
                customSubtitle = success && session.getScheduleDate() != null ? this.config.getString("messages.schedule-set").replace("%date%", new Date(session.getScheduleDate()).toString()) : this.config.getString("messages.invalid-date-format");
                break;
            }
            case "expire-date": {
                success = this.mailCreationController.handleDateInput(player, message, session, false);
                customSubtitle = success && session.getExpireDate() != null ? this.config.getString("messages.expire-set").replace("%date%", new Date(session.getExpireDate()).toString()) : this.config.getString("messages.invalid-date-format");
                break;
            }
            default: {
                success = false;
            }
        }
        this.mailCreationController.showResponseTitle(player, success, customSubtitle);
        if (!"message".equals(inputType) && !"command".equals(inputType)) {
            this.mailCreationController.reopenCreationAsync(player);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (this.awaitingInput.containsKey(player.getUniqueId())) {
                this.awaitingInput.remove(player.getUniqueId());
                this.foliaLib.getScheduler().runNextTick(Task -> this.openCreateMailGUI(player));
            }
            this.deleteConfirmations.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.inventoryClickHandler.handleClose(event);
    }

    public void handleMailSend(Player sender) {
        MailDelivery delivery;
        MailCreationSession session = this.mailSessions.get(sender.getUniqueId());
        if (session == null || !session.isComplete()) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.incomplete-mail")));
            return;
        }
        this.inMailCreation.remove(sender.getUniqueId());
        try {
            delivery = this.mailService.sendMail(sender, session);
        }
        catch (IllegalArgumentException ex) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.incomplete-mail")));
            return;
        }
        if (delivery.shouldNotifyNow()) {
            this.notifyRecipients(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName());
        }
        this.mailSessions.remove(sender.getUniqueId());
        sender.closeInventory();
        Long scheduleDate = session.getScheduleDate();
        if (scheduleDate != null && scheduleDate > System.currentTimeMillis()) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.schedule-set").replace("%date%", new Date(scheduleDate).toString())));
        } else {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.mail-sent")));
        }
    }

    public String colorize(String text) {
        return text.replace("&", "\u00a7");
    }

    private void sendMailNotification(Player receiver, String mailId, String sender) {
        String sound;
        if (this.config.getBoolean("settings.notification.chat-enabled")) {
            String chatMessage = this.config.getString("messages.new-mail-clickable").replace("%sender%", sender);
            TextComponent message = new TextComponent(this.colorize(this.config.getString("messages.prefix") + chatMessage));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lmb view " + mailId));
            receiver.spigot().sendMessage((BaseComponent)message);
        }
        if (this.config.getBoolean("settings.notification.title-enabled")) {
            String title = this.colorize(this.config.getString("titles.notification.title").replace("%sender%", sender));
            String subtitle = this.colorize(this.config.getString("titles.notification.subtitle").replace("%sender%", sender));
            int fadeIn = this.config.getInt("titles.notification.fadein");
            int stay = this.config.getInt("titles.notification.stay");
            int fadeOut = this.config.getInt("titles.notification.fadeout");
            receiver.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
        }
        if ((sound = this.config.getString("settings.notification.sound")) != null && !sound.isEmpty()) {
            float volume = (float)this.config.getDouble("settings.notification.volume");
            float pitch = (float)this.config.getDouble("settings.notification.pitch");
            receiver.playSound(receiver.getLocation(), Sound.valueOf((String)sound), volume, pitch);
        }
    }

    private void notifyRecipients(String receiverSpec, String mailId, String senderName) {
        if (receiverSpec == null || receiverSpec.isEmpty()) {
            return;
        }
        if (receiverSpec.equalsIgnoreCase("all")) {
            Bukkit.getOnlinePlayers().forEach(player -> this.sendMailNotification((Player)player, mailId, senderName));
            return;
        }
        if (receiverSpec.contains(";")) {
            Arrays.stream(receiverSpec.split(";")).map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> this.sendMailNotification((Player)player, mailId, senderName));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)receiverSpec);
        if (receiver != null) {
            this.sendMailNotification(receiver, mailId, senderName);
        }
    }

    public void dispatchMailNotifications(String receiverSpec, String mailId, String senderName) {
        this.notifyRecipients(receiverSpec, mailId, senderName);
    }

    public MailCreationController getMailCreationController() {
        return this.mailCreationController;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public MailRepository getMailRepository() {
        return this.mailRepository;
    }

    public Map<UUID, MailCreationSession> getMailSessions() {
        return this.mailSessions;
    }

    public Map<UUID, String> getAwaitingInput() {
        return this.awaitingInput;
    }

    public Map<UUID, Boolean> getInMailCreation() {
        return this.inMailCreation;
    }

    public Map<UUID, String> getDeleteConfirmations() {
        return this.deleteConfirmations;
    }

    public Map<UUID, String> getViewingAsPlayer() {
        return this.viewingAsPlayer;
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public MailBoxConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }
}

