/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.command;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.service.MailDelivery;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class LmbCommandExecutor
implements CommandExecutor {
    private final LamMailBox plugin;

    public LmbCommandExecutor(LamMailBox plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return this.handleDefault(sender);
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "send": {
                return this.handleSend(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "view": {
                return this.handleView(sender, args);
            }
            case "as": {
                return this.handleAs(sender, args);
            }
        }
        return this.handleOpenOther(sender, args[0]);
    }

    private boolean handleSend(CommandSender sender, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        if (!sender.hasPermission(config.getString("settings.admin-permission"))) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.send-command-admin-only")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&cUsage: /lmb send <users> <message> | [commands] | schedule:YYYY:MM:DD:HH:mm | expire:YYYY:MM:DD:HH:mm"));
            return true;
        }
        String receiver = args[0];
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        MailCreationSession session = new MailCreationSession();
        session.setReceiver(receiver);
        String[] sections = message.split("\\|");
        String messageContent = sections[0].trim();
        ArrayList<String> commands = new ArrayList<String>();
        Long scheduleDate = null;
        Long expireDate = null;
        for (int i = 1; i < sections.length; ++i) {
            String cmd;
            String[] commandParts;
            String dateStr;
            String section = sections[i].trim();
            if (section.startsWith("schedule:")) {
                dateStr = section.substring(9).trim();
                scheduleDate = this.parseDateString(dateStr);
                if (scheduleDate != null) continue;
                sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.invalid-date-format")));
                return true;
            }
            if (section.startsWith("expire:")) {
                dateStr = section.substring(7).trim();
                expireDate = this.parseDateString(dateStr);
                if (expireDate != null) continue;
                sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.invalid-date-format")));
                return true;
            }
            if (section.isEmpty()) continue;
            if (sender instanceof Player && !sender.hasPermission(config.getString("settings.admin-permission"))) {
                sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.no-permission")));
                return true;
            }
            if (section.contains("[") && section.contains("]")) {
                for (String commandPart : commandParts = section.split("\\]\\s*\\[")) {
                    cmd = commandPart.replaceAll("[\\[\\]]", "").trim();
                    if (cmd.isEmpty()) continue;
                    commands.add(cmd);
                }
                continue;
            }
            for (String commandPart : commandParts = section.split(",")) {
                cmd = commandPart.trim();
                if (cmd.isEmpty()) continue;
                commands.add(cmd);
            }
        }
        session.setMessage(messageContent);
        session.setCommands(commands);
        if (scheduleDate != null) {
            session.setScheduleDate(scheduleDate);
        }
        if (expireDate != null) {
            session.setExpireDate(expireDate);
        } else {
            long defaultExpire = System.currentTimeMillis() + 31536000000L;
            session.setExpireDate(defaultExpire);
        }
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                MailDelivery delivery = this.plugin.getMailService().sendMail(player, session);
                if (delivery.shouldNotifyNow()) {
                    this.plugin.dispatchMailNotifications(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName());
                }
                player.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.mail-sent")));
            } else {
                MailDelivery delivery = this.plugin.getMailService().sendConsoleMail(sender, session);
                if (delivery.shouldNotifyNow()) {
                    this.plugin.dispatchMailNotifications(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName());
                }
                sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&aMail sent successfully."));
            }
        }
        catch (IllegalArgumentException ex) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.incomplete-mail")));
        }
        return true;
    }

    private boolean handleView(CommandSender sender, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.console-only")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&cUsage: /lmb view <mailId>"));
            return true;
        }
        Player player = (Player)sender;
        String mailId = args[1];
        String dbPath = "mails." + mailId + ".";
        FileConfiguration database = this.plugin.getMailRepository().getBackingConfiguration();
        if (!database.contains(dbPath)) {
            player.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.mail-not-found")));
            return true;
        }
        String receiver = database.getString(dbPath + "receiver");
        List claimedPlayers = database.getStringList(dbPath + "claimed-players");
        boolean canAccess = false;
        boolean isActive = database.getBoolean(dbPath + "active", true);
        if (isActive) {
            canAccess = Objects.equals(receiver, "all") ? !claimedPlayers.contains(player.getName()) : (receiver != null && receiver.contains(";") ? Arrays.asList(receiver.split(";")).contains(player.getName()) : Objects.equals(receiver, player.getName()));
        }
        if (canAccess) {
            this.plugin.openMailView(player, mailId);
        } else {
            player.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.mail-no-access")));
        }
        return true;
    }

    private boolean handleAs(CommandSender sender, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        if (!sender.hasPermission(config.getString("settings.permissions.view-as"))) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.no-permission")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&cUsage: /lmb as <player>"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[1]);
        if (targetPlayer == null) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.invalid-receiver")));
            return true;
        }
        if (sender instanceof Player) {
            Player admin = (Player)sender;
            this.plugin.openMailboxAsPlayer(admin, targetPlayer);
            admin.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&aOpened mailbox as " + targetPlayer.getName()));
        } else {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&cConsole cannot open GUI. Use /lmb <player> instead."));
        }
        return true;
    }

    private boolean handleOpenOther(CommandSender sender, String targetName) {
        String permission;
        Player player;
        FileConfiguration config = this.plugin.getConfig();
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.invalid-receiver")));
            return true;
        }
        if (sender instanceof Player && !(player = (Player)sender).hasPermission(permission = config.getString("settings.permissions.open-others", "lammailbox.open.others"))) {
            player.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + config.getString("messages.no-permission")));
            return true;
        }
        this.plugin.openMainGUI(target);
        sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&aOpened mailbox for " + target.getName()));
        return true;
    }

    private boolean handleDefault(CommandSender sender) {
        FileConfiguration config = this.plugin.getConfig();
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.colorize(config.getString("messages.prefix") + "&cUsage: /lmb <player>"));
            return true;
        }
        Player player = (Player)sender;
        this.plugin.openMainGUI(player);
        return true;
    }

    private Long parseDateString(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        try {
            String[] parts = dateStr.split(":");
            if (parts.length != 5) {
                return null;
            }
            int year = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]) - 1;
            int day = Integer.parseInt(parts[2]);
            int hour = Integer.parseInt(parts[3]);
            int minute = Integer.parseInt(parts[4]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, hour, minute, 0);
            calendar.set(14, 0);
            return calendar.getTimeInMillis();
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }
}

