/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.MailGuiFactory;
import com.yusaki.lammailbox.session.MailCreationSession;
import com.yusaki.lammailbox.util.ItemSerialization;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ConfigMailGuiFactory
implements MailGuiFactory {
    private final LamMailBox plugin;

    public ConfigMailGuiFactory(LamMailBox plugin) {
        this.plugin = plugin;
    }

    @Override
    public Inventory createMailbox(Player viewer) {
        int size = this.config().getInt("gui.main.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.main.title")));
        this.addDecorations(inv, "gui.main");
        this.addCreateMailButton(inv, viewer, viewer);
        this.addSentMailButton(inv);
        this.loadPlayerMails(viewer, viewer, inv);
        return inv;
    }

    @Override
    public Inventory createMailboxAs(Player admin, Player target) {
        int size = this.config().getInt("gui.main.size");
        String title = this.config().getString("gui.main.title") + " &7(as " + target.getName() + ")";
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(title));
        this.addDecorations(inv, "gui.main");
        this.addCreateMailButton(inv, admin, target);
        this.addSentMailButton(inv);
        this.loadPlayerMails(admin, target, inv);
        return inv;
    }

    @Override
    public Inventory createSentMailbox(Player viewer) {
        int size = this.config().getInt("gui.sent-mail.size");
        Object title = this.config().getString("gui.sent-mail.title");
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        if (viewingAs != null) {
            title = (String)title + " &7(as " + viewingAs + ")";
        }
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize((String)title));
        this.addDecorations(inv, "gui.sent-mail");
        this.addBackButton(inv);
        this.loadSentMails(viewer, inv);
        return inv;
    }

    @Override
    public Inventory createSentMailView(Player viewer, String mailId) {
        int size = this.config().getInt("gui.sent-mail-view.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.sent-mail-view.title")));
        this.addDecorations(inv, "gui.sent-mail-view");
        String dbPath = "mails." + mailId + ".";
        FileConfiguration database = this.database();
        String receiver = database.getString(dbPath + "receiver", "");
        String message = Objects.requireNonNullElse(database.getString(dbPath + "message"), "").replace("\\n", "\n");
        ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.receiver-head.material")));
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        headMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail-view.items.receiver-head.name").replace("%receiver%", receiver)));
        headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)receiver));
        head.setItemMeta((ItemMeta)headMeta);
        inv.setItem(this.config().getInt("gui.sent-mail-view.items.receiver-head.slot"), head);
        ItemStack messageItem = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.message.material")));
        ItemMeta messageMeta = messageItem.getItemMeta();
        messageMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail-view.items.message.name")));
        List messageLore = Arrays.stream(message.split("\n")).map(line -> this.plugin.colorize("&f" + line)).collect(Collectors.toList());
        messageMeta.setLore(messageLore);
        messageItem.setItemMeta(messageMeta);
        inv.setItem(this.config().getInt("gui.sent-mail-view.items.message.slot"), messageItem);
        List serializedItems = database.getStringList(dbPath + "items");
        List items = serializedItems.stream().map(ItemSerialization::deserializeItem).filter(Objects::nonNull).collect(Collectors.toList());
        List itemSlots = this.config().getIntegerList("gui.sent-mail-view.items.items-display.slots");
        for (int i = 0; i < Math.min(items.size(), itemSlots.size()); ++i) {
            inv.setItem(((Integer)itemSlots.get(i)).intValue(), (ItemStack)items.get(i));
        }
        List commands = database.getStringList(dbPath + "commands");
        if (!commands.isEmpty()) {
            ItemStack commandBlock;
            String serialized = database.getString(dbPath + "command-block");
            ItemStack itemStack = commandBlock = serialized != null ? ItemSerialization.deserializeItem(serialized) : this.createDefaultCommandBlock();
            if (commandBlock != null) {
                ItemMeta commandMeta = commandBlock.getItemMeta();
                commandMeta.setLore(new ArrayList());
                commandBlock.setItemMeta(commandMeta);
                inv.setItem(this.config().getInt("gui.sent-mail-view.items.command-block.slot"), commandBlock);
            }
        }
        if (viewer.hasPermission(this.config().getString("settings.permissions.delete"))) {
            ItemStack deleteButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.delete-button.material")));
            ItemMeta deleteMeta = deleteButton.getItemMeta();
            deleteMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail-view.items.delete-button.name")));
            deleteMeta.setLore(this.config().getStringList("gui.sent-mail-view.items.delete-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
            deleteMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING, (Object)mailId);
            deleteButton.setItemMeta(deleteMeta);
            inv.setItem(this.config().getInt("gui.sent-mail-view.items.delete-button.slot"), deleteButton);
        }
        return inv;
    }

    @Override
    public Inventory createMailView(Player viewer, String mailId) {
        int size = this.config().getInt("gui.mail-view.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.mail-view.title")));
        this.addDecorations(inv, "gui.mail-view");
        String dbPath = "mails." + mailId + ".";
        FileConfiguration database = this.database();
        String sender = database.getString(dbPath + "sender");
        String message = Objects.requireNonNullElse(database.getString(dbPath + "message"), "").replace("\\n", "\n");
        ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.sender-head.material")));
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        headMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.mail-view.items.sender-head.name").replace("%sender%", sender)));
        headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)sender));
        head.setItemMeta((ItemMeta)headMeta);
        inv.setItem(this.config().getInt("gui.mail-view.items.sender-head.slot"), head);
        ItemStack messageItem = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.message.material")));
        ItemMeta messageMeta = messageItem.getItemMeta();
        messageMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.mail-view.items.message.name")));
        List messageLore = Arrays.stream(message.split("\n")).map(line -> this.plugin.colorize("&f" + line)).collect(Collectors.toList());
        messageMeta.setLore(messageLore);
        messageItem.setItemMeta(messageMeta);
        inv.setItem(this.config().getInt("gui.mail-view.items.message.slot"), messageItem);
        List serializedItems = database.getStringList(dbPath + "items");
        List items = serializedItems.stream().map(ItemSerialization::deserializeItem).filter(Objects::nonNull).collect(Collectors.toList());
        List itemSlots = this.config().getIntegerList("gui.mail-view.items.items-display.slots");
        for (int i = 0; i < Math.min(items.size(), itemSlots.size()); ++i) {
            inv.setItem(((Integer)itemSlots.get(i)).intValue(), (ItemStack)items.get(i));
        }
        List commands = database.getStringList(dbPath + "commands");
        if (!commands.isEmpty()) {
            ItemStack commandBlock;
            String serialized = database.getString(dbPath + "command-block");
            ItemStack itemStack = commandBlock = serialized != null ? ItemSerialization.deserializeItem(serialized) : new ItemStack(Material.COMMAND_BLOCK);
            if (commandBlock != null) {
                ItemMeta commandMeta = commandBlock.getItemMeta();
                commandMeta.setLore(new ArrayList());
                commandBlock.setItemMeta(commandMeta);
                inv.setItem(this.config().getInt("gui.mail-view.items.command-block.slot"), commandBlock);
            }
        }
        boolean hasRewards = !items.isEmpty() || !commands.isEmpty();
        String buttonPath = hasRewards ? "gui.mail-view.items.claim-button" : "gui.mail-view.items.dismiss-button";
        String materialName = this.config().getString(buttonPath + ".material");
        if (materialName == null || materialName.isEmpty()) {
            materialName = this.config().getString("gui.mail-view.items.claim-button.material", Material.GREEN_TERRACOTTA.name());
        }
        ItemStack claimButton = new ItemStack(Material.valueOf((String)materialName));
        ItemMeta claimMeta = claimButton.getItemMeta();
        String displayName = this.config().getString(buttonPath + ".name", this.config().getString("gui.mail-view.items.claim-button.name", "&aMark as read"));
        claimMeta.setDisplayName(this.plugin.colorize(displayName));
        List loreTemplate = this.config().getStringList(buttonPath + ".lore");
        if (loreTemplate.isEmpty()) {
            loreTemplate = this.config().getStringList("gui.mail-view.items.claim-button.lore");
        }
        List lore = loreTemplate.stream().map(this.plugin::colorize).collect(Collectors.toList());
        claimMeta.setLore(lore);
        claimMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING, (Object)mailId);
        claimButton.setItemMeta(claimMeta);
        inv.setItem(this.config().getInt("gui.mail-view.items.claim-button.slot"), claimButton);
        return inv;
    }

    @Override
    public Inventory createMailCreation(Player viewer) {
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(viewer.getUniqueId(), key -> new MailCreationSession());
        this.ensureSessionDefaults(session);
        int size = this.config().getInt("gui.create-mail.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.create-mail.title")));
        this.addDecorations(inv, "gui.create-mail");
        ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.receiver-head.material")));
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        headMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.receiver-head.name")));
        List headLore = viewer.hasPermission(this.config().getString("settings.admin-permission")) ? this.config().getStringList("gui.create-mail.items.receiver-head.adminlore") : this.config().getStringList("gui.create-mail.items.receiver-head.lore");
        List lore = headLore.stream().map(this.plugin::colorize).collect(Collectors.toList());
        if (session.getReceiver() != null) {
            lore.add(this.plugin.colorize(this.config().getString("gui.create-mail.items.receiver-head.current-receiver-format").replace("%receiver%", session.getReceiver())));
        }
        headMeta.setLore(lore);
        head.setItemMeta((ItemMeta)headMeta);
        inv.setItem(this.config().getInt("gui.create-mail.items.receiver-head.slot"), head);
        ItemStack paper = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.message-paper.material")));
        ItemMeta paperMeta = paper.getItemMeta();
        paperMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.message-paper.name")));
        List<Object> paperLore = new ArrayList(this.config().getStringList("gui.create-mail.items.message-paper.lore"));
        paperLore = paperLore.stream().map(this.plugin::colorize).collect(Collectors.toList());
        if (session.getMessage() != null) {
            paperLore.add(this.plugin.colorize(this.config().getString("gui.create-mail.items.message-paper.current-message-prefix")));
            paperLore.addAll(Arrays.stream(session.getMessage().split("\n")).map(line -> this.plugin.colorize(this.config().getString("gui.create-mail.items.message-paper.message-line-format") + line)).collect(Collectors.toList()));
        }
        paperMeta.setLore(paperLore);
        paper.setItemMeta(paperMeta);
        inv.setItem(this.config().getInt("gui.create-mail.items.message-paper.slot"), paper);
        int chestSlot = this.config().getInt("gui.create-mail.items.items-chest.slot");
        if (viewer.hasPermission(this.config().getString("settings.permissions.add-items"))) {
            ItemStack chest = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.items-chest.material")));
            ItemMeta chestMeta = chest.getItemMeta();
            chestMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.items-chest.name")));
            chestMeta.setLore(this.config().getStringList("gui.create-mail.items.items-chest.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
            chest.setItemMeta(chestMeta);
            inv.setItem(chestSlot, chest);
        } else {
            inv.setItem(chestSlot, this.createDisabledFiller());
        }
        ItemStack sendButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.send-button.material")));
        ItemMeta sendMeta = sendButton.getItemMeta();
        sendMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.send-button.name")));
        sendMeta.setLore(this.config().getStringList("gui.create-mail.items.send-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        sendButton.setItemMeta(sendMeta);
        inv.setItem(this.config().getInt("gui.create-mail.items.send-button.slot"), sendButton);
        int commandSlot = this.config().getInt("gui.create-mail.items.command-block.slot");
        int clockSlot = this.config().getInt("gui.create-mail.items.schedule-clock.slot");
        if (viewer.hasPermission(this.config().getString("settings.admin-permission"))) {
            ItemStack commandBlock = session.getDisplayCommandBlock() != null ? session.getDisplayCommandBlock().clone() : this.createDefaultCommandBlock();
            inv.setItem(commandSlot, commandBlock);
            ItemStack clock = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.schedule-clock.material")));
            ItemMeta clockMeta = clock.getItemMeta();
            clockMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.schedule-clock.name")));
            String scheduleTime = session.getScheduleDate() != null ? new SimpleDateFormat("yyyy:MM:dd:HH:mm").format(new Date(session.getScheduleDate())) : "Not set";
            String expireTime = session.getExpireDate() != null ? new SimpleDateFormat("yyyy:MM:dd:HH:mm").format(new Date(session.getExpireDate())) : "Not set";
            clockMeta.setLore(this.config().getStringList("gui.create-mail.items.schedule-clock.lore").stream().map(line -> line.replace("%schedule_time%", scheduleTime).replace("%expire_time%", expireTime)).map(this.plugin::colorize).collect(Collectors.toList()));
            clock.setItemMeta(clockMeta);
            inv.setItem(clockSlot, clock);
        } else {
            inv.setItem(commandSlot, this.createDisabledFiller());
            inv.setItem(clockSlot, this.createDisabledFiller());
        }
        return inv;
    }

    @Override
    public Inventory createItemsEditor(Player viewer) {
        int size = this.config().getInt("gui.items.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.items.title")));
        MailCreationSession session = this.plugin.getMailSessions().get(viewer.getUniqueId());
        if (session != null) {
            session.getItems().forEach(item -> inv.addItem(new ItemStack[]{item.clone()}));
        }
        ItemStack saveButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.items.items.save-button.material")));
        ItemMeta saveMeta = saveButton.getItemMeta();
        saveMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.items.items.save-button.name")));
        saveMeta.setLore(this.config().getStringList("gui.items.items.save-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        saveButton.setItemMeta(saveMeta);
        inv.setItem(this.config().getInt("gui.items.items.save-button.slot"), saveButton);
        return inv;
    }

    private void addCreateMailButton(Inventory inv, Player viewer, Player target) {
        ItemStack createBook = new ItemStack(Material.valueOf((String)this.config().getString("gui.main.items.create-mail.material")));
        ItemMeta bookMeta = createBook.getItemMeta();
        bookMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.main.items.create-mail.name")));
        ArrayList<String> bookLore = new ArrayList<String>(this.config().getStringList("gui.main.items.create-mail.lore"));
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        if (viewingAs != null && !viewer.getUniqueId().equals(target.getUniqueId())) {
            bookMeta.setDisplayName(this.plugin.colorize("&c&l" + this.config().getString("gui.main.items.create-mail.name")));
            bookLore.add(this.plugin.colorize("&c&l\u26a0 DISABLED"));
            bookLore.add(this.plugin.colorize("&7Cannot create mail as another player"));
        }
        bookMeta.setLore(bookLore.stream().map(this.plugin::colorize).collect(Collectors.toList()));
        createBook.setItemMeta(bookMeta);
        inv.setItem(this.config().getInt("gui.main.items.create-mail.slot"), createBook);
    }

    private void addSentMailButton(Inventory inv) {
        ItemStack sentMailButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.main.items.sent-mail.material")));
        ItemMeta sentMailMeta = sentMailButton.getItemMeta();
        sentMailMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.main.items.sent-mail.name")));
        sentMailMeta.setLore(this.config().getStringList("gui.main.items.sent-mail.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        sentMailButton.setItemMeta(sentMailMeta);
        inv.setItem(this.config().getInt("gui.main.items.sent-mail.slot"), sentMailButton);
    }

    private void addBackButton(Inventory inv) {
        ItemStack backButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail.items.back-button.material")));
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail.items.back-button.name")));
        backMeta.setLore(this.config().getStringList("gui.sent-mail.items.back-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        backButton.setItemMeta(backMeta);
        inv.setItem(this.config().getInt("gui.sent-mail.items.back-button.slot"), backButton);
    }

    private void loadPlayerMails(Player viewer, Player target, Inventory inv) {
        if (!this.database().contains("mails")) {
            return;
        }
        List mailSlots = this.config().getIntegerList("gui.main.items.mail-display.slots");
        int currentSlot = 0;
        ConfigurationSection mailsSection = this.database().getConfigurationSection("mails");
        if (mailsSection == null) {
            return;
        }
        for (String mailId : mailsSection.getKeys(false)) {
            String dbPath = "mails." + mailId + ".";
            String receiver = this.database().getString(dbPath + "receiver");
            List claimedPlayers = this.database().getStringList(dbPath + "claimed-players");
            boolean isActive = this.database().getBoolean(dbPath + "active", true);
            boolean shouldDisplay = false;
            if (isActive && receiver != null) {
                shouldDisplay = receiver.equals("all") ? !claimedPlayers.contains(target.getName()) : (receiver.contains(";") ? Arrays.asList(receiver.split(";")).contains(target.getName()) : receiver.equals(target.getName()));
            }
            if (!shouldDisplay || currentSlot >= mailSlots.size()) continue;
            ItemStack mailItem = this.createMailItem(mailId);
            inv.setItem(((Integer)mailSlots.get(currentSlot)).intValue(), mailItem);
            ++currentSlot;
        }
    }

    private void loadSentMails(Player viewer, Inventory inv) {
        if (!this.database().contains("mails")) {
            return;
        }
        List mailSlots = this.config().getIntegerList("gui.sent-mail.items.sent-mail-display.slots");
        int currentSlot = 0;
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        String targetPlayerName = viewingAs != null ? viewingAs : viewer.getName();
        ConfigurationSection mailsSection = this.database().getConfigurationSection("mails");
        if (mailsSection == null) {
            return;
        }
        for (String mailId : mailsSection.getKeys(false)) {
            String sender = this.database().getString("mails." + mailId + ".sender");
            if (!Objects.equals(sender, targetPlayerName) || currentSlot >= mailSlots.size()) continue;
            ItemStack mailItem = this.createSentMailItem(mailId);
            inv.setItem(((Integer)mailSlots.get(currentSlot)).intValue(), mailItem);
            ++currentSlot;
        }
    }

    private ItemStack createMailItem(String mailId) {
        boolean isAdminMail = this.database().getBoolean("mails." + mailId + ".is-admin-mail");
        String itemPath = isAdminMail ? "gui.main.items.admin-mail-display" : "gui.main.items.mail-display";
        ItemStack mailItem = new ItemStack(Material.valueOf((String)this.config().getString(itemPath + ".material")));
        ItemMeta meta = mailItem.getItemMeta();
        String displayName = this.config().getString(itemPath + ".name", "");
        String sender = Objects.requireNonNullElse(this.database().getString("mails." + mailId + ".sender"), "");
        String message = Objects.requireNonNullElse(this.database().getString("mails." + mailId + ".message"), "").replace("\\n", "\n");
        long sentAt = this.database().getLong("mails." + mailId + ".sent-date", 0L);
        long expireAt = this.database().getLong("mails." + mailId + ".expire-date", 0L);
        meta.setDisplayName(this.plugin.colorize(this.applyMailPlaceholders(displayName, sender, message, sentAt, expireAt)));
        List loreTemplate = this.config().getStringList(itemPath + ".lore");
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.plugin.colorize(this.applyMailPlaceholders(line, sender, message, sentAt, expireAt)));
        }
        String messagePrefix = this.config().getString(itemPath + ".message-prefix");
        if (messagePrefix != null && !messagePrefix.isEmpty() && !message.isEmpty()) {
            for (String line : message.split("\n")) {
                lore.add(this.plugin.colorize(messagePrefix + line));
            }
        }
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING, (Object)mailId);
        mailItem.setItemMeta(meta);
        return mailItem;
    }

    private ItemStack createSentMailItem(String mailId) {
        ItemStack item = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail.items.sent-mail-display.material")));
        ItemMeta meta = item.getItemMeta();
        String receiver = this.database().getString("mails." + mailId + ".receiver", "");
        long sentAt = this.database().getLong("mails." + mailId + ".sent-date", 0L);
        long expireAt = this.database().getLong("mails." + mailId + ".expire-date", 0L);
        String displayName = this.config().getString("gui.sent-mail.items.sent-mail-display.name", "");
        meta.setDisplayName(this.plugin.colorize(displayName.replace("%receiver%", receiver).replace("%sent_date%", this.formatDate(sentAt)).replace("%expire_date%", this.formatDate(expireAt))));
        List lore = this.config().getStringList("gui.sent-mail.items.sent-mail-display.lore").stream().map(line -> this.plugin.colorize(line.replace("%receiver%", receiver).replace("%sent_date%", this.formatDate(sentAt)).replace("%expire_date%", this.formatDate(expireAt)).replace("%sent%", this.formatDate(sentAt)).replace("%expire%", this.formatDate(expireAt)))).collect(Collectors.toList());
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING, (Object)mailId);
        item.setItemMeta(meta);
        return item;
    }

    private String applyMailPlaceholders(String input, String sender, String message, long sentAt, long expireAt) {
        return input.replace("%sender%", sender).replace("%message%", message.replace("\n", " ")).replace("%sent%", this.formatDate(sentAt)).replace("%sent_date%", this.formatDate(sentAt)).replace("%expire%", this.formatDate(expireAt)).replace("%expire_date%", this.formatDate(expireAt));
    }

    private String formatDate(long millis) {
        if (millis <= 0L) {
            return this.plugin.colorize(this.config().getString("messages.never-expire", "Never"));
        }
        return new Date(millis).toString();
    }

    private void addDecorations(Inventory inv, String guiPath) {
        if (!this.config().contains(guiPath + ".decoration")) {
            return;
        }
        ConfigurationSection decorSection = this.config().getConfigurationSection(guiPath + ".decoration");
        if (decorSection == null) {
            return;
        }
        for (String decorKey : decorSection.getKeys(false)) {
            String path = guiPath + ".decoration." + decorKey;
            Material material = Material.valueOf((String)this.config().getString(path + ".material"));
            String name = this.config().getString(path + ".name");
            List slots = this.config().getIntegerList(path + ".slots");
            ItemStack decorItem = new ItemStack(material);
            ItemMeta meta = decorItem.getItemMeta();
            meta.setDisplayName(this.plugin.colorize(name));
            decorItem.setItemMeta(meta);
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                inv.setItem(slot, decorItem.clone());
            }
        }
    }

    private void ensureSessionDefaults(MailCreationSession session) {
        if (session.getCommands() == null) {
            session.setCommands(new ArrayList<String>());
        }
        if (session.getItems() == null) {
            session.setItems(new ArrayList<ItemStack>());
        }
        if (session.getCommandBlock() == null) {
            ItemStack defaultBlock = this.createDefaultCommandBlock();
            session.setCommandBlock(defaultBlock);
            session.setDisplayCommandBlock(defaultBlock.clone());
        } else if (session.getDisplayCommandBlock() == null) {
            session.setDisplayCommandBlock(session.getCommandBlock().clone());
        }
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private ItemStack createDefaultCommandBlock() {
        ItemStack commandBlock = new ItemStack(Material.valueOf((String)this.config().getString("gui.create-mail.items.command-block.material")));
        ItemMeta meta = commandBlock.getItemMeta();
        meta.setDisplayName(this.plugin.colorize(this.config().getString("gui.create-mail.items.command-block.name")));
        meta.setLore(this.config().getStringList("gui.create-mail.items.command-block.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        commandBlock.setItemMeta(meta);
        return commandBlock;
    }

    private ItemStack createDisabledFiller() {
        ConfigurationSection decorSection = this.config().getConfigurationSection("gui.create-mail.decoration");
        if (decorSection != null) {
            for (String key : decorSection.getKeys(false)) {
                String base = "gui.create-mail.decoration." + key;
                String materialName = this.config().getString(base + ".material");
                if (materialName == null) continue;
                try {
                    Material material = Material.valueOf((String)materialName);
                    ItemStack filler = new ItemStack(material);
                    ItemMeta meta = filler.getItemMeta();
                    meta.setDisplayName(this.plugin.colorize(this.config().getString(base + ".name", " ")));
                    List lore = this.config().getStringList(base + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList());
                    meta.setLore(lore);
                    filler.setItemMeta(meta);
                    return filler;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        ItemStack fallback = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta meta = fallback.getItemMeta();
        meta.setDisplayName(" ");
        fallback.setItemMeta(meta);
        return fallback;
    }

    private FileConfiguration database() {
        return this.plugin.getMailRepository().getBackingConfiguration();
    }
}

