/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.MailInventoryHandler;
import com.yusaki.lammailbox.session.MailCreationSession;
import com.yusaki.lammailbox.util.ItemSerialization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryClickHandler
implements MailInventoryHandler {
    private final LamMailBox plugin;

    public InventoryClickHandler(LamMailBox plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        boolean isMainGUI;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        ItemStack clicked = event.getCurrentItem();
        String mainTitle = this.plugin.colorize(this.config().getString("gui.main.title"));
        String mainViewingPrefix = this.plugin.colorize(this.config().getString("gui.main.title") + " &7(as ");
        boolean bl = isMainGUI = title.equals(mainTitle) || title.startsWith(mainViewingPrefix);
        if (isMainGUI && event.getClickedInventory() == player.getInventory()) {
            event.setCancelled(true);
            return;
        }
        if (clicked == null || event.getClickedInventory() == event.getWhoClicked().getInventory()) {
            return;
        }
        String sentTitle = this.plugin.colorize(this.config().getString("gui.sent-mail.title"));
        String sentViewingPrefix = this.plugin.colorize(this.config().getString("gui.sent-mail.title") + " &7(as ");
        if (isMainGUI) {
            this.handleMainGuiClick(event, player, clicked);
        } else if (title.equals(sentTitle) || title.startsWith(sentViewingPrefix)) {
            this.handleSentMailGuiClick(event, player, clicked);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.sent-mail-view.title")))) {
            this.handleSentMailViewClick(event, player, clicked);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.create-mail.title")))) {
            this.handleCreateMailGuiClick(event);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.items.title")))) {
            this.handleItemsGuiClick(event);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.mail-view.title")))) {
            this.handleMailViewClick(event, player, clicked);
        }
    }

    @Override
    public void handleClose(InventoryCloseEvent event) {
        boolean isMainGUI;
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        UUID playerId = player.getUniqueId();
        if (title.equals(this.plugin.colorize(this.config().getString("gui.items.title")))) {
            this.onItemsGuiClose(event, player);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.create-mail.title")))) {
            this.onCreateGuiClose(event, player);
        }
        if (!this.plugin.getAwaitingInput().containsKey(playerId)) {
            this.plugin.getInMailCreation().remove(playerId);
        }
        this.plugin.getDeleteConfirmations().remove(playerId);
        String mainTitle = this.plugin.colorize(this.config().getString("gui.main.title"));
        String mainViewingPrefix = this.plugin.colorize(this.config().getString("gui.main.title") + " &7(as ");
        boolean bl = isMainGUI = title.equals(mainTitle) || title.startsWith(mainViewingPrefix);
        if (isMainGUI) {
            this.plugin.getViewingAsPlayer().remove(playerId);
        }
    }

    private void handleMainGuiClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (event.getSlot() == this.config().getInt("gui.main.items.create-mail.slot")) {
            String viewingAs = this.plugin.getViewingAsPlayer().get(player.getUniqueId());
            if (viewingAs != null) {
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.cannot-create-as-other")));
                return;
            }
            this.plugin.openCreateMailGUI(player);
            return;
        }
        if (event.getSlot() == this.config().getInt("gui.main.items.sent-mail.slot")) {
            this.plugin.openSentMailGUI(player);
            return;
        }
        if (this.config().getIntegerList("gui.main.items.mail-display.slots").contains(event.getSlot()) && (mailId = this.getMailId(clicked)) != null) {
            this.plugin.openMailView(player, mailId);
        }
    }

    private void handleSentMailGuiClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (event.getSlot() == this.config().getInt("gui.sent-mail.items.back-button.slot")) {
            String viewingAs = this.plugin.getViewingAsPlayer().get(player.getUniqueId());
            if (viewingAs != null) {
                Player target = Bukkit.getPlayer((String)viewingAs);
                if (target != null) {
                    this.plugin.openMailboxAsPlayer(player, target);
                } else {
                    this.plugin.getViewingAsPlayer().remove(player.getUniqueId());
                    this.plugin.openMainGUI(player);
                }
            } else {
                this.plugin.openMainGUI(player);
            }
            return;
        }
        if (this.config().getIntegerList("gui.sent-mail.items.sent-mail-display.slots").contains(event.getSlot()) && (mailId = this.getMailId(clicked)) != null) {
            this.plugin.openSentMailView(player, mailId);
        }
    }

    private void handleSentMailViewClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (event.getSlot() == this.config().getInt("gui.sent-mail-view.items.delete-button.slot") && (mailId = this.getMailId(clicked)) != null) {
            this.plugin.handleSentMailDelete(player, mailId);
        }
    }

    private void handleCreateMailGuiClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (player.hasPermission(this.config().getString("settings.admin-permission")) && event.getClickedInventory() == player.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player p = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        MailCreationSession session = this.plugin.getMailSessions().get(p.getUniqueId());
        if (session == null) {
            return;
        }
        int slot = event.getSlot();
        if (slot == this.config().getInt("gui.create-mail.items.receiver-head.slot")) {
            this.onReceiverHeadClick(p);
        } else if (slot == this.config().getInt("gui.create-mail.items.message-paper.slot")) {
            this.onMessagePaperClick(p);
        } else if (slot == this.config().getInt("gui.create-mail.items.items-chest.slot")) {
            if (!p.hasPermission(this.config().getString("settings.permissions.add-items"))) {
                p.sendMessage(this.plugin.colorize(this.config().getString("messages.no-permission")));
                return;
            }
            this.plugin.openItemsGUI(p);
        } else if (slot == this.config().getInt("gui.create-mail.items.send-button.slot")) {
            this.plugin.handleMailSend(p);
        } else if (slot == this.config().getInt("gui.create-mail.items.command-block.slot")) {
            if (event.getClick().isRightClick()) {
                this.removeLastCommandAndRefresh(p, session);
            } else {
                this.handleCommandBlockItem(p, event, session);
            }
        } else if (slot == this.config().getInt("gui.create-mail.items.schedule-clock.slot")) {
            this.handleScheduleClockClick(event, p);
        }
    }

    private void handleItemsGuiClick(InventoryClickEvent event) {
        if (event.getSlot() == this.config().getInt("gui.items.items.save-button.slot")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
            if (session != null) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                Inventory inv = event.getInventory();
                for (int i = 0; i < inv.getSize() - 1; ++i) {
                    ItemStack item = inv.getItem(i);
                    if (item == null || i == this.config().getInt("gui.items.items.save-button.slot")) continue;
                    items.add(item.clone());
                }
                session.setItems(items);
                player.closeInventory();
            }
        }
    }

    private void handleMailViewClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (event.getSlot() == this.config().getInt("gui.mail-view.items.claim-button.slot") && (mailId = this.getMailId(clicked)) != null) {
            this.handleMailClaim(player, mailId);
        }
    }

    private void onReceiverHeadClick(Player player) {
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        player.closeInventory();
        this.plugin.getAwaitingInput().put(player.getUniqueId(), "receiver");
        this.plugin.getMailCreationController().showInputTitle(player, "receiver");
        player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.enter-receiver")));
    }

    private void onMessagePaperClick(Player player) {
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        player.closeInventory();
        this.plugin.getAwaitingInput().put(player.getUniqueId(), "message");
        this.plugin.getMailCreationController().showInputTitle(player, "message");
        player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.enter-message")));
    }

    private void handleScheduleClockClick(InventoryClickEvent event, Player player) {
        if (!player.hasPermission(this.config().getString("settings.admin-permission"))) {
            return;
        }
        player.closeInventory();
        if (event.getClick().isRightClick()) {
            this.plugin.getAwaitingInput().put(player.getUniqueId(), "expire-date");
            this.plugin.getMailCreationController().showInputTitle(player, "expire");
            player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.enter-expire-date")));
        } else {
            this.plugin.getAwaitingInput().put(player.getUniqueId(), "schedule-date");
            this.plugin.getMailCreationController().showInputTitle(player, "schedule");
            player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.enter-schedule-date")));
        }
    }

    private void removeLastCommandAndRefresh(Player player, MailCreationSession session) {
        ArrayList<String> commands = new ArrayList<String>(session.getCommands());
        if (commands.isEmpty()) {
            return;
        }
        commands.remove(commands.size() - 1);
        session.setCommands(commands);
        ItemStack commandBlock = session.getCommandBlock();
        if (commandBlock == null) {
            return;
        }
        ItemStack displayBlock = commandBlock.clone();
        ItemMeta meta = displayBlock.getItemMeta();
        ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
        lore.add(this.plugin.colorize(this.config().getString("gui.create-mail.items.command-block.commands-prefix")));
        for (String cmd : commands) {
            lore.add(this.plugin.colorize(this.config().getString("gui.create-mail.items.command-block.command-format").replace("%command%", cmd)));
        }
        meta.setLore(lore);
        displayBlock.setItemMeta(meta);
        session.setDisplayCommandBlock(displayBlock);
        this.plugin.openCreateMailGUI(player);
    }

    private void handleCommandBlockItem(Player player, InventoryClickEvent event, MailCreationSession session) {
        if (!player.hasPermission(this.config().getString("settings.admin-permission"))) {
            return;
        }
        ItemStack cursor = event.getCursor();
        if (cursor != null && !cursor.getType().isAir()) {
            ArrayList<String> commands = new ArrayList<String>(session.getCommands());
            session.setCommandBlock(cursor.clone());
            ItemStack displayBlock = cursor.clone();
            ItemMeta meta = displayBlock.getItemMeta();
            ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
            lore.add(this.plugin.colorize(this.config().getString("messages.command-prefix")));
            for (String cmd : commands) {
                lore.add(this.plugin.colorize(this.config().getString("messages.command-format-display").replace("%command%", cmd)));
            }
            meta.setLore(lore);
            displayBlock.setItemMeta(meta);
            session.setDisplayCommandBlock(displayBlock);
            event.getView().setCursor(null);
            this.plugin.openCreateMailGUI(player);
        } else {
            this.plugin.getAwaitingInput().put(player.getUniqueId(), "command");
            this.plugin.getMailCreationController().showInputTitle(player, "command");
            player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.enter-command")));
            player.closeInventory();
        }
    }

    private void handleMailClaim(Player player, String mailId) {
        boolean hasRewards;
        String dbPath = "mails." + mailId + ".";
        List serializedItems = this.database().getStringList(dbPath + "items");
        List<ItemStack> items = serializedItems.stream().map(ItemSerialization::deserializeItem).filter(Objects::nonNull).collect(Collectors.toList());
        List commands = this.database().getStringList(dbPath + "commands");
        boolean bl = hasRewards = !items.isEmpty() || !commands.isEmpty();
        if (!items.isEmpty()) {
            long emptySlots = Arrays.stream(player.getInventory().getStorageContents()).filter(item -> item == null || item.getType() == Material.AIR).count();
            if (emptySlots < (long)items.size()) {
                player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.inventory-space-needed").replace("%amount%", String.valueOf(items.size()))));
                return;
            }
            items.forEach(item -> player.getInventory().addItem(new ItemStack[]{item}));
        }
        if (!commands.isEmpty()) {
            this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
                for (String command : commands) {
                    String processed = command.replace("%player%", player.getName());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processed);
                }
            });
        }
        this.plugin.getMailService().claimMail(player, mailId);
        player.closeInventory();
        this.plugin.openMainGUI(player);
        String messageKey = hasRewards ? "messages.items-claimed" : "messages.no-items-in-mail";
        player.sendMessage(this.plugin.colorize(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString(messageKey)));
    }

    private void onItemsGuiClose(InventoryCloseEvent event, Player player) {
        MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
        if (session != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Material saveButtonMaterial = Material.valueOf((String)this.config().getString("gui.items.items.save-button.material"));
            for (int i = 0; i < event.getInventory().getSize() - 1; ++i) {
                ItemStack item = event.getInventory().getItem(i);
                if (item == null || item.getType() == saveButtonMaterial) continue;
                items.add(item.clone());
            }
            session.setItems(items);
            this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCreateMailGUI(player));
        }
    }

    private void onCreateGuiClose(InventoryCloseEvent event, Player player) {
        MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
        if (session != null && !player.hasPermission(this.config().getString("settings.admin-permission")) && !this.plugin.getInMailCreation().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            List<ItemStack> items = session.getItems();
            for (ItemStack item : items) {
                HashMap leftover = player.getInventory().addItem(new ItemStack[]{item.clone()});
                leftover.values().forEach(leftItem -> player.getWorld().dropItem(player.getLocation(), leftItem));
            }
            session.setItems(new ArrayList<ItemStack>());
        }
    }

    private String getMailId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING);
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private FileConfiguration database() {
        return this.plugin.getMailRepository().getBackingConfiguration();
    }
}

