/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class StorageSettings {
    private final BackendType backendType;
    private final Path sqlitePath;

    private StorageSettings(BackendType backendType, Path sqlitePath) {
        this.backendType = backendType;
        this.sqlitePath = sqlitePath;
    }

    public static StorageSettings load(JavaPlugin plugin) {
        File storageFile;
        Objects.requireNonNull(plugin, "plugin");
        File dataFolder = plugin.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            plugin.getLogger().warning("Could not create data folder: " + String.valueOf(dataFolder));
        }
        if (!(storageFile = new File(dataFolder, "storage.yml")).exists()) {
            plugin.saveResource("storage.yml", false);
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)storageFile);
        BackendType backend = BackendType.from(yaml.getString("storage.type"), BackendType.SQLITE);
        Path sqlitePath = plugin.getDataFolder().toPath().resolve("mailbox.db");
        try {
            Files.createDirectories(sqlitePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            plugin.getLogger().warning("Could not create directories for SQLite database: " + e.getMessage());
        }
        return new StorageSettings(backend, sqlitePath);
    }

    public BackendType backendType() {
        return this.backendType;
    }

    public Path sqlitePath() {
        return this.sqlitePath;
    }

    public static enum BackendType {
        YAML,
        SQLITE;


        public static BackendType from(String value, BackendType fallback) {
            if (value == null) {
                return fallback;
            }
            try {
                return BackendType.valueOf(value.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return fallback;
            }
        }
    }
}

