/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MailRecord {
    private final String id;
    private final String sender;
    private final String receiver;
    private final String message;
    private final long sentDate;
    private final Long scheduleDate;
    private final Long expireDate;
    private final boolean active;
    private final boolean adminMail;
    private final List<String> claimedPlayers;
    private final List<String> commands;
    private final String commandBlock;

    private MailRecord(String id, String sender, String receiver, String message, long sentDate, Long scheduleDate, Long expireDate, boolean active, boolean adminMail, List<String> claimedPlayers, List<String> commands, String commandBlock) {
        this.id = id;
        this.sender = sender;
        this.receiver = receiver;
        this.message = message;
        this.sentDate = sentDate;
        this.scheduleDate = scheduleDate;
        this.expireDate = expireDate;
        this.active = active;
        this.adminMail = adminMail;
        this.claimedPlayers = Collections.unmodifiableList(new ArrayList<String>(claimedPlayers));
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
        this.commandBlock = commandBlock;
    }

    public static Optional<MailRecord> from(String id, Map<String, Object> raw) {
        if (raw == null || raw.isEmpty()) {
            return Optional.empty();
        }
        String sender = MailRecord.asString(raw.get("sender"));
        String receiver = MailRecord.asString(raw.get("receiver"));
        String message = MailRecord.asString(raw.get("message"));
        long sentDate = MailRecord.asLong(raw.get("sent-date"), 0L);
        Long scheduleDate = MailRecord.asNullableLong(raw.get("schedule-date"));
        Long expireDate = MailRecord.asNullableLong(raw.get("expire-date"));
        boolean active = MailRecord.asBoolean(raw.get("active"), true);
        boolean adminMail = MailRecord.asBoolean(raw.get("is-admin-mail"), false);
        List<String> claimed = MailRecord.asStringList(raw.get("claimed-players"));
        List<String> commands = MailRecord.asStringList(raw.get("commands"));
        String commandBlock = MailRecord.asString(raw.get("command-block"));
        return Optional.of(new MailRecord(id, sender, receiver, message, sentDate, scheduleDate, expireDate, active, adminMail, claimed, commands, commandBlock));
    }

    public String id() {
        return this.id;
    }

    public String sender() {
        return this.sender;
    }

    public String receiver() {
        return this.receiver;
    }

    public String message() {
        return this.message != null ? this.message : "";
    }

    public long sentDate() {
        return this.sentDate;
    }

    public Long scheduleDate() {
        return this.scheduleDate;
    }

    public Long expireDate() {
        return this.expireDate;
    }

    public boolean active() {
        return this.active;
    }

    public boolean isAdminMail() {
        return this.adminMail;
    }

    public List<String> claimedPlayers() {
        return this.claimedPlayers;
    }

    public List<String> commands() {
        return this.commands;
    }

    public String commandBlock() {
        return this.commandBlock;
    }

    public boolean hasBeenClaimedBy(String playerName) {
        return this.claimedPlayers.stream().anyMatch(entry -> entry.equalsIgnoreCase(playerName));
    }

    public boolean canBeClaimedBy(String playerName) {
        if (!this.active || this.receiver == null || this.receiver.isEmpty()) {
            return false;
        }
        String lowerTarget = playerName.toLowerCase(Locale.ROOT);
        if (this.receiver.equalsIgnoreCase("all")) {
            return this.claimedPlayers.stream().noneMatch(name -> name.equalsIgnoreCase(playerName));
        }
        if (this.receiver.contains(";")) {
            return this.getReceiverList().stream().anyMatch(name -> name.equalsIgnoreCase(lowerTarget));
        }
        return this.receiver.equalsIgnoreCase(playerName);
    }

    public boolean isVisibleToSender(String playerName) {
        if (this.sender == null) {
            return false;
        }
        return this.sender.equalsIgnoreCase(playerName);
    }

    public List<String> getReceiverList() {
        if (this.receiver == null || this.receiver.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.receiver.equalsIgnoreCase("all")) {
            return Collections.emptyList();
        }
        if (!this.receiver.contains(";")) {
            return Collections.singletonList(this.receiver);
        }
        String[] parts = this.receiver.split(";");
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            list.add(part);
        }
        return list;
    }

    private static String asString(Object value) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        return str.isEmpty() ? null : str;
    }

    private static boolean asBoolean(Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    private static long asLong(Object value, long defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static Long asNullableLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String && !((String)value).isEmpty()) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<String> asStringList(Object value) {
        if (value instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object entry : (List)value) {
                String str;
                if (entry == null || (str = Objects.toString(entry, "")).isEmpty()) continue;
                list.add(str);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

