/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.repository;

import com.yusaki.lammailbox.repository.MailRecord;
import com.yusaki.lammailbox.repository.MailRepository;
import com.yusaki.lammailbox.util.ItemSerialization;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class YamlMailRepository
implements MailRepository {
    private final JavaPlugin plugin;
    private final File databaseFile;
    private final FileConfiguration database;

    public YamlMailRepository(JavaPlugin plugin) {
        this.plugin = plugin;
        this.databaseFile = this.ensureDatabaseFile(plugin);
        this.database = YamlConfiguration.loadConfiguration((File)this.databaseFile);
    }

    private File ensureDatabaseFile(JavaPlugin plugin) {
        File file = new File(plugin.getDataFolder(), "database.yml");
        if (!file.exists()) {
            plugin.saveResource("database.yml", false);
        }
        return file;
    }

    @Override
    public Map<String, Object> loadMail(String mailId) {
        ConfigurationSection section = this.getMailSection(mailId, false);
        return section != null ? section.getValues(true) : Collections.emptyMap();
    }

    @Override
    public void saveMail(String mailId, Map<String, Object> data) {
        String base = "mails." + mailId + ".";
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            this.database.set(base + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void deleteMail(String mailId) {
        this.database.set("mails." + mailId, null);
    }

    @Override
    public List<String> listMailIds() {
        if (!this.database.contains("mails")) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Objects.requireNonNull(this.database.getConfigurationSection("mails")).getKeys(false));
    }

    @Override
    public List<String> listMailIdsBySender(String sender) {
        return this.listMailIds().stream().filter(id -> sender.equals(this.database.getString("mails." + id + ".sender"))).collect(Collectors.toList());
    }

    @Override
    public List<String> listActiveMailIdsFor(String playerName) {
        if (!this.database.contains("mails")) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String mailId : this.listMailIds()) {
            String base = "mails." + mailId + ".";
            boolean isActive = this.database.getBoolean(base + "active", true);
            if (!isActive) continue;
            String receiver = this.database.getString(base + "receiver");
            List claimed = this.database.getStringList(base + "claimed-players");
            if (receiver == null) continue;
            if (receiver.equals("all")) {
                if (claimed.contains(playerName)) continue;
                result.add(mailId);
                continue;
            }
            if (receiver.contains(";")) {
                List<String> receivers = Arrays.asList(receiver.split(";"));
                if (!receivers.contains(playerName)) continue;
                result.add(mailId);
                continue;
            }
            if (!receiver.equals(playerName)) continue;
            result.add(mailId);
        }
        return result;
    }

    @Override
    public Optional<Map<String, Object>> findMail(String mailId) {
        if (!this.database.contains("mails." + mailId)) {
            return Optional.empty();
        }
        return Optional.of(this.loadMail(mailId));
    }

    @Override
    public void save() {
        try {
            this.database.save(this.databaseFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save database: " + e.getMessage());
        }
    }

    @Override
    public void saveMailItems(String mailId, List<ItemStack> items) {
        List<String> serialized = ItemSerialization.serializeItems(items);
        this.database.set("mails." + mailId + ".items", serialized);
    }

    @Override
    public List<ItemStack> loadMailItems(String mailId) {
        List serialized = this.database.getStringList("mails." + mailId + ".items");
        return ItemSerialization.deserializeItems(serialized);
    }

    @Override
    public Optional<MailRecord> findRecord(String mailId) {
        return this.findMail(mailId).flatMap(data -> MailRecord.from(mailId, data));
    }

    @Override
    public int countActiveMailFor(String playerName) {
        return this.listActiveMailIdsFor(playerName).size();
    }

    private ConfigurationSection getMailSection(String mailId, boolean create) {
        String path = "mails." + mailId;
        if (this.database.contains(path)) {
            return this.database.getConfigurationSection(path);
        }
        if (create) {
            return this.database.createSection(path);
        }
        return null;
    }

    @Override
    public void shutdown() {
        this.save();
    }
}

