/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox;

import com.yusaki.lammailbox.command.LmbCommandExecutor;
import com.yusaki.lammailbox.command.LmbMigrateCommand;
import com.yusaki.lammailbox.command.LmbTabComplete;
import com.yusaki.lammailbox.config.MailBoxConfigUpdater;
import com.yusaki.lammailbox.config.StorageSettings;
import com.yusaki.lammailbox.gui.ConfigMailGuiFactory;
import com.yusaki.lammailbox.gui.InventoryClickHandler;
import com.yusaki.lammailbox.gui.MailGuiFactory;
import com.yusaki.lammailbox.lib.cronutils.descriptor.CronDescriptor;
import com.yusaki.lammailbox.lib.cronutils.model.Cron;
import com.yusaki.lammailbox.lib.cronutils.model.CronType;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinition;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinitionBuilder;
import com.yusaki.lammailbox.lib.cronutils.parser.CronParser;
import com.yusaki.lammailbox.lib.folialib.FoliaLib;
import com.yusaki.lammailbox.mailing.MailingConfigLoader;
import com.yusaki.lammailbox.mailing.MailingDefinition;
import com.yusaki.lammailbox.mailing.MailingScheduler;
import com.yusaki.lammailbox.mailing.status.MailingStatusRepository;
import com.yusaki.lammailbox.mailing.status.SqliteMailingStatusRepository;
import com.yusaki.lammailbox.mailing.status.YamlMailingStatusRepository;
import com.yusaki.lammailbox.repository.MailRepository;
import com.yusaki.lammailbox.repository.SqliteMailRepository;
import com.yusaki.lammailbox.repository.YamlMailRepository;
import com.yusaki.lammailbox.service.DefaultMailService;
import com.yusaki.lammailbox.service.MailDelivery;
import com.yusaki.lammailbox.service.MailService;
import com.yusaki.lammailbox.session.MailCreationController;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.yusaki.lib.YskLib;
import org.yusaki.lib.modules.MessageManager;

public class LamMailBox
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private MailRepository mailRepository;
    private MailService mailService;
    private StorageSettings.BackendType activeBackend;
    private YskLib yskLib;
    private MessageManager messageManager;
    private Map<UUID, MailCreationSession> mailSessions;
    private Map<UUID, String> awaitingInput;
    private Map<UUID, Boolean> inMailCreation;
    private Map<UUID, String> deleteConfirmations;
    private Map<UUID, String> viewingAsPlayer;
    private Map<UUID, Integer> mailViewPages;
    private Map<UUID, Integer> mailboxPages;
    private Map<UUID, Integer> sentMailboxPages;
    private FoliaLib foliaLib;
    private InventoryClickHandler inventoryClickHandler;
    private MailGuiFactory mailGuiFactory;
    private MailCreationController mailCreationController;
    private MailBoxConfigUpdater configUpdater;
    private MailingConfigLoader mailingConfigLoader;
    private MailingStatusRepository mailingStatusRepository;
    private MailingScheduler mailingScheduler;
    private List<MailingDefinition> mailingDefinitions;
    private boolean mailingAutoCleanup;
    private CronParser cronParser;
    private CronDescriptor cronDescriptor;

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX);
        this.cronParser = new CronParser(cronDefinition);
        this.cronDescriptor = CronDescriptor.instance(Locale.getDefault());
        this.configUpdater = new MailBoxConfigUpdater(this);
        this.configUpdater.updateConfigs();
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.yskLib = (YskLib)this.getServer().getPluginManager().getPlugin("YskLib");
        if (this.yskLib == null) {
            this.getLogger().severe("YskLib not found! Please install YskLib 1.6.4 or above.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.yskLib.loadMessages((JavaPlugin)this);
        this.messageManager = this.yskLib.getMessageManager();
        StorageSettings storageSettings = StorageSettings.load(this);
        this.mailRepository = this.createRepository(storageSettings);
        this.mailService = new DefaultMailService(this, this.mailRepository, this.foliaLib);
        this.mailSessions = new HashMap<UUID, MailCreationSession>();
        this.awaitingInput = new HashMap<UUID, String>();
        this.inMailCreation = new HashMap<UUID, Boolean>();
        this.deleteConfirmations = new HashMap<UUID, String>();
        this.viewingAsPlayer = new HashMap<UUID, String>();
        this.mailViewPages = new HashMap<UUID, Integer>();
        this.mailboxPages = new HashMap<UUID, Integer>();
        this.sentMailboxPages = new HashMap<UUID, Integer>();
        this.inventoryClickHandler = new InventoryClickHandler(this);
        this.mailGuiFactory = new ConfigMailGuiFactory(this);
        this.mailCreationController = new MailCreationController(this);
        this.applyCommandAliases();
        this.mailingConfigLoader = new MailingConfigLoader(this);
        this.mailingConfigLoader.saveDefaultIfMissing();
        this.mailingStatusRepository = this.createMailingStatusRepository(storageSettings);
        this.mailingDefinitions = this.mailingConfigLoader.load();
        this.mailingAutoCleanup = this.getConfig().getBoolean("mailings.auto-cleanup", true);
        this.performMailingCleanup();
        this.mailingScheduler = new MailingScheduler(this, this.mailService, this.mailingStatusRepository, this.foliaLib);
        this.mailingScheduler.start(this.mailingDefinitions);
        LmbCommandExecutor lmbCommandExecutor = new LmbCommandExecutor(this);
        LmbTabComplete tabCompleter = new LmbTabComplete(this);
        this.getCommand("lmb").setExecutor((CommandExecutor)lmbCommandExecutor);
        this.getCommand("lmb").setTabCompleter((TabCompleter)tabCompleter);
        this.getCommand("lmbmigrate").setExecutor((CommandExecutor)new LmbMigrateCommand(this));
        this.getCommand("lmbmigrate").setTabCompleter((TabCompleter)tabCompleter);
        this.getCommand("lmbreload").setExecutor((sender, cmd, label, args) -> {
            if (!sender.hasPermission(this.config.getString("settings.permissions.reload"))) {
                sender.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
                return true;
            }
            this.configUpdater.updateConfigs();
            this.reloadConfig();
            this.config = this.getConfig();
            this.mailingAutoCleanup = this.config.getBoolean("mailings.auto-cleanup", true);
            this.applyCommandAliases();
            this.reloadMailings();
            sender.sendMessage(this.colorize(this.config.getString("messages.reload-success")));
            List<MailingDefinition> definitions = this.getMailingDefinitions();
            if (!definitions.isEmpty()) {
                long activeCount = definitions.stream().filter(MailingDefinition::enabled).count();
                String summary = this.config.getString("messages.prefix") + "&7Mailings active: &a" + activeCount + "&7/&f" + definitions.size();
                sender.sendMessage(this.colorize(summary));
                if (activeCount > 0L) {
                    int previewLimit = 5;
                    List activeIds = definitions.stream().filter(MailingDefinition::enabled).map(MailingDefinition::id).collect(Collectors.toList());
                    List preview = activeIds.size() > previewLimit ? activeIds.subList(0, previewLimit) : activeIds;
                    String idsLine = String.join((CharSequence)"&f, ", preview);
                    String detail = this.config.getString("messages.prefix") + "&7Active IDs: &f" + idsLine;
                    if (activeIds.size() > previewLimit) {
                        detail = detail + " &7(+" + (activeIds.size() - previewLimit) + " more)";
                    }
                    sender.sendMessage(this.colorize(detail));
                }
            } else {
                String emptyMessage = this.getMailingsMessage("empty", "&7No mailings configured.");
                sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + emptyMessage));
            }
            return true;
        });
        this.foliaLib.getScheduler().runTimer(() -> this.checkScheduledMails(), 1200L, 1200L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startCleanupTask();
    }

    public void onDisable() {
        if (this.mailRepository != null) {
            this.mailRepository.shutdown();
        }
        if (this.mailingScheduler != null) {
            this.mailingScheduler.shutdown();
        }
        if (this.mailingStatusRepository != null) {
            this.mailingStatusRepository.shutdown();
        }
    }

    private void checkScheduledMails() {
        List<MailDelivery> toNotify = this.mailService.schedulePendingMails();
        toNotify.forEach(delivery -> this.notifyRecipients(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName()));
    }

    private void startCleanupTask() {
        this.foliaLib.getScheduler().runTimer(() -> this.cleanupExpiredMails(), 72000L, 72000L);
    }

    private void cleanupExpiredMails() {
        this.mailService.removeExpiredMails();
    }

    public void openMainGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.open"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createMailbox(player));
    }

    public void openMailboxAsPlayer(Player admin, Player targetPlayer) {
        if (!admin.hasPermission(this.config.getString("settings.permissions.view-as"))) {
            admin.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        this.viewingAsPlayer.put(admin.getUniqueId(), targetPlayer.getName());
        admin.openInventory(this.mailGuiFactory.createMailboxAs(admin, targetPlayer));
    }

    public void openSentMailGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.open"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createSentMailbox(player));
    }

    public void openSentMailView(Player player, String mailId) {
        player.openInventory(this.mailGuiFactory.createSentMailView(player, mailId));
    }

    public void handleSentMailDelete(Player player, String mailId) {
        if (!player.hasPermission(this.config.getString("settings.permissions.delete"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        String confirmingMailId = this.deleteConfirmations.get(player.getUniqueId());
        if (confirmingMailId != null && confirmingMailId.equals(mailId)) {
            this.mailService.deleteMail(mailId);
            this.deleteConfirmations.remove(player.getUniqueId());
            player.closeInventory();
            this.openSentMailGUI(player);
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.mail-deleted")));
        } else {
            this.deleteConfirmations.put(player.getUniqueId(), mailId);
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.delete-confirmation")));
        }
    }

    public void openCreateMailGUI(Player player) {
        if (!player.hasPermission(this.config.getString("settings.permissions.compose"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        player.openInventory(this.mailGuiFactory.createMailCreation(player));
    }

    public void openItemsGUI(Player player) {
        this.inMailCreation.put(player.getUniqueId(), true);
        player.openInventory(this.mailGuiFactory.createItemsEditor(player));
    }

    public void openCommandItemsEditor(Player player) {
        if (!player.hasPermission(this.config.getString("settings.admin-permission"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        this.inMailCreation.put(player.getUniqueId(), true);
        player.openInventory(this.mailGuiFactory.createCommandItemsEditor(player));
    }

    public void openCommandItemCreator(Player player) {
        if (!player.hasPermission(this.config.getString("settings.admin-permission"))) {
            player.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.no-permission")));
            return;
        }
        this.inMailCreation.put(player.getUniqueId(), true);
        player.openInventory(this.mailGuiFactory.createCommandItemCreator(player));
    }

    private void checkPlayerMails(Player player) {
        String playerName = player.getName();
        for (String mailId : this.mailRepository.listActiveMailIdsFor(playerName)) {
            this.mailRepository.findRecord(mailId).ifPresent(record -> {
                if (record.canBeClaimedBy(playerName)) {
                    String sender = Optional.ofNullable(record.sender()).orElse("Console");
                    this.sendMailNotification(player, mailId, sender);
                }
            });
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("settings.join-notification")) {
            return;
        }
        Player player = event.getPlayer();
        this.checkPlayerMails(player);
        if (this.mailingScheduler != null) {
            this.mailingScheduler.handlePlayerJoin(player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        this.inventoryClickHandler.handleClick(event);
    }

    public void openMailView(Player player, String mailId) {
        player.openInventory(this.mailGuiFactory.createMailView(player, mailId));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String inputType = this.awaitingInput.remove(player.getUniqueId());
        if (inputType == null) {
            return;
        }
        event.setCancelled(true);
        MailCreationSession session = this.mailSessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        boolean success = true;
        String customSubtitle = null;
        String message = event.getMessage();
        boolean reopenMailCreation = false;
        boolean reopenCommandCreator = false;
        switch (inputType) {
            case "receiver": {
                success = this.mailCreationController.handleReceiverInput(player, message, session);
                customSubtitle = success ? this.applyPlaceholderVariants(this.config.getString("messages.current-receiver"), "receiver", message) : this.config.getString("messages.invalid-receiver");
                reopenMailCreation = true;
                break;
            }
            case "message": {
                session.setMessage(message.replace("\\n", "\n"));
                customSubtitle = this.config.getString("messages.current-message");
                this.mailCreationController.reopenCreationAsync(player);
                break;
            }
            case "command": {
                success = this.mailCreationController.handleCommandInput(player, message, session);
                customSubtitle = this.applyPlaceholderVariants(this.config.getString("messages.command-format-display"), "command", message);
                this.mailCreationController.reopenCreationAsync(player);
                break;
            }
            case "schedule-date": {
                success = this.mailCreationController.handleDateInput(player, message, session, true);
                customSubtitle = success && session.getScheduleDate() != null ? this.applyPlaceholderVariants(this.config.getString("messages.schedule-set"), "date", new Date(session.getScheduleDate()).toString()) : this.config.getString("messages.invalid-date-format");
                reopenMailCreation = true;
                break;
            }
            case "expire-date": {
                success = this.mailCreationController.handleDateInput(player, message, session, false);
                customSubtitle = success && session.getExpireDate() != null ? this.applyPlaceholderVariants(this.config.getString("messages.expire-set"), "date", new Date(session.getExpireDate()).toString()) : this.config.getString("messages.invalid-date-format");
                reopenMailCreation = true;
                break;
            }
            case "command-item-material": {
                success = this.mailCreationController.handleCommandItemMaterialInput(player, message, session);
                customSubtitle = success ? this.config.getString("messages.command-item-material-set", "&a\u2714 Command item material updated.") : this.config.getString("messages.invalid-material", "&c\u2716 Invalid material!");
                reopenCommandCreator = true;
                break;
            }
            case "command-item-name": {
                success = this.mailCreationController.handleCommandItemNameInput(player, message, session);
                customSubtitle = success ? this.config.getString("messages.command-item-name-set", "&a\u2714 Display name updated.") : this.config.getString("messages.command-item-name-failed", "&c\u2716 Name update failed.");
                reopenCommandCreator = true;
                break;
            }
            case "command-item-lore": {
                success = this.mailCreationController.handleCommandItemLoreInput(player, message, session);
                customSubtitle = success ? this.config.getString("messages.command-item-lore-added", "&a\u2714 Added lore line.") : this.config.getString("messages.command-item-lore-failed", "&c\u2716 Lore update failed");
                reopenCommandCreator = true;
                break;
            }
            case "command-item-command": {
                success = this.mailCreationController.handleCommandItemCommandInput(player, message, session);
                customSubtitle = success ? this.config.getString("messages.command-item-command-added", "&a\u2714 Added command.") : this.config.getString("messages.command-item-command-failed", "&c\u2716 Command update failed");
                reopenCommandCreator = true;
                break;
            }
            case "command-item-custom-model": {
                String trimmed = message == null ? "" : message.trim();
                success = this.mailCreationController.handleCommandItemCustomModelInput(player, message, session);
                customSubtitle = success ? (trimmed.isEmpty() || trimmed.equalsIgnoreCase("clear") || trimmed.equalsIgnoreCase("none") || trimmed.equalsIgnoreCase("reset") ? this.config.getString("messages.command-item-model-cleared", "&a\u2714 Custom model data cleared.") : this.applyPlaceholderVariants(this.config.getString("messages.command-item-model-set", "&a\u2714 Custom model data updated."), "value", trimmed)) : this.config.getString("messages.command-item-model-invalid", "&c\u2716 Invalid custom model data.");
                reopenCommandCreator = true;
                break;
            }
            default: {
                success = false;
            }
        }
        this.mailCreationController.showResponseTitle(player, success, customSubtitle);
        if (reopenCommandCreator) {
            this.mailCreationController.reopenCommandItemCreatorAsync(player);
        } else if (reopenMailCreation) {
            this.mailCreationController.reopenCreationAsync(player);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (this.awaitingInput.containsKey(player.getUniqueId())) {
                this.awaitingInput.remove(player.getUniqueId());
                this.foliaLib.getScheduler().runNextTick(Task -> this.openCreateMailGUI(player));
            }
            this.deleteConfirmations.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.inventoryClickHandler.handleClose(event);
    }

    public void handleMailSend(Player sender) {
        MailDelivery delivery;
        MailCreationSession session = this.mailSessions.get(sender.getUniqueId());
        if (session == null || !session.isComplete()) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.incomplete-mail")));
            return;
        }
        this.inMailCreation.remove(sender.getUniqueId());
        try {
            delivery = this.mailService.sendMail(sender, session);
        }
        catch (IllegalArgumentException ex) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.incomplete-mail")));
            return;
        }
        if (delivery.shouldNotifyNow()) {
            this.notifyRecipients(delivery.getReceiverSpec(), delivery.getMailId(), delivery.getSenderName());
        }
        this.mailSessions.remove(sender.getUniqueId());
        sender.closeInventory();
        Long scheduleDate = session.getScheduleDate();
        if (scheduleDate != null && scheduleDate > System.currentTimeMillis()) {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.applyPlaceholderVariants(this.config.getString("messages.schedule-set"), "date", new Date(scheduleDate).toString())));
        } else {
            sender.sendMessage(this.colorize(this.config.getString("messages.prefix") + this.config.getString("messages.mail-sent")));
        }
    }

    @Deprecated
    public String colorize(String text) {
        return text.replace("&", "\u00a7");
    }

    public String applyPlaceholderVariants(String template, String key, String value) {
        if (template == null || key == null) {
            return template;
        }
        String normalized = this.normalizePlaceholderKey(key);
        String safeValue = value == null ? "" : value;
        String result = template;
        result = result.replace("{" + normalized + "}", safeValue);
        result = result.replace("%" + normalized + "%", safeValue);
        if (!key.equals("{" + normalized + "}") && !key.equals("%" + normalized + "%")) {
            result = result.replace(key, safeValue);
        }
        return result;
    }

    public String applyPlaceholderVariants(String template, Map<String, String> placeholders) {
        if (template == null || placeholders == null || placeholders.isEmpty()) {
            return template;
        }
        String result = template;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            result = this.applyPlaceholderVariants(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String normalizePlaceholderKey(String key) {
        if (key == null || key.length() < 2) {
            return key == null ? "" : key;
        }
        if (key.startsWith("{") && key.endsWith("}") || key.startsWith("%") && key.endsWith("%")) {
            return key.substring(1, key.length() - 1);
        }
        return key;
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        return this.messageManager.getMessage((JavaPlugin)this, key, placeholders);
    }

    public String getMessage(String key) {
        return this.messageManager.getMessage((JavaPlugin)this, key);
    }

    public void sendMessage(CommandSender sender, String key, Map<String, String> placeholders) {
        this.messageManager.sendMessage((JavaPlugin)this, sender, key, placeholders);
    }

    public void sendMessage(CommandSender sender, String key) {
        this.messageManager.sendMessage((JavaPlugin)this, sender, key);
    }

    public Map<String, String> placeholders(String ... keyValuePairs) {
        return MessageManager.placeholders((String[])keyValuePairs);
    }

    public String getMailingsMessage(String key, String fallback) {
        String path = "messages.mailings." + key;
        return this.config.getString(path, fallback);
    }

    public String describeCron(String expression) {
        if (expression == null || expression.isBlank()) {
            return expression;
        }
        if (this.cronParser == null || this.cronDescriptor == null) {
            return expression;
        }
        try {
            Cron cron = this.cronParser.parse(expression);
            cron.validate();
            return this.cronDescriptor.describe(cron);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().fine(() -> "Unable to describe cron expression '" + expression + "': " + ex.getMessage());
            return expression;
        }
        catch (Exception ex) {
            this.getLogger().fine(() -> "Unexpected error describing cron expression '" + expression + "': " + ex.getMessage());
            return expression;
        }
    }

    private void sendMailNotification(Player receiver, String mailId, String sender) {
        String sound;
        if (this.config.getBoolean("settings.notification.chat-enabled")) {
            String chatMessage = this.applyPlaceholderVariants(this.config.getString("messages.new-mail-clickable"), "sender", sender);
            TextComponent message = new TextComponent(this.colorize(this.config.getString("messages.prefix") + chatMessage));
            String command = "/" + this.getPrimaryCommand() + " view " + mailId;
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
            receiver.spigot().sendMessage((BaseComponent)message);
        }
        if (this.config.getBoolean("settings.notification.title-enabled")) {
            String title = this.colorize(this.applyPlaceholderVariants(this.config.getString("titles.notification.title"), "sender", sender));
            String subtitle = this.colorize(this.applyPlaceholderVariants(this.config.getString("titles.notification.subtitle"), "sender", sender));
            int fadeIn = this.config.getInt("titles.notification.fadein");
            int stay = this.config.getInt("titles.notification.stay");
            int fadeOut = this.config.getInt("titles.notification.fadeout");
            receiver.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
        }
        if ((sound = this.config.getString("settings.notification.sound")) != null && !sound.isEmpty()) {
            float volume = (float)this.config.getDouble("settings.notification.volume");
            float pitch = (float)this.config.getDouble("settings.notification.pitch");
            receiver.playSound(receiver.getLocation(), Sound.valueOf((String)sound), volume, pitch);
        }
    }

    private void notifyRecipients(String receiverSpec, String mailId, String senderName) {
        if (receiverSpec == null || receiverSpec.isEmpty()) {
            return;
        }
        if (receiverSpec.equalsIgnoreCase("all")) {
            Bukkit.getOnlinePlayers().forEach(player -> this.scheduleNotification((Player)player, mailId, senderName));
            return;
        }
        if (receiverSpec.contains(";")) {
            Arrays.stream(receiverSpec.split(";")).map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> this.scheduleNotification((Player)player, mailId, senderName));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)receiverSpec);
        if (receiver != null) {
            this.scheduleNotification(receiver, mailId, senderName);
        }
    }

    private void scheduleNotification(Player player, String mailId, String senderName) {
        this.foliaLib.getScheduler().runAtEntity((Entity)player, task -> {
            if (player.isOnline()) {
                this.sendMailNotification(player, mailId, senderName);
            }
        });
    }

    public void dispatchMailNotifications(String receiverSpec, String mailId, String senderName) {
        this.notifyRecipients(receiverSpec, mailId, senderName);
    }

    public MailCreationController getMailCreationController() {
        return this.mailCreationController;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public MailRepository getMailRepository() {
        return this.mailRepository;
    }

    public Map<UUID, MailCreationSession> getMailSessions() {
        return this.mailSessions;
    }

    public Map<UUID, String> getAwaitingInput() {
        return this.awaitingInput;
    }

    public Map<UUID, Boolean> getInMailCreation() {
        return this.inMailCreation;
    }

    public Map<UUID, String> getDeleteConfirmations() {
        return this.deleteConfirmations;
    }

    public Map<UUID, String> getViewingAsPlayer() {
        return this.viewingAsPlayer;
    }

    public Map<UUID, Integer> getMailViewPages() {
        return this.mailViewPages;
    }

    public Map<UUID, Integer> getMailboxPages() {
        return this.mailboxPages;
    }

    public Map<UUID, Integer> getSentMailboxPages() {
        return this.sentMailboxPages;
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public MailBoxConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }

    public StorageSettings.BackendType getActiveBackend() {
        return this.activeBackend;
    }

    public MailRepository buildRepository(StorageSettings settings, StorageSettings.BackendType backendType, boolean allowImport) {
        if (backendType == StorageSettings.BackendType.SQLITE) {
            return new SqliteMailRepository(this, settings.sqlitePath());
        }
        return new YamlMailRepository(this);
    }

    private MailRepository createRepository(StorageSettings settings) {
        MailRepository repository = this.buildRepository(settings, settings.backendType(), true);
        if (settings.backendType() == StorageSettings.BackendType.SQLITE) {
            this.getLogger().info("Loaded LamMailBox using SQLite storage");
        } else {
            this.getLogger().info("Loaded LamMailBox using YAML storage");
        }
        this.activeBackend = settings.backendType();
        return repository;
    }

    private MailingStatusRepository createMailingStatusRepository(StorageSettings settings) {
        if (settings.backendType() == StorageSettings.BackendType.SQLITE) {
            return new SqliteMailingStatusRepository(this, settings.sqlitePath());
        }
        return new YamlMailingStatusRepository(this);
    }

    public void reloadMailings() {
        this.mailingConfigLoader.saveDefaultIfMissing();
        this.mailingDefinitions = this.mailingConfigLoader.load();
        this.performMailingCleanup();
        if (this.mailingScheduler != null) {
            this.mailingScheduler.updateDefinitions(this.mailingDefinitions);
        }
    }

    private void performMailingCleanup() {
        if (!this.mailingAutoCleanup || this.mailingStatusRepository == null || this.mailingDefinitions == null) {
            return;
        }
        Set<String> activeIds = this.mailingDefinitions.stream().map(MailingDefinition::id).collect(Collectors.toSet());
        this.mailingStatusRepository.purgeMissingMailings(activeIds);
        this.getLogger().info("Mailing status cleanup executed for IDs: " + String.valueOf(activeIds));
    }

    private void applyCommandAliases() {
        List aliases;
        PluginCommand command = this.getCommand("lmb");
        if (command == null) {
            return;
        }
        FileConfiguration config = this.getConfig();
        ConfigurationSection aliasSection = config.getConfigurationSection("settings.command-aliases");
        List list = aliases = aliasSection != null ? aliasSection.getStringList("base") : Collections.emptyList();
        if (aliases == null) {
            aliases = Collections.emptyList();
        }
        command.setAliases(aliases);
        SimpleCommandMap commandMap = this.findCommandMap();
        if (commandMap == null) {
            this.getLogger().warning("Unable to re-register command aliases for /lmb; command map not accessible.");
            return;
        }
        try {
            command.unregister((CommandMap)commandMap);
            commandMap.register(this.getDescription().getName().toLowerCase(Locale.ROOT), (Command)command);
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to re-register /lmb aliases: " + ex.getMessage());
        }
    }

    private SimpleCommandMap findCommandMap() {
        CommandMap map = null;
        try {
            map = (CommandMap)Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (map instanceof SimpleCommandMap) {
            return (SimpleCommandMap)map;
        }
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            map = (CommandMap)field.get(Bukkit.getServer());
            if (map instanceof SimpleCommandMap) {
                return (SimpleCommandMap)map;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private String getPrimaryCommand() {
        List aliases = this.config.getStringList("settings.command-aliases.base");
        return aliases.isEmpty() ? "lmb" : (String)aliases.get(0);
    }

    public List<MailingDefinition> getMailingDefinitions() {
        if (this.mailingDefinitions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<MailingDefinition>(this.mailingDefinitions));
    }

    public MailingStatusRepository getMailingStatusRepository() {
        return this.mailingStatusRepository;
    }

    public MailingScheduler getMailingScheduler() {
        return this.mailingScheduler;
    }
}

