/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.command;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.config.StorageSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class LmbTabComplete
implements TabCompleter {
    private final LamMailBox plugin;

    public LmbTabComplete(LamMailBox plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        if (command.getName().equals("lmbmigrate")) {
            return this.handleMigrateTabComplete(sender, args, config);
        }
        if (args.length == 1) {
            String current = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission(config.getString("settings.admin-permission"))) {
                completions.add("send");
                completions.add("mailings");
            }
            if (sender.hasPermission(config.getString("settings.permissions.view-as"))) {
                completions.add("as");
            }
            return completions.stream().filter(entry -> entry.toLowerCase().startsWith(current)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String subCommand = args[0].toLowerCase();
            String current = args[1].toLowerCase();
            if (Objects.equals(subCommand, "as")) {
                if (sender.hasPermission(config.getString("settings.permissions.view-as"))) {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(current)).collect(Collectors.toList());
                }
            } else if (Objects.equals(subCommand, "send")) {
                if (sender.hasPermission(config.getString("settings.admin-permission"))) {
                    List<String> playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(current)).collect(Collectors.toList());
                    if ("all".startsWith(current)) {
                        playerNames.add("all");
                    }
                    if ("allonline".startsWith(current)) {
                        playerNames.add("allonline");
                    }
                    return playerNames;
                }
            } else if (sender.hasPermission(config.getString("settings.permissions.open-others"))) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(current)).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    private List<String> handleMigrateTabComplete(CommandSender sender, String[] args, FileConfiguration config) {
        String permission = config.getString("settings.permissions.migrate", "lammailbox.migrate");
        if (!sender.hasPermission(permission)) {
            return new ArrayList<String>();
        }
        List storageTypes = Arrays.stream(StorageSettings.BackendType.values()).map(type -> type.name().toLowerCase()).collect(Collectors.toList());
        if (args.length == 1) {
            String current = args[0].toLowerCase();
            return storageTypes.stream().filter(type -> type.startsWith(current)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String sourceType = args[0].toLowerCase();
            String current = args[1].toLowerCase();
            return storageTypes.stream().filter(type -> !type.equals(sourceType)).filter(type -> type.startsWith(current)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

