/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.GuiItemStyler;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class CommandItemUiComposer {
    private final LamMailBox plugin;
    private final GuiItemStyler itemStyler;
    private final NamespacedKey commandItemIndexKey;
    private final NamespacedKey commandItemActionKey;

    CommandItemUiComposer(LamMailBox plugin, GuiItemStyler itemStyler, NamespacedKey commandItemIndexKey, NamespacedKey commandItemActionKey) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.itemStyler = Objects.requireNonNull(itemStyler, "itemStyler");
        this.commandItemIndexKey = Objects.requireNonNull(commandItemIndexKey, "commandItemIndexKey");
        this.commandItemActionKey = Objects.requireNonNull(commandItemActionKey, "commandItemActionKey");
    }

    ItemStack createCommandPlaceholder(String commandPath, CommandItem commandItem) {
        ItemMeta meta;
        boolean isLegacy;
        ItemStack base = commandItem.toPreviewItem(this.plugin);
        boolean bl = isLegacy = commandItem.displayName() != null && commandItem.displayName().equals("&6Console Command");
        if (isLegacy) {
            this.applyLegacyOverrides(base, commandPath, commandItem);
        }
        if ((meta = base.getItemMeta()) != null && !meta.hasCustomModelData()) {
            this.itemStyler.apply(meta, commandPath, false);
            base.setItemMeta(meta);
        }
        return base;
    }

    ItemStack createCommandItemsButton(MailCreationSession session) {
        String basePath = "gui.create-mail.items.command-block";
        Material material = this.resolveMaterial(basePath + ".material", Material.COMMAND_BLOCK);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String name = this.plugin.getMessage(basePath + ".name", this.plugin.placeholders("count", String.valueOf(session.getCommandItems().size())));
        meta.setDisplayName(name);
        List<String> lore = this.config().getStringList(basePath + ".lore").stream().map(line -> this.plugin.applyPlaceholderVariants((String)line, "count", String.valueOf(session.getCommandItems().size()))).map(this.plugin::colorize).collect(Collectors.toList());
        if (!session.getCommandItems().isEmpty()) {
            List<String> summaries = session.getCommandItems().stream().map(this::formatCommandItemSummary).collect(Collectors.toList());
            this.appendDetailLines(lore, "&7Configured actions:", summaries, 4, false);
        }
        meta.setLore(lore);
        this.itemStyler.apply(meta, basePath, false);
        item.setItemMeta(meta);
        return item;
    }

    ItemStack buildCommandItemEditorEntry(CommandItem commandItem, int index) {
        String base = "gui.command-items-editor.items.command-item";
        ItemStack stack = commandItem.toPreviewItem(this.plugin);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (meta.hasLore() && meta.getLore() != null) {
            lore.addAll(meta.getLore());
        }
        this.appendDetailLines(lore, this.config().getString(base + ".command-header", "&7Commands:"), commandItem.commands(), 5, true);
        this.appendActionInstructions(lore, base);
        meta.setLore(lore);
        if (!meta.hasCustomModelData()) {
            this.itemStyler.apply(meta, base, false);
        }
        meta.getPersistentDataContainer().set(this.commandItemIndexKey, PersistentDataType.INTEGER, (Object)index);
        stack.setItemMeta(meta);
        return stack;
    }

    ItemStack buildEditorStaticButton(String path, String action) {
        ItemStack item;
        ItemMeta meta;
        String materialName = this.config().getString(path + ".material", "BARRIER");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.BARRIER;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) == null) {
            return item;
        }
        meta.setDisplayName(this.plugin.colorize(this.config().getString(path + ".name", "&c" + action)));
        meta.setLore(this.config().getStringList(path + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(meta, path);
        meta.getPersistentDataContainer().set(this.commandItemActionKey, PersistentDataType.STRING, (Object)action);
        item.setItemMeta(meta);
        return item;
    }

    void placeCreatorButton(Inventory inv, String path, String action, Map<String, String> placeholders, CommandItem.Builder draft) {
        ItemStack item;
        ItemMeta meta;
        if (!this.config().getBoolean(path + ".enabled", true)) {
            return;
        }
        int slot = this.config().getInt(path + ".slot", 0);
        Material material = Material.matchMaterial((String)this.config().getString(path + ".material", "BOOK"));
        if (material == null) {
            material = Material.BOOK;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) == null) {
            return;
        }
        String name = this.config().getString(path + ".name", "&eEdit");
        meta.setDisplayName(this.plugin.colorize(this.applyPlaceholders(name, placeholders)));
        List loreTemplate = this.config().getStringList(path + ".lore");
        List<String> lore = loreTemplate.stream().map(line -> this.applyDraftPlaceholders((String)line, placeholders, draft)).map(this.plugin::colorize).collect(Collectors.toList());
        if ("lore".equals(action) && !draft.lore().isEmpty()) {
            this.appendDetailLines(lore, "&7Lore:", draft.lore(), 10, false);
        } else if ("command".equals(action) && !draft.commands().isEmpty()) {
            this.appendDetailLines(lore, "&7Commands:", draft.commands(), 10, true);
        } else if ("custom-model".equals(action)) {
            String value = draft.customModelData() != null ? String.valueOf(draft.customModelData()) : "None";
            lore.add(this.plugin.colorize("&7Current: &f" + value));
        }
        if (!lore.isEmpty()) {
            meta.setLore(lore);
        }
        meta.getPersistentDataContainer().set(this.commandItemActionKey, PersistentDataType.STRING, (Object)action);
        this.itemStyler.apply(meta, path);
        item.setItemMeta(meta);
        inv.setItem(slot, item);
    }

    void openCommandItemsEditor(Inventory inv, MailCreationSession session, List<Integer> slots) {
        for (int i = 0; i < session.getCommandItems().size() && i < slots.size(); ++i) {
            ItemStack stack = this.buildCommandItemEditorEntry(session.getCommandItems().get(i), i);
            inv.setItem(slots.get(i).intValue(), stack);
        }
    }

    String applyPlaceholders(String input, Map<String, String> placeholders) {
        if (input == null) {
            return "";
        }
        if (placeholders == null || placeholders.isEmpty()) {
            return input;
        }
        return this.plugin.applyPlaceholderVariants(input, placeholders);
    }

    Map<String, String> createCommandItemPlaceholders(CommandItem commandItem) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        int commandCount = commandItem.commands().size();
        int loreCount = commandItem.lore().size();
        String firstCommand = commandCount > 0 ? commandItem.commands().get(0) : "";
        String summary = firstCommand.isEmpty() ? "" : Optional.ofNullable(this.summarizeCommand(firstCommand)).orElse(firstCommand);
        placeholders.put("{commands}", this.formatList(commandItem.commands(), 3, true));
        placeholders.put("{command_count}", String.valueOf(commandCount));
        placeholders.put("{total}", String.valueOf(commandCount));
        placeholders.put("{first_command}", firstCommand);
        placeholders.put("{summary}", summary);
        placeholders.put("{lore_count}", String.valueOf(loreCount));
        placeholders.put("{lore_values}", this.formatList(commandItem.lore(), 3, false));
        placeholders.put("{first_lore}", loreCount > 0 ? commandItem.lore().get(0) : "");
        placeholders.put("{custom_model_data}", commandItem.customModelData() != null ? String.valueOf(commandItem.customModelData()) : "None");
        return placeholders;
    }

    private void applyLegacyOverrides(ItemStack base, String commandPath, CommandItem commandItem) {
        List configuredLore;
        String legacyPath = commandPath.replace("command-item", "command-legacy");
        ItemMeta meta = base.getItemMeta();
        if (meta == null) {
            return;
        }
        Map<String, String> placeholders = this.createCommandItemPlaceholders(commandItem);
        String overrideName = this.config().getString(legacyPath + ".name");
        if (overrideName != null && !overrideName.isBlank()) {
            meta.setDisplayName(this.plugin.colorize(this.applyPlaceholders(overrideName, placeholders)));
        }
        if (!(configuredLore = this.config().getStringList(legacyPath + ".lore")).isEmpty()) {
            List lore = configuredLore.stream().map(line -> this.plugin.colorize(this.applyPlaceholders((String)line, placeholders))).collect(Collectors.toList());
            meta.setLore(lore);
        }
        base.setItemMeta(meta);
    }

    private String applyDraftPlaceholders(String input, Map<String, String> generic, CommandItem.Builder draft) {
        String result = this.applyPlaceholders(input, generic);
        result = this.plugin.applyPlaceholderVariants(result, "material", draft.materialKey());
        result = this.plugin.applyPlaceholderVariants(result, "name", draft.displayName());
        result = this.plugin.applyPlaceholderVariants(result, "lore_count", String.valueOf(draft.lore().size()));
        result = this.plugin.applyPlaceholderVariants(result, "command_count", String.valueOf(draft.commands().size()));
        result = this.plugin.applyPlaceholderVariants(result, "custom_model_data", draft.customModelData() != null ? String.valueOf(draft.customModelData()) : "None");
        if (!draft.commands().isEmpty()) {
            String firstCommand = draft.commands().get(0);
            result = this.plugin.applyPlaceholderVariants(result, "first_command", firstCommand);
            result = this.plugin.applyPlaceholderVariants(result, "summary", this.summarizeCommand(firstCommand));
        } else {
            result = this.plugin.applyPlaceholderVariants(result, "first_command", "");
            result = this.plugin.applyPlaceholderVariants(result, "summary", "");
        }
        return result;
    }

    private void appendActionInstructions(List<String> lore, String base) {
        List actionLore = this.config().getStringList(base + ".lore");
        if (actionLore.isEmpty()) {
            return;
        }
        if (!lore.isEmpty()) {
            lore.add(this.plugin.colorize("&7"));
        }
        lore.addAll(actionLore.stream().map(this.plugin::colorize).collect(Collectors.toList()));
    }

    void appendDetailLines(List<String> target, String header, List<String> values, int limit, boolean summarizeCommands) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (!target.isEmpty()) {
            target.add(this.plugin.colorize("&7"));
        }
        target.add(this.plugin.colorize(header));
        for (String value : values.stream().limit(limit).toList()) {
            String text = summarizeCommands ? Optional.ofNullable(this.summarizeCommand(value)).orElse(value) : value;
            target.add(this.plugin.colorize("&f\u2022 " + text));
        }
        if (values.size() > limit) {
            target.add(this.plugin.colorize("&7\u2026"));
        }
    }

    private String formatList(List<String> values, int limit, boolean summarizeCommands) {
        if (values == null || values.isEmpty()) {
            return "None";
        }
        String joined = values.stream().limit(limit).map(value -> summarizeCommands ? Optional.ofNullable(this.summarizeCommand((String)value)).orElse((String)value) : value).collect(Collectors.joining(", "));
        return values.size() > limit ? joined + ", \u2026" : joined;
    }

    private String formatCommandItemSummary(CommandItem commandItem) {
        String first = commandItem.commands().isEmpty() ? "" : commandItem.commands().get(0);
        String summary = first.isEmpty() ? "No command" : Optional.ofNullable(this.summarizeCommand(first)).orElse(first);
        String display = commandItem.displayName() != null ? commandItem.displayName() : "Action";
        return display + " \u2192 " + summary;
    }

    private String summarizeCommand(String command) {
        String[] parts;
        if (command == null || command.isBlank()) {
            return "Console";
        }
        String trimmed = command.trim();
        if (trimmed.startsWith("/")) {
            trimmed = trimmed.substring(1);
        }
        if ((parts = trimmed.split("\\s+")).length >= 3 && parts[0].equalsIgnoreCase("give")) {
            String item = this.plugin.applyPlaceholderVariants(parts[2], "player", "@p");
            int amount = 1;
            if (parts.length >= 4) {
                try {
                    amount = Integer.parseInt(parts[3]);
                }
                catch (NumberFormatException ignored) {
                    amount = 1;
                }
            }
            return item + "/" + amount;
        }
        String main = parts[0];
        if (parts.length > 1) {
            return main + " " + this.plugin.applyPlaceholderVariants(parts[1], "player", "@p");
        }
        return main;
    }

    private Material resolveMaterial(String materialPath, Material fallback) {
        String materialKey = this.config().getString(materialPath);
        if (materialKey == null || materialKey.isBlank()) {
            return fallback;
        }
        Material match = Material.matchMaterial((String)materialKey);
        return match != null ? match : fallback;
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

