/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

final class CommandItemsClickActions {
    private final LamMailBox plugin;
    private final NamespacedKey commandItemIndexKey;
    private final NamespacedKey commandItemActionKey;

    CommandItemsClickActions(LamMailBox plugin, NamespacedKey commandItemIndexKey, NamespacedKey commandItemActionKey) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.commandItemIndexKey = Objects.requireNonNull(commandItemIndexKey, "commandItemIndexKey");
        this.commandItemActionKey = Objects.requireNonNull(commandItemActionKey, "commandItemActionKey");
    }

    void handleEditorClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        event.setCancelled(true);
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(player.getUniqueId(), key -> new MailCreationSession());
        this.ensureCommandItemsInitialized(session);
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        Integer index = (Integer)meta.getPersistentDataContainer().get(this.commandItemIndexKey, PersistentDataType.INTEGER);
        String action = (String)meta.getPersistentDataContainer().get(this.commandItemActionKey, PersistentDataType.STRING);
        if (index != null) {
            this.handleEditorItemClick(event, player, session, index);
            return;
        }
        if (action == null) {
            return;
        }
        if ("add".equals(action)) {
            session.setCommandItemEditIndex(null);
            session.setCommandItemDraft(new CommandItem.Builder());
            this.plugin.openCommandItemCreator(player);
        } else if ("back".equals(action)) {
            this.plugin.openCreateMailGUI(player);
        }
    }

    void handleCreatorClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        event.setCancelled(true);
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(player.getUniqueId(), key -> new MailCreationSession());
        this.ensureCommandItemsInitialized(session);
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        String action = (String)meta.getPersistentDataContainer().get(this.commandItemActionKey, PersistentDataType.STRING);
        if (action == null) {
            action = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "action"), PersistentDataType.STRING);
        }
        if (action == null) {
            return;
        }
        switch (action) {
            case "material": {
                this.startAwaiting(player, "command-item-material", "command-item-material", this.config().getString("messages.enter-command-item-material"));
                break;
            }
            case "name": {
                this.startAwaiting(player, "command-item-name", "command-item-name", this.config().getString("messages.enter-command-item-name"));
                break;
            }
            case "lore": {
                this.handleListEdit(event, player, session, true);
                break;
            }
            case "command": {
                this.handleListEdit(event, player, session, false);
                break;
            }
            case "custom-model": {
                this.handleCustomModelEdit(event, player, session);
                break;
            }
            case "command-creator-back": {
                this.plugin.openCommandItemsEditor(player);
                break;
            }
            case "save": {
                this.finalizeCommandItem(player, session);
                break;
            }
        }
    }

    private void handleEditorItemClick(InventoryClickEvent event, Player player, MailCreationSession session, int index) {
        List<CommandItem> items = session.getCommandItems();
        if (index < 0 || index >= items.size()) {
            return;
        }
        if (event.isRightClick()) {
            items.remove(index);
            session.setCommandItems(items);
            this.plugin.openCommandItemsEditor(player);
        } else {
            session.setCommandItemEditIndex(index);
            session.setCommandItemDraft(items.get(index).toBuilder());
            this.plugin.openCommandItemCreator(player);
        }
    }

    private void handleListEdit(InventoryClickEvent event, Player player, MailCreationSession session, boolean isLore) {
        CommandItem.Builder draft = session.getCommandItemDraft();
        if (event.isRightClick()) {
            boolean removed;
            boolean bl = isLore ? draft != null && draft.removeLastLoreLine() : (removed = draft != null && draft.removeLastCommand());
            String messageKey = isLore ? (removed ? "messages.command-item-lore-removed" : "messages.command-item-lore-empty") : (removed ? "messages.command-item-command-removed" : "messages.command-item-command-empty");
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString(messageKey)));
            this.plugin.openCommandItemCreator(player);
        } else {
            String awaitingKey = isLore ? "command-item-lore" : "command-item-command";
            String titleKey = isLore ? "command-item-lore" : "command-item-command";
            String messageKey = isLore ? "messages.enter-command-item-lore" : "messages.enter-command-item-command";
            this.startAwaiting(player, awaitingKey, titleKey, this.config().getString(messageKey));
        }
    }

    private void handleCustomModelEdit(InventoryClickEvent event, Player player, MailCreationSession session) {
        CommandItem.Builder draft = session.getCommandItemDraft();
        if (event.isRightClick()) {
            if (draft != null) {
                draft.customModelData(null);
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.command-item-model-cleared")));
            }
            this.plugin.openCommandItemCreator(player);
        } else {
            this.startAwaiting(player, "command-item-custom-model", "command-item-custom-model", this.config().getString("messages.enter-command-item-custom-model"));
        }
    }

    private void finalizeCommandItem(Player player, MailCreationSession session) {
        if (this.plugin.getMailCreationController().finalizeCommandItem(player, session)) {
            this.plugin.openCommandItemsEditor(player);
        } else {
            this.plugin.openCommandItemCreator(player);
        }
    }

    private void ensureCommandItemsInitialized(MailCreationSession session) {
        if (session.getCommandItems() == null) {
            session.setCommandItems(new ArrayList<CommandItem>());
        }
    }

    private void startAwaiting(Player player, String key, String titleKey, String message) {
        this.plugin.getAwaitingInput().put(player.getUniqueId(), key);
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        this.plugin.getMailCreationController().showInputTitle(player, titleKey);
        if (message != null) {
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + message));
        }
        player.closeInventory();
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

