/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.CommandItemUiComposer;
import com.yusaki.lammailbox.gui.GuiItemStyler;
import com.yusaki.lammailbox.gui.GuiNavigationHelper;
import com.yusaki.lammailbox.gui.MailCreationViewBuilder;
import com.yusaki.lammailbox.gui.MailGuiFactory;
import com.yusaki.lammailbox.gui.PaginationBuilder;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.repository.MailRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ConfigMailGuiFactory
implements MailGuiFactory {
    private final LamMailBox plugin;
    private final NamespacedKey decorationKey;
    private final NamespacedKey commandItemIndexKey;
    private final NamespacedKey commandItemActionKey;
    private final NamespacedKey actionKey;
    private final NamespacedKey mailIdKey;
    private final NamespacedKey paginationTargetKey;
    private final GuiItemStyler itemStyler;
    private final GuiNavigationHelper navigationHelper;
    private final PaginationBuilder paginationBuilder;
    private final CommandItemUiComposer commandItemUi;
    private final MailCreationViewBuilder mailCreationBuilder;

    public ConfigMailGuiFactory(LamMailBox plugin) {
        this.plugin = plugin;
        this.decorationKey = new NamespacedKey((Plugin)plugin, "decorationPath");
        this.commandItemIndexKey = new NamespacedKey((Plugin)plugin, "commandItemIndex");
        this.commandItemActionKey = new NamespacedKey((Plugin)plugin, "commandItemAction");
        this.actionKey = new NamespacedKey((Plugin)plugin, "action");
        this.mailIdKey = new NamespacedKey((Plugin)plugin, "mailId");
        this.paginationTargetKey = new NamespacedKey((Plugin)plugin, "paginationTarget");
        this.itemStyler = new GuiItemStyler(plugin);
        this.navigationHelper = new GuiNavigationHelper(plugin, this.actionKey, this.itemStyler);
        this.paginationBuilder = new PaginationBuilder(plugin, this.actionKey, this.decorationKey, this.itemStyler);
        this.commandItemUi = new CommandItemUiComposer(plugin, this.itemStyler, this.commandItemIndexKey, this.commandItemActionKey);
        this.mailCreationBuilder = new MailCreationViewBuilder(plugin, this.itemStyler, this.navigationHelper, this.commandItemUi, this::addDecorations, this::isEnabled);
    }

    private ItemStack styledCommandIcon(String basePath, ItemStack existing, int commandCount, String summary) {
        ItemStack stack = this.resolveCommandIconStack(basePath, existing);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        this.applyCommandIconText(meta, basePath, commandCount, summary);
        stack.setItemMeta(meta);
        return stack;
    }

    private ItemStack resolveCommandIconStack(String basePath, ItemStack existing) {
        ItemStack stack = existing != null ? existing.clone() : null;
        String materialName = this.config().getString(basePath + ".material");
        if (materialName != null && !materialName.isBlank()) {
            try {
                Material material = Material.valueOf((String)materialName.trim().toUpperCase(Locale.ROOT));
                if (stack == null || stack.getType() != material) {
                    stack = new ItemStack(material);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (stack == null) {
            stack = new ItemStack(Material.COMMAND_BLOCK);
        }
        return stack;
    }

    private void applyCommandIconText(ItemMeta meta, String basePath, int commandCount, String summary) {
        List<String> rawLore;
        String displayName = this.config().getString(basePath + ".name");
        if (displayName != null && !displayName.isBlank()) {
            meta.setDisplayName(this.plugin.colorize(this.format(displayName, "count", String.valueOf(commandCount), "summary", summary)));
        }
        if ((rawLore = this.config().getStringList(basePath + ".lore")) == null || rawLore.isEmpty()) {
            rawLore = Collections.singletonList("&7Contains hidden console actions");
        }
        List lore = rawLore.stream().map(line -> this.plugin.colorize(this.format((String)line, "count", String.valueOf(commandCount), "summary", summary))).collect(Collectors.toList());
        meta.setLore(lore);
        this.itemStyler.apply(meta, basePath);
    }

    private void placeItemsAndCommands(Inventory inv, List<ItemStack> items, List<CommandItem> commandItems, String itemPath, String commandPath, int currentPage, int slotsPerPage) {
        List itemSlots = this.config().getIntegerList(itemPath + ".slots");
        if (itemSlots == null || itemSlots.isEmpty()) {
            return;
        }
        ArrayList<Object> allElements = new ArrayList<Object>();
        allElements.addAll(items != null ? items : Collections.emptyList());
        if (commandItems != null && !commandItems.isEmpty() && this.isEnabled(commandPath)) {
            allElements.addAll(commandItems);
        }
        int startIndex = (currentPage - 1) * slotsPerPage;
        int endIndex = Math.min(startIndex + slotsPerPage, allElements.size());
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex && slotIndex < itemSlots.size(); ++i) {
            Object element = allElements.get(i);
            if (element instanceof ItemStack) {
                inv.setItem(((Integer)itemSlots.get(slotIndex++)).intValue(), (ItemStack)element);
                continue;
            }
            if (!(element instanceof CommandItem)) continue;
            CommandItem commandItem = (CommandItem)element;
            ItemStack commandIcon = this.commandItemUi.createCommandPlaceholder(commandPath, commandItem);
            inv.setItem(((Integer)itemSlots.get(slotIndex++)).intValue(), commandIcon);
        }
    }

    private void addPaginationButtons(Inventory inv, String mailId, int currentPage, int totalPages, Integer claimSlot, Integer dismissSlot) {
        HashSet<Integer> reservedSlots = new HashSet<Integer>();
        if (claimSlot != null) {
            reservedSlots.add(claimSlot);
        }
        if (dismissSlot != null) {
            reservedSlots.add(dismissSlot);
        }
        PaginationBuilder.Settings settings = new PaginationBuilder.Settings("gui.mail-view.items.pagination", reservedSlots, "page-prev", "page-next", (meta, type) -> {
            if (type != PaginationBuilder.PaginationButtonType.INDICATOR) {
                meta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)mailId);
            }
        });
        this.paginationBuilder.addPaginationButtons(inv, settings, currentPage, totalPages);
    }

    @Override
    public Inventory createMailbox(Player viewer) {
        int size = this.config().getInt("gui.main.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.main.title")));
        this.addDecorations(inv, "gui.main");
        this.addCreateMailButton(inv, viewer, viewer);
        this.addSentMailButton(inv);
        this.loadPlayerMails(viewer, viewer, inv);
        return inv;
    }

    @Override
    public Inventory createMailboxAs(Player admin, Player target) {
        int size = this.config().getInt("gui.main.size");
        String title = this.config().getString("gui.main.title") + " &7(as " + target.getName() + ")";
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(title));
        this.addDecorations(inv, "gui.main");
        this.addCreateMailButton(inv, admin, target);
        this.addSentMailButton(inv);
        this.loadPlayerMails(admin, target, inv);
        return inv;
    }

    @Override
    public Inventory createSentMailbox(Player viewer) {
        int size = this.config().getInt("gui.sent-mail.size");
        Object title = this.config().getString("gui.sent-mail.title");
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        if (viewingAs != null) {
            title = (String)title + " &7(as " + viewingAs + ")";
        }
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize((String)title));
        this.addDecorations(inv, "gui.sent-mail");
        this.addBackButton(inv);
        this.loadSentMails(viewer, inv);
        return inv;
    }

    @Override
    public Inventory createSentMailView(Player viewer, String mailId) {
        int size = this.config().getInt("gui.sent-mail-view.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.sent-mail-view.title")));
        this.addDecorations(inv, "gui.sent-mail-view");
        Optional<MailRecord> recordOpt = this.plugin.getMailRepository().findRecord(mailId);
        if (recordOpt.isEmpty()) {
            return inv;
        }
        MailRecord record = recordOpt.get();
        String receiver = Optional.ofNullable(record.receiver()).orElse("");
        String message = record.message().replace("\\n", "\n");
        if (this.isEnabled("gui.sent-mail-view.items.receiver-head")) {
            ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.receiver-head.material")));
            SkullMeta headMeta = (SkullMeta)head.getItemMeta();
            headMeta.setDisplayName(this.plugin.colorize(this.format(this.config().getString("gui.sent-mail-view.items.receiver-head.name"), "receiver", receiver)));
            if (receiver != null && !receiver.trim().isEmpty() && receiver.matches("^[a-zA-Z0-9_]{1,16}$")) {
                headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)receiver));
            }
            this.itemStyler.apply((ItemMeta)headMeta, "gui.sent-mail-view.items.receiver-head", false);
            head.setItemMeta((ItemMeta)headMeta);
            inv.setItem(this.config().getInt("gui.sent-mail-view.items.receiver-head.slot"), head);
        }
        if (this.isEnabled("gui.sent-mail-view.items.message")) {
            ItemStack messageItem = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.message.material")));
            ItemMeta messageMeta = messageItem.getItemMeta();
            messageMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail-view.items.message.name")));
            List messageLore = Arrays.stream(message.split("\n")).map(line -> this.plugin.colorize("&f" + line)).collect(Collectors.toList());
            messageMeta.setLore(messageLore);
            this.itemStyler.apply(messageMeta, "gui.sent-mail-view.items.message", false);
            messageItem.setItemMeta(messageMeta);
            inv.setItem(this.config().getInt("gui.sent-mail-view.items.message.slot"), messageItem);
        }
        List<ItemStack> items = this.plugin.getMailRepository().loadMailItems(mailId);
        List itemSlots = this.config().getIntegerList("gui.sent-mail-view.items.items-display.slots");
        int slotsPerPage = itemSlots != null && !itemSlots.isEmpty() ? itemSlots.size() : 21;
        this.placeItemsAndCommands(inv, items, record.commandItems(), "gui.sent-mail-view.items.items-display", "gui.sent-mail-view.items.command-item", 1, slotsPerPage);
        this.navigationHelper.placeBackButton(inv, "gui.sent-mail-view.items.back-button", "sent-mail-view-back");
        if (viewer.hasPermission(this.config().getString("settings.permissions.delete")) && this.isEnabled("gui.sent-mail-view.items.delete-button")) {
            ItemStack deleteButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail-view.items.delete-button.material")));
            ItemMeta deleteMeta = deleteButton.getItemMeta();
            deleteMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail-view.items.delete-button.name")));
            deleteMeta.setLore(this.config().getStringList("gui.sent-mail-view.items.delete-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
            deleteMeta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)mailId);
            this.itemStyler.apply(deleteMeta, "gui.sent-mail-view.items.delete-button");
            deleteButton.setItemMeta(deleteMeta);
            inv.setItem(this.config().getInt("gui.sent-mail-view.items.delete-button.slot"), deleteButton);
        }
        return inv;
    }

    @Override
    public Inventory createMailView(Player viewer, String mailId) {
        int size = this.config().getInt("gui.mail-view.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.mail-view.title")));
        this.addDecorations(inv, "gui.mail-view");
        Optional<MailRecord> recordOpt = this.plugin.getMailRepository().findRecord(mailId);
        if (recordOpt.isEmpty()) {
            return inv;
        }
        MailRecord record = recordOpt.get();
        String sender = Optional.ofNullable(record.sender()).orElse("Console");
        String message = record.message().replace("\\n", "\n");
        if (this.isEnabled("gui.mail-view.items.sender-head")) {
            ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.sender-head.material")));
            SkullMeta headMeta = (SkullMeta)head.getItemMeta();
            headMeta.setDisplayName(this.plugin.colorize(this.format(this.config().getString("gui.mail-view.items.sender-head.name"), "sender", sender)));
            if (sender != null && !sender.trim().isEmpty() && sender.matches("^[a-zA-Z0-9_]{1,16}$")) {
                headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)sender));
            }
            this.itemStyler.apply((ItemMeta)headMeta, "gui.mail-view.items.sender-head", false);
            head.setItemMeta((ItemMeta)headMeta);
            inv.setItem(this.config().getInt("gui.mail-view.items.sender-head.slot"), head);
        }
        if (this.isEnabled("gui.mail-view.items.message")) {
            ItemStack messageItem = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.message.material")));
            ItemMeta messageMeta = messageItem.getItemMeta();
            messageMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.mail-view.items.message.name")));
            List messageLore = Arrays.stream(message.split("\n")).map(line -> this.plugin.colorize("&f" + line)).collect(Collectors.toList());
            messageMeta.setLore(messageLore);
            this.itemStyler.apply(messageMeta, "gui.mail-view.items.message", false);
            messageItem.setItemMeta(messageMeta);
            inv.setItem(this.config().getInt("gui.mail-view.items.message.slot"), messageItem);
        }
        List<ItemStack> items = this.plugin.getMailRepository().loadMailItems(mailId);
        int currentPage = this.plugin.getMailViewPages().getOrDefault(viewer.getUniqueId(), 1);
        int totalElements = items.size() + record.commandItems().size();
        List itemSlots = this.config().getIntegerList("gui.mail-view.items.items-display.slots");
        int slotsPerPage = itemSlots != null && !itemSlots.isEmpty() ? itemSlots.size() : 21;
        int totalPages = (totalElements + slotsPerPage - 1) / slotsPerPage;
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (currentPage > totalPages && totalPages > 0) {
            currentPage = totalPages;
        }
        this.plugin.getMailViewPages().put(viewer.getUniqueId(), currentPage);
        this.placeItemsAndCommands(inv, items, record.commandItems(), "gui.mail-view.items.items-display", "gui.mail-view.items.command-item", currentPage, slotsPerPage);
        int claimSlotConfig = this.config().getInt("gui.mail-view.items.claim-button.slot");
        Integer claimSlot = this.isEnabled("gui.mail-view.items.claim-button") ? Integer.valueOf(claimSlotConfig) : null;
        int dismissSlotConfig = this.config().getInt("gui.mail-view.items.dismiss-button.slot", claimSlotConfig);
        Integer dismissSlot = this.isEnabled("gui.mail-view.items.dismiss-button") ? Integer.valueOf(dismissSlotConfig) : null;
        this.addPaginationButtons(inv, mailId, currentPage, totalPages, claimSlot, dismissSlot);
        if (claimSlot != null) {
            ItemStack claimButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.claim-button.material")));
            ItemMeta claimMeta = claimButton.getItemMeta();
            claimMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.mail-view.items.claim-button.name")));
            claimMeta.setLore(this.config().getStringList("gui.mail-view.items.claim-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
            claimMeta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)mailId);
            this.itemStyler.apply(claimMeta, "gui.mail-view.items.claim-button");
            claimButton.setItemMeta(claimMeta);
            inv.setItem(claimSlot.intValue(), claimButton);
        }
        if (dismissSlot != null) {
            ItemStack dismissButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.mail-view.items.dismiss-button.material")));
            ItemMeta dismissMeta = dismissButton.getItemMeta();
            dismissMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.mail-view.items.dismiss-button.name")));
            dismissMeta.setLore(this.config().getStringList("gui.mail-view.items.dismiss-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
            dismissMeta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)mailId);
            this.itemStyler.apply(dismissMeta, "gui.mail-view.items.dismiss-button");
            dismissButton.setItemMeta(dismissMeta);
            inv.setItem(dismissSlot.intValue(), dismissButton);
        }
        this.navigationHelper.placeBackButton(inv, "gui.mail-view.items.back-button", "mail-view-back");
        return inv;
    }

    @Override
    public Inventory createMailCreation(Player viewer) {
        return this.mailCreationBuilder.createMailCreation(viewer);
    }

    @Override
    public Inventory createItemsEditor(Player viewer) {
        return this.mailCreationBuilder.createItemsEditor(viewer);
    }

    @Override
    public Inventory createCommandItemsEditor(Player viewer) {
        return this.mailCreationBuilder.createCommandItemsEditor(viewer);
    }

    @Override
    public Inventory createCommandItemCreator(Player viewer) {
        return this.mailCreationBuilder.createCommandItemCreator(viewer);
    }

    private void addCreateMailButton(Inventory inv, Player viewer, Player target) {
        if (!this.isEnabled("gui.main.items.create-mail")) {
            return;
        }
        ItemStack createBook = new ItemStack(Material.valueOf((String)this.config().getString("gui.main.items.create-mail.material")));
        ItemMeta bookMeta = createBook.getItemMeta();
        String baseName = this.config().getString("gui.main.items.create-mail.name", "");
        bookMeta.setDisplayName(this.plugin.colorize(baseName));
        ArrayList<String> bookLore = new ArrayList<String>(this.config().getStringList("gui.main.items.create-mail.lore"));
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        if (viewingAs != null && !viewer.getUniqueId().equals(target.getUniqueId())) {
            String disabledNameFormat = this.config().getString("gui.main.items.create-mail.disabled.name-format", "&c&l%name%");
            bookMeta.setDisplayName(this.plugin.colorize(this.format(disabledNameFormat, "name", baseName)));
            List disabledLore = this.config().getStringList("gui.main.items.create-mail.disabled.lore");
            if (!disabledLore.isEmpty()) {
                bookLore.addAll(disabledLore);
            } else {
                bookLore.add("&c&l\u26a0 DISABLED");
                bookLore.add("&7Cannot create mail as another player");
            }
        }
        bookMeta.setLore(bookLore.stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(bookMeta, "gui.main.items.create-mail");
        createBook.setItemMeta(bookMeta);
        inv.setItem(this.config().getInt("gui.main.items.create-mail.slot"), createBook);
    }

    private void addSentMailButton(Inventory inv) {
        if (!this.isEnabled("gui.main.items.sent-mail")) {
            return;
        }
        ItemStack sentMailButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.main.items.sent-mail.material")));
        ItemMeta sentMailMeta = sentMailButton.getItemMeta();
        sentMailMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.main.items.sent-mail.name")));
        sentMailMeta.setLore(this.config().getStringList("gui.main.items.sent-mail.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(sentMailMeta, "gui.main.items.sent-mail");
        sentMailButton.setItemMeta(sentMailMeta);
        inv.setItem(this.config().getInt("gui.main.items.sent-mail.slot"), sentMailButton);
    }

    private void addBackButton(Inventory inv) {
        if (!this.isEnabled("gui.sent-mail.items.back-button")) {
            return;
        }
        ItemStack backButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail.items.back-button.material")));
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.sent-mail.items.back-button.name")));
        backMeta.setLore(this.config().getStringList("gui.sent-mail.items.back-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(backMeta, "gui.sent-mail.items.back-button");
        backButton.setItemMeta(backMeta);
        inv.setItem(this.config().getInt("gui.sent-mail.items.back-button.slot"), backButton);
    }

    private void loadPlayerMails(Player viewer, Player target, Inventory inv) {
        if (!this.isEnabled("gui.main.items.mail-display")) {
            return;
        }
        List mailSlots = this.config().getIntegerList("gui.main.items.mail-display.slots");
        if (mailSlots == null || mailSlots.isEmpty()) {
            return;
        }
        String targetName = target.getName();
        List records = this.plugin.getMailRepository().listMailIds().stream().map(id -> this.plugin.getMailRepository().findRecord((String)id).orElse(null)).filter(Objects::nonNull).filter(MailRecord::active).filter(record -> record.canBeClaimedBy(targetName)).sorted(Comparator.comparingLong(MailRecord::sentDate).reversed()).collect(Collectors.toList());
        int slotsPerPage = mailSlots.size();
        int totalPages = Math.max(1, (records.size() + slotsPerPage - 1) / slotsPerPage);
        UUID viewerId = viewer.getUniqueId();
        int currentPage = this.plugin.getMailboxPages().getOrDefault(viewerId, 1);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (currentPage > totalPages) {
            currentPage = totalPages;
        }
        this.plugin.getMailboxPages().put(viewerId, currentPage);
        int startIndex = (currentPage - 1) * slotsPerPage;
        int endIndex = Math.min(records.size(), startIndex + slotsPerPage);
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex && slotIndex < mailSlots.size(); ++i) {
            MailRecord record2 = (MailRecord)records.get(i);
            ItemStack mailItem = this.createMailItem(record2);
            if (mailItem == null) continue;
            inv.setItem(((Integer)mailSlots.get(slotIndex)).intValue(), mailItem);
            ++slotIndex;
        }
        HashSet<Integer> reservedSlots = new HashSet<Integer>();
        if (this.isEnabled("gui.main.items.create-mail")) {
            reservedSlots.add(this.config().getInt("gui.main.items.create-mail.slot"));
        }
        if (this.isEnabled("gui.main.items.sent-mail")) {
            reservedSlots.add(this.config().getInt("gui.main.items.sent-mail.slot"));
        }
        PaginationBuilder.Settings settings = new PaginationBuilder.Settings("gui.main.items.pagination", reservedSlots, "mailbox-page-prev", "mailbox-page-next", (meta, type) -> {
            if (type != PaginationBuilder.PaginationButtonType.INDICATOR) {
                meta.getPersistentDataContainer().set(this.paginationTargetKey, PersistentDataType.STRING, (Object)targetName);
            }
        });
        this.paginationBuilder.addPaginationButtons(inv, settings, currentPage, totalPages);
    }

    private void loadSentMails(Player viewer, Inventory inv) {
        if (!this.isEnabled("gui.sent-mail.items.sent-mail-display")) {
            return;
        }
        List mailSlots = this.config().getIntegerList("gui.sent-mail.items.sent-mail-display.slots");
        if (mailSlots == null || mailSlots.isEmpty()) {
            return;
        }
        String viewingAs = this.plugin.getViewingAsPlayer().get(viewer.getUniqueId());
        String targetPlayerName = viewingAs != null ? viewingAs : viewer.getName();
        List records = this.plugin.getMailRepository().listMailIdsBySender(targetPlayerName).stream().map(id -> this.plugin.getMailRepository().findRecord((String)id).orElse(null)).filter(Objects::nonNull).sorted(Comparator.comparingLong(MailRecord::sentDate).reversed()).collect(Collectors.toList());
        int slotsPerPage = mailSlots.size();
        int totalPages = Math.max(1, (records.size() + slotsPerPage - 1) / slotsPerPage);
        UUID viewerId = viewer.getUniqueId();
        int currentPage = this.plugin.getSentMailboxPages().getOrDefault(viewerId, 1);
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (currentPage > totalPages) {
            currentPage = totalPages;
        }
        this.plugin.getSentMailboxPages().put(viewerId, currentPage);
        int startIndex = (currentPage - 1) * slotsPerPage;
        int endIndex = Math.min(records.size(), startIndex + slotsPerPage);
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex && slotIndex < mailSlots.size(); ++i) {
            MailRecord record = (MailRecord)records.get(i);
            ItemStack mailItem = this.createSentMailItem(record);
            if (mailItem == null) continue;
            inv.setItem(((Integer)mailSlots.get(slotIndex)).intValue(), mailItem);
            ++slotIndex;
        }
        HashSet<Integer> reservedSlots = new HashSet<Integer>();
        if (this.isEnabled("gui.sent-mail.items.back-button")) {
            reservedSlots.add(this.config().getInt("gui.sent-mail.items.back-button.slot"));
        }
        PaginationBuilder.Settings settings = new PaginationBuilder.Settings("gui.sent-mail.items.pagination", reservedSlots, "sent-page-prev", "sent-page-next", (meta, type) -> {
            if (type != PaginationBuilder.PaginationButtonType.INDICATOR) {
                meta.getPersistentDataContainer().set(this.paginationTargetKey, PersistentDataType.STRING, (Object)targetPlayerName);
            }
        });
        this.paginationBuilder.addPaginationButtons(inv, settings, currentPage, totalPages);
    }

    private ItemStack createMailItem(MailRecord record) {
        String itemPath;
        String string = itemPath = record.isAdminMail() ? "gui.main.items.admin-mail-display" : "gui.main.items.mail-display";
        if (!this.isEnabled(itemPath)) {
            return null;
        }
        ItemStack mailItem = new ItemStack(Material.valueOf((String)this.config().getString(itemPath + ".material")));
        ItemMeta meta = mailItem.getItemMeta();
        String displayName = this.config().getString(itemPath + ".name", "");
        String sender = Optional.ofNullable(record.sender()).orElse("");
        String message = record.message().replace("\\n", "\n");
        long sentAt = record.sentDate();
        long expireAt = record.expireDate() != null ? record.expireDate() : 0L;
        meta.setDisplayName(this.plugin.colorize(this.applyMailPlaceholders(displayName, sender, message, sentAt, expireAt)));
        List loreTemplate = this.config().getStringList(itemPath + ".lore");
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : loreTemplate) {
            lore.add(this.plugin.colorize(this.applyMailPlaceholders(line, sender, message, sentAt, expireAt)));
        }
        String messagePrefix = this.config().getString(itemPath + ".message-prefix");
        if (messagePrefix != null && !messagePrefix.isEmpty() && !message.isEmpty()) {
            for (String line : message.split("\n")) {
                lore.add(this.plugin.colorize(messagePrefix + line));
            }
        }
        meta.setLore(lore);
        this.itemStyler.apply(meta, itemPath, false);
        meta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)record.id());
        mailItem.setItemMeta(meta);
        return mailItem;
    }

    private ItemStack createSentMailItem(MailRecord record) {
        if (!this.isEnabled("gui.sent-mail.items.sent-mail-display")) {
            return null;
        }
        ItemStack item = new ItemStack(Material.valueOf((String)this.config().getString("gui.sent-mail.items.sent-mail-display.material")));
        ItemMeta meta = item.getItemMeta();
        String receiver = Optional.ofNullable(record.receiver()).orElse("");
        long sentAt = record.sentDate();
        long expireAt = record.expireDate() != null ? record.expireDate() : 0L;
        String displayName = this.config().getString("gui.sent-mail.items.sent-mail-display.name", "");
        meta.setDisplayName(this.plugin.colorize(this.format(displayName, "receiver", receiver, "sent_date", this.formatDate(sentAt), "expire_date", this.formatDate(expireAt))));
        List lore = this.config().getStringList("gui.sent-mail.items.sent-mail-display.lore").stream().map(line -> this.plugin.colorize(this.format((String)line, "receiver", receiver, "sent_date", this.formatDate(sentAt), "expire_date", this.formatDate(expireAt), "sent", this.formatDate(sentAt), "expire", this.formatDate(expireAt)))).collect(Collectors.toList());
        meta.setLore(lore);
        this.itemStyler.apply(meta, "gui.sent-mail.items.sent-mail-display", false);
        meta.getPersistentDataContainer().set(this.mailIdKey, PersistentDataType.STRING, (Object)record.id());
        item.setItemMeta(meta);
        return item;
    }

    private String applyMailPlaceholders(String input, String sender, String message, long sentAt, long expireAt) {
        return this.format(input, "sender", sender, "message", message.replace("\n", " "), "sent", this.formatDate(sentAt), "sent_date", this.formatDate(sentAt), "expire", this.formatDate(expireAt), "expire_date", this.formatDate(expireAt));
    }

    private String format(String template, String ... keyValuePairs) {
        if (template == null || keyValuePairs == null || keyValuePairs.length == 0) {
            return template;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        int i = 0;
        while (i + 1 < keyValuePairs.length) {
            String key = keyValuePairs[i];
            if (key != null) {
                String value = keyValuePairs[i + 1];
                replacements.put(key, value);
            }
            i += 2;
        }
        return this.plugin.applyPlaceholderVariants(template, replacements);
    }

    private String formatDate(long millis) {
        if (millis <= 0L) {
            return this.plugin.colorize(this.config().getString("messages.never-expire", "Never"));
        }
        return new Date(millis).toString();
    }

    private void addDecorations(Inventory inv, String guiPath) {
        if (!this.config().contains(guiPath + ".decoration")) {
            return;
        }
        ConfigurationSection decorSection = this.config().getConfigurationSection(guiPath + ".decoration");
        if (decorSection == null) {
            return;
        }
        for (String decorKey : decorSection.getKeys(false)) {
            String path = guiPath + ".decoration." + decorKey;
            if (!this.isEnabled(path)) continue;
            Material material = Material.valueOf((String)this.config().getString(path + ".material"));
            String name = this.config().getString(path + ".name");
            List slots = this.config().getIntegerList(path + ".slots");
            ItemStack decorItem = new ItemStack(material);
            ItemMeta meta = decorItem.getItemMeta();
            meta.setDisplayName(this.plugin.colorize(name));
            List loreLines = this.config().getStringList(path + ".lore");
            if (!loreLines.isEmpty()) {
                meta.setLore(loreLines.stream().map(this.plugin::colorize).collect(Collectors.toList()));
            }
            meta.getPersistentDataContainer().set(this.decorationKey, PersistentDataType.STRING, (Object)path);
            List commands = this.config().getStringList(path + ".commands").stream().filter(line -> line != null && !line.trim().isEmpty()).collect(Collectors.toList());
            if (!commands.isEmpty()) {
                meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "decorationPath"), PersistentDataType.STRING, (Object)path);
            }
            this.itemStyler.apply(meta, path);
            decorItem.setItemMeta(meta);
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                inv.setItem(slot, decorItem.clone());
            }
        }
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }
}

