/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class DecorationCommandExecutor {
    private final LamMailBox plugin;
    private final NamespacedKey decorationKey;

    DecorationCommandExecutor(LamMailBox plugin, NamespacedKey decorationKey) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.decorationKey = Objects.requireNonNull(decorationKey, "decorationKey");
    }

    boolean execute(InventoryClickEvent event, Player player, ItemStack clicked) {
        if (clicked == null) {
            return false;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return false;
        }
        String configPath = (String)meta.getPersistentDataContainer().get(this.decorationKey, PersistentDataType.STRING);
        if (configPath == null || configPath.isEmpty()) {
            return false;
        }
        List commands = this.config().getStringList(configPath + ".commands");
        if (commands.isEmpty()) {
            return false;
        }
        event.setCancelled(true);
        String playerName = player.getName();
        String uuid = player.getUniqueId().toString();
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
            for (String template : commands) {
                if (template == null || template.trim().isEmpty()) continue;
                String command = template.replace("{player}", playerName).replace("{uuid}", uuid).replace("%player%", playerName).replace("%uuid%", uuid);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        });
        return true;
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

