/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

final class GuiCloseHandler {
    private final LamMailBox plugin;

    GuiCloseHandler(LamMailBox plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    void handle(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        UUID playerId = player.getUniqueId();
        if (title.equals(this.plugin.colorize(this.config().getString("gui.items.title")))) {
            this.handleItemsClose(event, player);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.create-mail.title")))) {
            this.handleCreateMailClose(player);
        }
        if (!this.plugin.getAwaitingInput().containsKey(playerId)) {
            this.plugin.getInMailCreation().remove(playerId);
        }
        this.plugin.getDeleteConfirmations().remove(playerId);
        this.handleMainGuiClose(player, title);
        this.handleSentGuiClose(player, title);
        this.handleMailViewClose(player, title);
    }

    private void handleItemsClose(InventoryCloseEvent event, Player player) {
        MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
        if (session == null) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Material saveButtonMaterial = Material.valueOf((String)this.config().getString("gui.items.items.save-button.material"));
        Inventory inventory = event.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == saveButtonMaterial) continue;
            items.add(item.clone());
        }
        session.setItems(items);
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCreateMailGUI(player));
    }

    private void handleCreateMailClose(Player player) {
        MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (player.hasPermission(this.config().getString("settings.admin-permission"))) {
            return;
        }
        if (this.plugin.getInMailCreation().getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        for (ItemStack item : session.getItems()) {
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{item.clone()});
            leftover.values().forEach(leftItem -> player.getWorld().dropItem(player.getLocation(), leftItem));
        }
        session.setItems(new ArrayList<ItemStack>());
    }

    private void handleMainGuiClose(Player player, String title) {
        String mainTitle = this.plugin.colorize(this.config().getString("gui.main.title"));
        String mainViewingPrefix = this.plugin.colorize(this.config().getString("gui.main.title") + " &7(as ");
        if (!title.equals(mainTitle) && !title.startsWith(mainViewingPrefix)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
            boolean stillMain;
            if (!player.isOnline()) {
                this.plugin.getViewingAsPlayer().remove(playerId);
                this.plugin.getMailboxPages().remove(playerId);
                return;
            }
            String currentTitle = player.getOpenInventory().getTitle();
            boolean bl = stillMain = currentTitle.equals(mainTitle) || currentTitle.startsWith(mainViewingPrefix);
            if (!stillMain) {
                this.plugin.getViewingAsPlayer().remove(playerId);
                this.plugin.getMailboxPages().remove(playerId);
            }
        });
    }

    private void handleSentGuiClose(Player player, String title) {
        String sentTitle = this.plugin.colorize(this.config().getString("gui.sent-mail.title"));
        String sentViewingPrefix = this.plugin.colorize(this.config().getString("gui.sent-mail.title") + " &7(as ");
        if (!title.equals(sentTitle) && !title.startsWith(sentViewingPrefix)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
            boolean stillSent;
            if (!player.isOnline()) {
                this.plugin.getSentMailboxPages().remove(playerId);
                return;
            }
            String currentTitle = player.getOpenInventory().getTitle();
            boolean bl = stillSent = currentTitle.equals(sentTitle) || currentTitle.startsWith(sentViewingPrefix);
            if (!stillSent) {
                this.plugin.getSentMailboxPages().remove(playerId);
            }
        });
    }

    private void handleMailViewClose(Player player, String title) {
        String mailViewTitle = this.plugin.colorize(this.config().getString("gui.mail-view.title"));
        if (!title.equals(mailViewTitle)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> {
            if (!player.isOnline()) {
                this.plugin.getMailViewPages().remove(playerId);
                return;
            }
            String currentTitle = player.getOpenInventory().getTitle();
            if (!mailViewTitle.equals(currentTitle)) {
                this.plugin.getMailViewPages().remove(playerId);
            }
        });
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

