/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.meta.ItemMeta;

final class GuiItemStyler {
    private final LamMailBox plugin;

    GuiItemStyler(LamMailBox plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
    }

    void apply(ItemMeta meta, String basePath) {
        this.apply(meta, basePath, true);
    }

    void apply(ItemMeta meta, String basePath, boolean allowLoreOverride) {
        if (meta == null || basePath == null || basePath.isEmpty()) {
            return;
        }
        this.applyLore(meta, basePath, allowLoreOverride);
        this.applyCustomModelData(meta, basePath);
    }

    private void applyLore(ItemMeta meta, String basePath, boolean allowLoreOverride) {
        boolean hasExistingLore;
        List<String> loreLines = this.collectLoreLines(basePath);
        if (loreLines.isEmpty()) {
            return;
        }
        boolean bl = hasExistingLore = meta.hasLore() && meta.getLore() != null && !meta.getLore().isEmpty();
        if (!allowLoreOverride && hasExistingLore) {
            return;
        }
        List colorized = loreLines.stream().map(this.plugin::colorize).collect(Collectors.toList());
        meta.setLore(colorized);
    }

    private List<String> collectLoreLines(String basePath) {
        Object loreValue = this.config().get(basePath + ".lore");
        if (loreValue instanceof String) {
            String singleLine = (String)loreValue;
            return this.collectSingleLoreLine(singleLine);
        }
        if (loreValue instanceof Collection) {
            Collection collection = (Collection)loreValue;
            return this.collectLoreFromCollection(collection);
        }
        return Collections.emptyList();
    }

    private List<String> collectSingleLoreLine(String line) {
        if (line == null || line.isBlank()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(line);
    }

    private List<String> collectLoreFromCollection(Collection<?> collection) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Object entry : collection) {
            String line = this.normalizeLoreEntry(entry);
            if (line == null) continue;
            lines.add(line);
        }
        return lines;
    }

    private String normalizeLoreEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        String line = entry.toString();
        return line.isBlank() ? null : line;
    }

    private void applyCustomModelData(ItemMeta meta, String basePath) {
        if (!this.config().contains(basePath + ".custom-model-data")) {
            return;
        }
        Integer customModelData = this.parseCustomModelData(this.config().get(basePath + ".custom-model-data"));
        if (customModelData != null) {
            meta.setCustomModelData(customModelData);
        }
    }

    private Integer parseCustomModelData(Object rawValue) {
        String text;
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            return number.intValue();
        }
        if (rawValue instanceof String && !(text = (String)rawValue).isBlank()) {
            try {
                return Integer.parseInt(text.trim());
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

