/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.GuiItemStyler;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class GuiNavigationHelper {
    private final LamMailBox plugin;
    private final NamespacedKey actionKey;
    private final GuiItemStyler itemStyler;

    GuiNavigationHelper(LamMailBox plugin, NamespacedKey actionKey, GuiItemStyler itemStyler) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.actionKey = Objects.requireNonNull(actionKey, "actionKey");
        this.itemStyler = Objects.requireNonNull(itemStyler, "itemStyler");
    }

    void placeBackButton(Inventory inv, String path, String action) {
        ItemStack item;
        ItemMeta meta;
        FileConfiguration config = this.plugin.getConfig();
        if (!config.getBoolean(path + ".enabled", true)) {
            return;
        }
        String materialName = config.getString(path + ".material", "ARROW");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.ARROW;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) == null) {
            return;
        }
        String name = config.getString(path + ".name", "&cBack");
        meta.setDisplayName(this.plugin.colorize(name));
        this.itemStyler.apply(meta, path);
        meta.getPersistentDataContainer().set(this.actionKey, PersistentDataType.STRING, (Object)action);
        item.setItemMeta(meta);
        int slot = config.getInt(path + ".slot", inv.getSize() - 1);
        inv.setItem(slot, item);
    }
}

