/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.CommandItemsClickActions;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.gui.GuiCloseHandler;
import com.yusaki.lammailbox.gui.ItemsGuiClickActions;
import com.yusaki.lammailbox.gui.MailCreationGuiClickActions;
import com.yusaki.lammailbox.gui.MailInventoryHandler;
import com.yusaki.lammailbox.gui.MailViewClickActions;
import com.yusaki.lammailbox.gui.MainGuiClickActions;
import com.yusaki.lammailbox.gui.SentMailGuiClickActions;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryClickHandler
implements MailInventoryHandler {
    private final LamMailBox plugin;
    private final NamespacedKey decorationKey;
    private final NamespacedKey commandItemIndexKey;
    private final NamespacedKey commandItemActionKey;
    private final NamespacedKey actionKey;
    private final NamespacedKey paginationTargetKey;
    private final NamespacedKey mailIdKey;
    private final DecorationCommandExecutor decorationExecutor;
    private final MainGuiClickActions mainGuiActions;
    private final SentMailGuiClickActions sentMailActions;
    private final MailCreationGuiClickActions mailCreationActions;
    private final ItemsGuiClickActions itemsGuiActions;
    private final CommandItemsClickActions commandItemsActions;
    private final MailViewClickActions mailViewActions;
    private final GuiCloseHandler closeHandler;

    public InventoryClickHandler(LamMailBox plugin) {
        this.plugin = plugin;
        this.decorationKey = new NamespacedKey((Plugin)plugin, "decorationPath");
        this.commandItemIndexKey = new NamespacedKey((Plugin)plugin, "commandItemIndex");
        this.commandItemActionKey = new NamespacedKey((Plugin)plugin, "commandItemAction");
        this.actionKey = new NamespacedKey((Plugin)plugin, "action");
        this.paginationTargetKey = new NamespacedKey((Plugin)plugin, "paginationTarget");
        this.mailIdKey = new NamespacedKey((Plugin)plugin, "mailId");
        this.decorationExecutor = new DecorationCommandExecutor(plugin, this.decorationKey);
        this.mainGuiActions = new MainGuiClickActions(plugin, this.actionKey, this.paginationTargetKey, this.decorationExecutor);
        this.sentMailActions = new SentMailGuiClickActions(plugin, this.actionKey, this.paginationTargetKey, this.decorationExecutor);
        this.mailCreationActions = new MailCreationGuiClickActions(plugin, new MailCreationGuiClickActions.NamespacedKeyProvider(this.actionKey), this.decorationExecutor);
        this.itemsGuiActions = new ItemsGuiClickActions(plugin, new ItemsGuiClickActions.NamespacedKeyProvider(this.actionKey), this.decorationExecutor);
        this.commandItemsActions = new CommandItemsClickActions(plugin, this.commandItemIndexKey, this.commandItemActionKey);
        this.mailViewActions = new MailViewClickActions(plugin, this.actionKey, this.mailIdKey, this.decorationExecutor);
        this.closeHandler = new GuiCloseHandler(plugin);
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        boolean isMainGUI;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        ItemStack clicked = event.getCurrentItem();
        String mainTitle = this.plugin.colorize(this.config().getString("gui.main.title"));
        String mainViewingPrefix = this.plugin.colorize(this.config().getString("gui.main.title") + " &7(as ");
        boolean bl = isMainGUI = title.equals(mainTitle) || title.startsWith(mainViewingPrefix);
        if (isMainGUI && event.getClickedInventory() == player.getInventory()) {
            event.setCancelled(true);
            return;
        }
        if (clicked == null || event.getClickedInventory() == event.getWhoClicked().getInventory()) {
            return;
        }
        String sentTitle = this.plugin.colorize(this.config().getString("gui.sent-mail.title"));
        String sentViewingPrefix = this.plugin.colorize(this.config().getString("gui.sent-mail.title") + " &7(as ");
        String commandItemsTitle = this.plugin.colorize(this.config().getString("gui.command-items-editor.title", "Command Items"));
        String commandItemCreatorTitle = this.plugin.colorize(this.config().getString("gui.command-item-creator.title", "Create Command Item"));
        if (isMainGUI) {
            this.mainGuiActions.handle(event, player, clicked);
        } else if (title.equals(sentTitle) || title.startsWith(sentViewingPrefix)) {
            this.sentMailActions.handleListClick(event, player, clicked);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.sent-mail-view.title")))) {
            this.sentMailActions.handleDetailClick(event, player, clicked);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.create-mail.title")))) {
            this.mailCreationActions.handle(event);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.items.title")))) {
            this.itemsGuiActions.handle(event);
        } else if (title.equals(this.plugin.colorize(this.config().getString("gui.mail-view.title")))) {
            this.mailViewActions.handle(event, player, clicked);
        } else if (title.equals(commandItemsTitle)) {
            this.commandItemsActions.handleEditorClick(event, player, clicked);
        } else if (title.equals(commandItemCreatorTitle)) {
            this.commandItemsActions.handleCreatorClick(event, player, clicked);
        }
    }

    @Override
    public void handleClose(InventoryCloseEvent event) {
        this.closeHandler.handle(event);
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

