/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class ItemsGuiClickActions {
    private final LamMailBox plugin;
    private final NamespacedKeyProvider keyProvider;
    private final DecorationCommandExecutor decorationExecutor;

    ItemsGuiClickActions(LamMailBox plugin, NamespacedKeyProvider keyProvider, DecorationCommandExecutor decorationExecutor) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.keyProvider = Objects.requireNonNull(keyProvider, "keyProvider");
        this.decorationExecutor = Objects.requireNonNull(decorationExecutor, "decorationExecutor");
    }

    void handle(InventoryClickEvent event) {
        ItemStack clicked = event.getCurrentItem();
        if (clicked != null && clicked.hasItemMeta()) {
            String action;
            ItemMeta meta = clicked.getItemMeta();
            String string = action = meta != null ? (String)meta.getPersistentDataContainer().get(this.keyProvider.actionKey(), PersistentDataType.STRING) : null;
            if ("items-back".equals(action)) {
                event.setCancelled(true);
                Player player = (Player)event.getWhoClicked();
                player.closeInventory();
                this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCreateMailGUI(player));
                return;
            }
        }
        if (clicked != null && this.decorationExecutor.execute(event, (Player)event.getWhoClicked(), clicked)) {
            return;
        }
        if (this.isEnabled("gui.items.items.save-button") && event.getSlot() == this.config().getInt("gui.items.items.save-button.slot")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
            if (session != null) {
                List<ItemStack> items = this.collectItems(event.getInventory());
                session.setItems(items);
                player.closeInventory();
            }
        }
    }

    private List<ItemStack> collectItems(Inventory inventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int saveSlot = this.config().getInt("gui.items.items.save-button.slot");
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item;
            if (i == saveSlot || (item = inventory.getItem(i)) == null || item.getType() == Material.AIR) continue;
            items.add(item.clone());
        }
        return items;
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }

    record NamespacedKeyProvider(NamespacedKey actionKey) {
    }
}

