/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.Map;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class MailCreationGuiClickActions {
    private final LamMailBox plugin;
    private final NamespacedKeyProvider keyProvider;
    private final DecorationCommandExecutor decorationExecutor;

    MailCreationGuiClickActions(LamMailBox plugin, NamespacedKeyProvider keyProvider, DecorationCommandExecutor decorationExecutor) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.keyProvider = Objects.requireNonNull(keyProvider, "keyProvider");
        this.decorationExecutor = Objects.requireNonNull(decorationExecutor, "decorationExecutor");
    }

    void handle(InventoryClickEvent event) {
        String action;
        Player player = (Player)event.getWhoClicked();
        if (player.hasPermission(this.config().getString("settings.admin-permission")) && event.getClickedInventory() == player.getInventory()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta != null && "create-back".equals(action = (String)meta.getPersistentDataContainer().get(this.keyProvider.actionKey(), PersistentDataType.STRING))) {
            this.plugin.getInMailCreation().put(player.getUniqueId(), true);
            this.plugin.openMainGUI(player);
            return;
        }
        if (this.decorationExecutor.execute(event, player, clicked)) {
            return;
        }
        MailCreationSession session = this.plugin.getMailSessions().get(player.getUniqueId());
        if (session == null) {
            return;
        }
        int slot = event.getSlot();
        if (this.slotMatches("gui.create-mail.items.receiver-head", slot)) {
            this.handleReceiverHeadClick(player);
            return;
        }
        if (this.slotMatches("gui.create-mail.items.message-paper", slot)) {
            this.handleMessagePaperClick(player);
            return;
        }
        if (this.slotMatches("gui.create-mail.items.items-chest", slot)) {
            this.handleItemsChestClick(player);
            return;
        }
        if (this.slotMatches("gui.create-mail.items.send-button", slot)) {
            this.plugin.handleMailSend(player);
            return;
        }
        if (this.slotMatches("gui.create-mail.items.command-block", slot)) {
            this.handleCommandItemsClick(player);
            return;
        }
        if (this.slotMatches("gui.create-mail.items.schedule-clock", slot)) {
            this.handleScheduleClockClick(event, player);
        }
    }

    private void handleReceiverHeadClick(Player player) {
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        player.closeInventory();
        this.plugin.getAwaitingInput().put(player.getUniqueId(), "receiver");
        this.plugin.getMailCreationController().showInputTitle(player, "receiver");
        player.sendMessage(this.plugin.colorize(this.config().getString("messages.enter-receiver")));
    }

    private void handleMessagePaperClick(Player player) {
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        player.closeInventory();
        this.plugin.getAwaitingInput().put(player.getUniqueId(), "message");
        this.plugin.getMailCreationController().showInputTitle(player, "message");
        player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.enter-message")));
    }

    private void handleItemsChestClick(Player player) {
        if (!player.hasPermission(this.config().getString("settings.permissions.add-items"))) {
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.no-permission")));
            return;
        }
        this.plugin.openItemsGUI(player);
    }

    private void handleCommandItemsClick(Player player) {
        if (!player.hasPermission(this.config().getString("settings.admin-permission"))) {
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.no-permission")));
            return;
        }
        this.plugin.openCommandItemsEditor(player);
    }

    private void handleScheduleClockClick(InventoryClickEvent event, Player player) {
        if (!player.hasPermission(this.config().getString("settings.admin-permission"))) {
            return;
        }
        player.closeInventory();
        String awaitingKey = event.getClick().isRightClick() ? "expire-date" : "schedule-date";
        Map<String, String> titles = Map.of("expire-date", "expire", "schedule-date", "schedule");
        this.plugin.getAwaitingInput().put(player.getUniqueId(), awaitingKey);
        this.plugin.getInMailCreation().put(player.getUniqueId(), true);
        this.plugin.getMailCreationController().showInputTitle(player, titles.get(awaitingKey));
        String messageKey = awaitingKey.equals("expire-date") ? "messages.enter-expire-date" : "messages.enter-schedule-date";
        player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString(messageKey)));
    }

    private boolean slotMatches(String path, int slot) {
        return this.isEnabled(path) && slot == this.config().getInt(path + ".slot");
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }

    record NamespacedKeyProvider(NamespacedKey actionKey) {
    }
}

