/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.CommandItemUiComposer;
import com.yusaki.lammailbox.gui.GuiItemStyler;
import com.yusaki.lammailbox.gui.GuiNavigationHelper;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

final class MailCreationViewBuilder {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy:MM:dd:HH:mm");
    private final LamMailBox plugin;
    private final GuiItemStyler itemStyler;
    private final GuiNavigationHelper navigationHelper;
    private final CommandItemUiComposer commandItemUi;
    private final BiConsumer<Inventory, String> decorationApplier;
    private final Predicate<String> enabledChecker;

    MailCreationViewBuilder(LamMailBox plugin, GuiItemStyler itemStyler, GuiNavigationHelper navigationHelper, CommandItemUiComposer commandItemUi, BiConsumer<Inventory, String> decorationApplier, Predicate<String> enabledChecker) {
        this.plugin = plugin;
        this.itemStyler = itemStyler;
        this.navigationHelper = navigationHelper;
        this.commandItemUi = commandItemUi;
        this.decorationApplier = decorationApplier;
        this.enabledChecker = enabledChecker;
    }

    Inventory createMailCreation(Player viewer) {
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(viewer.getUniqueId(), key -> new MailCreationSession());
        this.ensureSessionDefaults(session);
        int size = this.config().getInt("gui.create-mail.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.create-mail.title")));
        this.decorationApplier.accept(inv, "gui.create-mail");
        this.addReceiverHead(inv, viewer, session);
        this.addMessagePaper(inv, session);
        this.addItemsChest(inv, viewer);
        this.addSendButton(inv);
        this.addAdminControls(inv, viewer, session);
        this.navigationHelper.placeBackButton(inv, "gui.create-mail.items.back-button", "create-back");
        return inv;
    }

    Inventory createItemsEditor(Player viewer) {
        int size = this.config().getInt("gui.items.size");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString("gui.items.title")));
        MailCreationSession session = this.plugin.getMailSessions().get(viewer.getUniqueId());
        if (session != null) {
            session.getItems().forEach(item -> inv.addItem(new ItemStack[]{item.clone()}));
        }
        if (this.enabledChecker.test("gui.items.items.save-button")) {
            ItemStack saveButton = new ItemStack(Material.valueOf((String)this.config().getString("gui.items.items.save-button.material")));
            ItemMeta saveMeta = saveButton.getItemMeta();
            if (saveMeta != null) {
                saveMeta.setDisplayName(this.plugin.colorize(this.config().getString("gui.items.items.save-button.name")));
                saveMeta.setLore(this.config().getStringList("gui.items.items.save-button.lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
                this.itemStyler.apply(saveMeta, "gui.items.items.save-button");
                saveButton.setItemMeta(saveMeta);
            }
            inv.setItem(this.config().getInt("gui.items.items.save-button.slot"), saveButton);
        }
        this.navigationHelper.placeBackButton(inv, "gui.items.items.back-button", "items-back");
        return inv;
    }

    Inventory createCommandItemsEditor(Player viewer) {
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(viewer.getUniqueId(), key -> new MailCreationSession());
        this.ensureSessionDefaults(session);
        String base = "gui.command-items-editor";
        int size = this.config().getInt(base + ".size", 45);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString(base + ".title", "Command Items")));
        this.decorationApplier.accept(inv, base);
        List slots = this.config().getIntegerList(base + ".items.command-item.slots");
        this.commandItemUi.openCommandItemsEditor(inv, session, slots);
        if (this.enabledChecker.test(base + ".items.add-button")) {
            ItemStack addButton = this.commandItemUi.buildEditorStaticButton(base + ".items.add-button", "add");
            inv.setItem(this.config().getInt(base + ".items.add-button.slot", size - 5), addButton);
        }
        if (this.enabledChecker.test(base + ".items.back-button")) {
            ItemStack backButton = this.commandItemUi.buildEditorStaticButton(base + ".items.back-button", "back");
            inv.setItem(this.config().getInt(base + ".items.back-button.slot", size - 1), backButton);
        }
        return inv;
    }

    Inventory createCommandItemCreator(Player viewer) {
        MailCreationSession session = this.plugin.getMailSessions().computeIfAbsent(viewer.getUniqueId(), key -> new MailCreationSession());
        this.ensureSessionDefaults(session);
        if (session.getCommandItemDraft() == null) {
            session.setCommandItemDraft(new CommandItem.Builder());
        }
        CommandItem.Builder draft = session.getCommandItemDraft();
        String base = "gui.command-item-creator";
        int size = this.config().getInt(base + ".size", 54);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.plugin.colorize(this.config().getString(base + ".title", "Create Command Item")));
        this.decorationApplier.accept(inv, base);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%material%", draft.materialKey());
        placeholders.put("%name%", draft.displayName());
        placeholders.put("%lore_count%", String.valueOf(draft.lore().size()));
        placeholders.put("%command_count%", String.valueOf(draft.commands().size()));
        placeholders.put("%custom_model_data%", draft.customModelData() != null ? String.valueOf(draft.customModelData()) : "None");
        this.commandItemUi.placeCreatorButton(inv, base + ".items.material-selector", "material", placeholders, draft);
        this.commandItemUi.placeCreatorButton(inv, base + ".items.name-editor", "name", placeholders, draft);
        this.commandItemUi.placeCreatorButton(inv, base + ".items.lore-editor", "lore", placeholders, draft);
        this.commandItemUi.placeCreatorButton(inv, base + ".items.commands-editor", "command", placeholders, draft);
        this.commandItemUi.placeCreatorButton(inv, base + ".items.custom-model-editor", "custom-model", placeholders, draft);
        int previewSlot = this.config().getInt(base + ".items.preview.slot", size / 2);
        ItemStack preview = draft.buildPreviewItem(this.plugin);
        inv.setItem(previewSlot, preview);
        if (this.enabledChecker.test(base + ".items.save-button")) {
            ItemStack save = this.commandItemUi.buildEditorStaticButton(base + ".items.save-button", "save");
            inv.setItem(this.config().getInt(base + ".items.save-button.slot", size - 6), save);
        }
        this.navigationHelper.placeBackButton(inv, base + ".items.back-button", "command-creator-back");
        return inv;
    }

    private void addReceiverHead(Inventory inv, Player viewer, MailCreationSession session) {
        String path = "gui.create-mail.items.receiver-head";
        if (!this.enabledChecker.test(path)) {
            return;
        }
        ItemStack head = new ItemStack(Material.valueOf((String)this.config().getString(path + ".material")));
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return;
        }
        headMeta.setDisplayName(this.plugin.colorize(this.config().getString(path + ".name")));
        List headLore = viewer.hasPermission(this.config().getString("settings.admin-permission")) ? this.config().getStringList(path + ".adminlore") : this.config().getStringList(path + ".lore");
        List lore = headLore.stream().map(this.plugin::colorize).collect(Collectors.toList());
        if (session.getReceiver() != null) {
            lore.add(this.plugin.getMessage(path + ".current-receiver-format", this.plugin.placeholders("receiver", session.getReceiver())));
        }
        headMeta.setLore(lore);
        this.itemStyler.apply((ItemMeta)headMeta, path, false);
        head.setItemMeta((ItemMeta)headMeta);
        inv.setItem(this.config().getInt(path + ".slot"), head);
    }

    private void addMessagePaper(Inventory inv, MailCreationSession session) {
        String path = "gui.create-mail.items.message-paper";
        if (!this.enabledChecker.test(path)) {
            return;
        }
        ItemStack paper = new ItemStack(Material.valueOf((String)this.config().getString(path + ".material")));
        ItemMeta paperMeta = paper.getItemMeta();
        if (paperMeta == null) {
            return;
        }
        paperMeta.setDisplayName(this.plugin.colorize(this.config().getString(path + ".name")));
        List paperLore = this.config().getStringList(path + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList());
        if (session.getMessage() != null) {
            paperLore.add(this.plugin.colorize(this.config().getString(path + ".current-message-prefix")));
            paperLore.addAll(Arrays.stream(session.getMessage().split("\n")).map(line -> this.plugin.colorize(this.config().getString(path + ".message-line-format") + line)).collect(Collectors.toList()));
        }
        paperMeta.setLore(paperLore);
        this.itemStyler.apply(paperMeta, path);
        paper.setItemMeta(paperMeta);
        inv.setItem(this.config().getInt(path + ".slot"), paper);
    }

    private void addItemsChest(Inventory inv, Player viewer) {
        String path = "gui.create-mail.items.items-chest";
        if (!this.enabledChecker.test(path)) {
            return;
        }
        int chestSlot = this.config().getInt(path + ".slot");
        if (!viewer.hasPermission(this.config().getString("settings.permissions.add-items"))) {
            inv.setItem(chestSlot, this.createDisabledFiller());
            return;
        }
        ItemStack chest = new ItemStack(Material.valueOf((String)this.config().getString(path + ".material")));
        ItemMeta chestMeta = chest.getItemMeta();
        if (chestMeta == null) {
            return;
        }
        chestMeta.setDisplayName(this.plugin.colorize(this.config().getString(path + ".name")));
        chestMeta.setLore(this.config().getStringList(path + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(chestMeta, path);
        chest.setItemMeta(chestMeta);
        inv.setItem(chestSlot, chest);
    }

    private void addSendButton(Inventory inv) {
        String path = "gui.create-mail.items.send-button";
        if (!this.enabledChecker.test(path)) {
            return;
        }
        ItemStack sendButton = new ItemStack(Material.valueOf((String)this.config().getString(path + ".material")));
        ItemMeta sendMeta = sendButton.getItemMeta();
        if (sendMeta == null) {
            return;
        }
        sendMeta.setDisplayName(this.plugin.colorize(this.config().getString(path + ".name")));
        sendMeta.setLore(this.config().getStringList(path + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
        this.itemStyler.apply(sendMeta, path);
        sendButton.setItemMeta(sendMeta);
        inv.setItem(this.config().getInt(path + ".slot"), sendButton);
    }

    private void addAdminControls(Inventory inv, Player viewer, MailCreationSession session) {
        int commandSlot = this.config().getInt("gui.create-mail.items.command-block.slot");
        int clockSlot = this.config().getInt("gui.create-mail.items.schedule-clock.slot");
        boolean commandEnabled = this.enabledChecker.test("gui.create-mail.items.command-block");
        boolean clockEnabled = this.enabledChecker.test("gui.create-mail.items.schedule-clock");
        boolean isAdmin = viewer.hasPermission(this.config().getString("settings.admin-permission"));
        if (isAdmin) {
            if (commandEnabled) {
                inv.setItem(commandSlot, this.commandItemUi.createCommandItemsButton(session));
            }
            if (clockEnabled) {
                inv.setItem(clockSlot, this.buildScheduleClock(session));
            }
            return;
        }
        if (commandEnabled) {
            inv.setItem(commandSlot, this.createDisabledFiller());
        }
        if (clockEnabled) {
            inv.setItem(clockSlot, this.createDisabledFiller());
        }
    }

    private ItemStack buildScheduleClock(MailCreationSession session) {
        String basePath = "gui.create-mail.items.schedule-clock";
        ItemStack clock = new ItemStack(Material.valueOf((String)this.config().getString(basePath + ".material")));
        ItemMeta clockMeta = clock.getItemMeta();
        if (clockMeta == null) {
            return clock;
        }
        clockMeta.setDisplayName(this.plugin.colorize(this.config().getString(basePath + ".name")));
        String scheduleTime = session.getScheduleDate() != null ? DATE_FORMAT.format(new Date(session.getScheduleDate())) : "Not set";
        String expireTime = session.getExpireDate() != null ? DATE_FORMAT.format(new Date(session.getExpireDate())) : "Not set";
        List lore = this.config().getStringList(basePath + ".lore").stream().map(line -> this.plugin.applyPlaceholderVariants((String)line, Map.of("schedule_time", scheduleTime, "expire_time", expireTime))).map(this.plugin::colorize).collect(Collectors.toList());
        clockMeta.setLore(lore);
        this.itemStyler.apply(clockMeta, basePath);
        clock.setItemMeta(clockMeta);
        return clock;
    }

    private void ensureSessionDefaults(MailCreationSession session) {
        if (session.getCommands() == null) {
            session.setCommands(new ArrayList<String>());
        }
        if (session.getItems() == null) {
            session.setItems(new ArrayList<ItemStack>());
        }
        if (session.getCommandItems() == null) {
            session.setCommandItems(new ArrayList<CommandItem>());
        }
    }

    private ItemStack createDisabledFiller() {
        ItemStack fallback;
        ItemMeta meta;
        FileConfiguration config = this.config();
        ConfigurationSection decorSection = config.getConfigurationSection("gui.create-mail.decoration");
        if (decorSection != null) {
            for (String key : decorSection.getKeys(false)) {
                String base = "gui.create-mail.decoration." + key;
                String materialName = config.getString(base + ".material");
                if (materialName == null) continue;
                try {
                    Material material = Material.valueOf((String)materialName);
                    ItemStack filler = new ItemStack(material);
                    ItemMeta meta2 = filler.getItemMeta();
                    if (meta2 == null) continue;
                    meta2.setDisplayName(this.plugin.colorize(config.getString(base + ".name", " ")));
                    meta2.setLore(config.getStringList(base + ".lore").stream().map(this.plugin::colorize).collect(Collectors.toList()));
                    filler.setItemMeta(meta2);
                    return filler;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if ((meta = (fallback = new ItemStack(Material.BLACK_STAINED_GLASS_PANE)).getItemMeta()) != null) {
            meta.setDisplayName(" ");
            fallback.setItemMeta(meta);
        }
        return fallback;
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

