/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.repository.MailRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

final class MailViewClickActions {
    private final LamMailBox plugin;
    private final NamespacedKey actionKey;
    private final NamespacedKey mailIdKey;
    private final DecorationCommandExecutor decorationExecutor;

    MailViewClickActions(LamMailBox plugin, NamespacedKey actionKey, NamespacedKey mailIdKey, DecorationCommandExecutor decorationExecutor) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.actionKey = Objects.requireNonNull(actionKey, "actionKey");
        this.mailIdKey = Objects.requireNonNull(mailIdKey, "mailIdKey");
        this.decorationExecutor = Objects.requireNonNull(decorationExecutor, "decorationExecutor");
    }

    void handle(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        boolean claimEnabled;
        event.setCancelled(true);
        if (this.handleButtonAction(event, player, clicked)) {
            return;
        }
        if (this.decorationExecutor.execute(event, player, clicked)) {
            return;
        }
        int buttonSlot = this.config().getInt("gui.mail-view.items.claim-button.slot");
        boolean bl = claimEnabled = this.isEnabled("gui.mail-view.items.claim-button") || this.isEnabled("gui.mail-view.items.dismiss-button");
        if (claimEnabled && event.getSlot() == buttonSlot && (mailId = this.extractMailId(clicked)) != null) {
            this.claimMail(player, mailId);
        }
    }

    private boolean handleButtonAction(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        if (clicked == null || !clicked.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = clicked.getItemMeta();
        String action = (String)meta.getPersistentDataContainer().get(this.actionKey, PersistentDataType.STRING);
        if (action == null) {
            return false;
        }
        if ("mail-view-back".equals(action)) {
            this.navigateBackToMailbox(player);
            return true;
        }
        if ((action.equals("page-prev") || action.equals("page-next")) && (mailId = (String)meta.getPersistentDataContainer().get(this.mailIdKey, PersistentDataType.STRING)) != null) {
            this.handlePagination(player, mailId, action.equals("page-next"));
            return true;
        }
        return false;
    }

    private void navigateBackToMailbox(Player player) {
        String viewingAs = this.plugin.getViewingAsPlayer().get(player.getUniqueId());
        if (viewingAs != null) {
            Player target = Bukkit.getPlayerExact((String)viewingAs);
            if (target != null) {
                this.plugin.openMailboxAsPlayer(player, target);
            } else {
                this.plugin.getViewingAsPlayer().remove(player.getUniqueId());
                this.plugin.openMainGUI(player);
            }
        } else {
            this.plugin.openMainGUI(player);
        }
    }

    private void handlePagination(Player player, String mailId, boolean isNext) {
        int currentPage = this.plugin.getMailViewPages().getOrDefault(player.getUniqueId(), 1);
        List<ItemStack> items = this.plugin.getMailRepository().loadMailItems(mailId);
        int commandCount = this.plugin.getMailRepository().findRecord(mailId).map(record -> record.commandItems().size()).orElse(0);
        List slots = this.config().getIntegerList("gui.mail-view.items.items-display.slots");
        int slotsPerPage = slots != null && !slots.isEmpty() ? slots.size() : 21;
        int totalElements = items.size() + commandCount;
        int totalPages = Math.max(1, (totalElements + slotsPerPage - 1) / slotsPerPage);
        int newPage = isNext ? currentPage + 1 : currentPage - 1;
        if ((newPage = Math.max(1, Math.min(totalPages, newPage))) == currentPage) {
            return;
        }
        this.plugin.getMailViewPages().put(player.getUniqueId(), newPage);
        this.plugin.openMailView(player, mailId);
    }

    private void claimMail(Player player, String mailId) {
        boolean hasRewards;
        List<ItemStack> items = this.plugin.getMailRepository().loadMailItems(mailId);
        Optional<MailRecord> mailRecord = this.plugin.getMailRepository().findRecord(mailId);
        List commandItems = mailRecord.map(MailRecord::commandItems).orElse(Collections.emptyList());
        boolean bl = hasRewards = !items.isEmpty() || !commandItems.isEmpty();
        if (!items.isEmpty()) {
            long emptySlots = Arrays.stream(player.getInventory().getStorageContents()).filter(item -> item == null || item.getType() == Material.AIR).count();
            if (emptySlots < (long)items.size()) {
                this.plugin.sendMessage((CommandSender)player, "messages.prefix");
                this.plugin.sendMessage((CommandSender)player, "messages.inventory-space-needed", this.plugin.placeholders("amount", String.valueOf(items.size())));
                return;
            }
            items.forEach(item -> player.getInventory().addItem(new ItemStack[]{item}));
        }
        if (!commandItems.isEmpty()) {
            this.plugin.getFoliaLib().getScheduler().runNextTick(task -> commandItems.forEach(commandItem -> commandItem.commands().forEach(command -> {
                String processed = command.replace("{player}", player.getName()).replace("%player%", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processed);
            })));
        }
        this.plugin.getMailService().claimMail(player, mailId);
        player.closeInventory();
        this.plugin.openMainGUI(player);
        String messageKey = hasRewards ? "messages.items-claimed" : "messages.no-items-in-mail";
        player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString(messageKey)));
    }

    private String extractMailId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(this.mailIdKey, PersistentDataType.STRING);
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }
}

