/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.repository.MailRecord;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

final class MainGuiClickActions {
    private final LamMailBox plugin;
    private final NamespacedKey actionKey;
    private final NamespacedKey paginationTargetKey;
    private final DecorationCommandExecutor decorationExecutor;

    MainGuiClickActions(LamMailBox plugin, NamespacedKey actionKey, NamespacedKey paginationTargetKey, DecorationCommandExecutor decorationExecutor) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.actionKey = Objects.requireNonNull(actionKey, "actionKey");
        this.paginationTargetKey = Objects.requireNonNull(paginationTargetKey, "paginationTargetKey");
        this.decorationExecutor = Objects.requireNonNull(decorationExecutor, "decorationExecutor");
    }

    void handle(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (this.handlePagination(event, player, clicked)) {
            return;
        }
        if (this.decorationExecutor.execute(event, player, clicked)) {
            return;
        }
        if (this.isEnabled("gui.main.items.create-mail") && event.getSlot() == this.config().getInt("gui.main.items.create-mail.slot")) {
            if (this.isViewingAsOther(player)) {
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.cannot-create-as-other")));
                return;
            }
            this.plugin.openCreateMailGUI(player);
            return;
        }
        if (this.isEnabled("gui.main.items.sent-mail") && event.getSlot() == this.config().getInt("gui.main.items.sent-mail.slot")) {
            this.plugin.openSentMailGUI(player);
            return;
        }
        if (this.isEnabled("gui.main.items.mail-display") && this.config().getIntegerList("gui.main.items.mail-display.slots").contains(event.getSlot()) && (mailId = this.extractMailId(clicked)) != null) {
            this.plugin.openMailView(player, mailId);
        }
    }

    private boolean handlePagination(InventoryClickEvent event, Player player, ItemStack clicked) {
        if (clicked == null || !clicked.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = clicked.getItemMeta();
        String action = (String)meta.getPersistentDataContainer().get(this.actionKey, PersistentDataType.STRING);
        if (action == null || !action.equals("mailbox-page-prev") && !action.equals("mailbox-page-next")) {
            return false;
        }
        String targetName = Optional.ofNullable((String)meta.getPersistentDataContainer().get(this.paginationTargetKey, PersistentDataType.STRING)).filter(name -> !name.isBlank()).orElse(player.getName());
        this.handleMailboxPageNavigation(player, targetName, action.equals("mailbox-page-next"));
        return true;
    }

    private void handleMailboxPageNavigation(Player player, String targetName, boolean isNext) {
        UUID viewerId = player.getUniqueId();
        List slots = this.config().getIntegerList("gui.main.items.mail-display.slots");
        int slotsPerPage = slots != null && !slots.isEmpty() ? slots.size() : 21;
        List records = this.plugin.getMailRepository().listMailIds().stream().map(id -> this.plugin.getMailRepository().findRecord((String)id).orElse(null)).filter(Objects::nonNull).filter(MailRecord::active).filter(record -> record.canBeClaimedBy(targetName)).sorted(Comparator.comparingLong(MailRecord::sentDate).reversed()).collect(Collectors.toList());
        int totalPages = Math.max(1, (records.size() + slotsPerPage - 1) / slotsPerPage);
        int currentPage = this.plugin.getMailboxPages().getOrDefault(viewerId, 1);
        int newPage = isNext ? currentPage + 1 : currentPage - 1;
        if ((newPage = Math.max(1, Math.min(totalPages, newPage))) == currentPage) {
            return;
        }
        this.plugin.getMailboxPages().put(viewerId, newPage);
        if (!targetName.equalsIgnoreCase(player.getName())) {
            Player target = Bukkit.getPlayer((String)targetName);
            if (target != null) {
                this.plugin.openMailboxAsPlayer(player, target);
            } else {
                this.plugin.getViewingAsPlayer().remove(viewerId);
                this.plugin.openMainGUI(player);
            }
        } else {
            this.plugin.openMainGUI(player);
        }
    }

    private boolean isViewingAsOther(Player player) {
        return this.plugin.getViewingAsPlayer().get(player.getUniqueId()) != null;
    }

    private String extractMailId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING);
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }
}

