/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.gui;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.gui.DecorationCommandExecutor;
import com.yusaki.lammailbox.repository.MailRecord;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

final class SentMailGuiClickActions {
    private final LamMailBox plugin;
    private final NamespacedKey actionKey;
    private final NamespacedKey paginationTargetKey;
    private final DecorationCommandExecutor decorationExecutor;

    SentMailGuiClickActions(LamMailBox plugin, NamespacedKey actionKey, NamespacedKey paginationTargetKey, DecorationCommandExecutor decorationExecutor) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.actionKey = Objects.requireNonNull(actionKey, "actionKey");
        this.paginationTargetKey = Objects.requireNonNull(paginationTargetKey, "paginationTargetKey");
        this.decorationExecutor = Objects.requireNonNull(decorationExecutor, "decorationExecutor");
    }

    void handleListClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        event.setCancelled(true);
        if (this.handlePagination(event, player, clicked)) {
            return;
        }
        if (this.decorationExecutor.execute(event, player, clicked)) {
            return;
        }
        if (this.isEnabled("gui.sent-mail.items.back-button") && event.getSlot() == this.config().getInt("gui.sent-mail.items.back-button.slot")) {
            this.handleBackButton(player);
            return;
        }
        if (this.isEnabled("gui.sent-mail.items.sent-mail-display") && this.config().getIntegerList("gui.sent-mail.items.sent-mail-display.slots").contains(event.getSlot()) && (mailId = this.extractMailId(clicked)) != null) {
            this.plugin.openSentMailView(player, mailId);
        }
    }

    void handleDetailClick(InventoryClickEvent event, Player player, ItemStack clicked) {
        String mailId;
        ItemMeta meta;
        String action;
        event.setCancelled(true);
        if (clicked != null && clicked.hasItemMeta() && "sent-mail-view-back".equals(action = (String)(meta = clicked.getItemMeta()).getPersistentDataContainer().get(this.actionKey, PersistentDataType.STRING))) {
            this.plugin.openSentMailGUI(player);
            return;
        }
        if (this.decorationExecutor.execute(event, player, clicked)) {
            return;
        }
        if (this.isEnabled("gui.sent-mail-view.items.delete-button") && event.getSlot() == this.config().getInt("gui.sent-mail-view.items.delete-button.slot") && (mailId = this.extractMailId(clicked)) != null) {
            this.plugin.handleSentMailDelete(player, mailId);
        }
    }

    private boolean handlePagination(InventoryClickEvent event, Player player, ItemStack clicked) {
        if (clicked == null || !clicked.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = clicked.getItemMeta();
        String action = (String)meta.getPersistentDataContainer().get(this.actionKey, PersistentDataType.STRING);
        if (action == null || !action.equals("sent-page-prev") && !action.equals("sent-page-next")) {
            return false;
        }
        String targetName = Optional.ofNullable((String)meta.getPersistentDataContainer().get(this.paginationTargetKey, PersistentDataType.STRING)).filter(name -> !name.isBlank()).orElse(player.getName());
        this.handleSentMailboxPageNavigation(player, targetName, action.equals("sent-page-next"));
        return true;
    }

    private void handleBackButton(Player player) {
        String viewingAs = this.plugin.getViewingAsPlayer().get(player.getUniqueId());
        if (viewingAs != null) {
            Player target = Bukkit.getPlayer((String)viewingAs);
            if (target != null) {
                this.plugin.openMailboxAsPlayer(player, target);
            } else {
                this.plugin.getViewingAsPlayer().remove(player.getUniqueId());
                this.plugin.openMainGUI(player);
            }
        } else {
            this.plugin.openMainGUI(player);
        }
    }

    private void handleSentMailboxPageNavigation(Player player, String targetName, boolean isNext) {
        UUID viewerId = player.getUniqueId();
        List slots = this.config().getIntegerList("gui.sent-mail.items.sent-mail-display.slots");
        int slotsPerPage = slots != null && !slots.isEmpty() ? slots.size() : 21;
        List records = this.plugin.getMailRepository().listMailIdsBySender(targetName).stream().map(id -> this.plugin.getMailRepository().findRecord((String)id).orElse(null)).filter(Objects::nonNull).sorted(Comparator.comparingLong(MailRecord::sentDate).reversed()).collect(Collectors.toList());
        int totalPages = Math.max(1, (records.size() + slotsPerPage - 1) / slotsPerPage);
        int currentPage = this.plugin.getSentMailboxPages().getOrDefault(viewerId, 1);
        int newPage = isNext ? currentPage + 1 : currentPage - 1;
        if ((newPage = Math.max(1, Math.min(totalPages, newPage))) == currentPage) {
            return;
        }
        this.plugin.getSentMailboxPages().put(viewerId, newPage);
        this.plugin.openSentMailGUI(player);
    }

    private String extractMailId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        return (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "mailId"), PersistentDataType.STRING);
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private boolean isEnabled(String path) {
        return this.config().getBoolean(path + ".enabled", true);
    }
}

