/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.lib.cronutils.descriptor;

import com.yusaki.lammailbox.lib.cronutils.Function;
import com.yusaki.lammailbox.lib.cronutils.descriptor.DescriptionStrategy;
import com.yusaki.lammailbox.lib.cronutils.descriptor.NominalDescriptionStrategy;
import com.yusaki.lammailbox.lib.cronutils.descriptor.TimeDescriptionStrategy;
import com.yusaki.lammailbox.lib.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.yusaki.lammailbox.lib.cronutils.model.field.definition.FieldDefinition;
import com.yusaki.lammailbox.lib.cronutils.model.field.expression.Every;
import com.yusaki.lammailbox.lib.cronutils.model.field.expression.FieldExpression;
import com.yusaki.lammailbox.lib.cronutils.model.field.expression.On;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ResourceBundle;

class DescriptionStrategyFactory {
    private DescriptionStrategyFactory() {
    }

    public static DescriptionStrategy daysOfWeekInstance(ResourceBundle bundle, FieldExpression expression, FieldDefinition definition) {
        Function<Integer, String> nominal = integer -> {
            int diff = definition instanceof DayOfWeekFieldDefinition ? DayOfWeek.MONDAY.getValue() - ((DayOfWeekFieldDefinition)definition).getMondayDoWValue().getMondayDoWValue() : 0;
            return DayOfWeek.of(integer + diff < 1 ? 7 : integer + diff).getDisplayName(TextStyle.FULL, bundle.getLocale());
        };
        NominalDescriptionStrategy dow = new NominalDescriptionStrategy(bundle, nominal, expression);
        dow.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case HASH: {
                        return String.format("%s %s %s ", nominal.apply(on.getTime().getValue()), on.getNth(), bundle.getString("of_every_month"));
                    }
                    case L: {
                        return String.format("%s %s %s ", bundle.getString("last"), nominal.apply(on.getTime().getValue()), bundle.getString("of_every_month"));
                    }
                }
                return "";
            }
            return "";
        });
        return dow;
    }

    public static DescriptionStrategy daysOfMonthInstance(ResourceBundle bundle, FieldExpression expression) {
        NominalDescriptionStrategy dom = new NominalDescriptionStrategy(bundle, null, expression);
        dom.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case W: {
                        return String.format("%s %s %s ", bundle.getString("the_nearest_weekday_to_the"), on.getTime().getValue(), bundle.getString("of_the_month"));
                    }
                    case L: {
                        Integer daysBefore = on.getNth().getValue();
                        if (daysBefore > 1) {
                            return MessageFormat.format(bundle.getString("days_before_last_day_of_month"), daysBefore);
                        }
                        if (daysBefore == 1) {
                            return bundle.getString("day_before_last_day_of_month");
                        }
                        return bundle.getString("last_day_of_month");
                    }
                    case LW: {
                        return bundle.getString("last_weekday_of_month");
                    }
                }
                return "";
            }
            return "";
        });
        return dom;
    }

    public static DescriptionStrategy monthsInstance(ResourceBundle bundle, FieldExpression expression) {
        Function<Integer, String> mappingFunction = expression instanceof Every ? Object::toString : integer -> Month.of(integer).getDisplayName(TextStyle.FULL, bundle.getLocale());
        return new NominalDescriptionStrategy(bundle, mappingFunction, expression);
    }

    public static DescriptionStrategy plainInstance(ResourceBundle bundle, FieldExpression expression) {
        return new NominalDescriptionStrategy(bundle, null, expression);
    }

    public static DescriptionStrategy hhMMssInstance(ResourceBundle bundle, FieldExpression hours, FieldExpression minutes, FieldExpression seconds) {
        return new TimeDescriptionStrategy(bundle, hours, minutes, seconds);
    }
}

