/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.lib.cronutils.model.time.generator;

import com.yusaki.lammailbox.lib.cronutils.model.field.CronField;
import com.yusaki.lammailbox.lib.cronutils.model.field.expression.FieldExpression;
import com.yusaki.lammailbox.lib.cronutils.model.field.expression.On;
import com.yusaki.lammailbox.lib.cronutils.model.time.generator.FieldValueGenerator;
import com.yusaki.lammailbox.lib.cronutils.model.time.generator.NoSuchValueException;
import java.util.ArrayList;
import java.util.List;

class OnFieldValueGenerator
extends FieldValueGenerator {
    public OnFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time <= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time >= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time > start && time < end) {
            values.add(time);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        return ((On)this.cronField.getExpression()).getTime().getValue() == value;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }
}

