/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.lib.cronutils.validation;

import com.yusaki.lammailbox.lib.cronutils.model.CronType;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinition;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinitionBuilder;
import com.yusaki.lammailbox.lib.cronutils.parser.CronParser;
import com.yusaki.lammailbox.lib.cronutils.validation.Cron;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class CronValidator
implements ConstraintValidator<Cron, String> {
    private CronType type;

    public void initialize(Cron constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(this.type);
        CronParser cronParser = new CronParser(cronDefinition);
        try {
            cronParser.parse(value).validate();
            return true;
        }
        catch (IllegalArgumentException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

