/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.mailing;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.mailing.MailingDefinition;
import com.yusaki.lammailbox.mailing.MailingType;
import com.yusaki.lammailbox.model.CommandItem;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public final class MailingConfigLoader {
    private final LamMailBox plugin;
    private final File file;

    public MailingConfigLoader(LamMailBox plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.file = new File(plugin.getDataFolder(), "mailings.yml");
    }

    public List<MailingDefinition> load() {
        this.ensureFileExists();
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection root = yaml.getConfigurationSection("mailings");
        if (root == null) {
            return Collections.emptyList();
        }
        ArrayList<MailingDefinition> definitions = new ArrayList<MailingDefinition>();
        for (String id : root.getKeys(false)) {
            MailingDefinition definition;
            ConfigurationSection section = root.getConfigurationSection(id);
            if (section == null || (definition = this.parseDefinition(id, section)) == null) continue;
            definitions.add(definition);
        }
        return definitions;
    }

    private MailingDefinition parseDefinition(String id, ConfigurationSection section) {
        boolean enabled = section.getBoolean("enabled", true);
        String typeRaw = section.getString("type", "REPEATING");
        MailingType type = MailingType.from(typeRaw, MailingType.REPEATING);
        String message = section.getString("message");
        if (message == null || message.isBlank()) {
            this.plugin.getLogger().warning("Mailing " + id + " ignored: missing message");
            return null;
        }
        MailingDefinition.Builder builder = MailingDefinition.builder(id).enabled(enabled).type(type).message(message).sender(section.getString("sender")).receiver(section.getString("receiver")).requiredPermission(section.getString("required-permission")).expireDays(this.parsePositiveInt(section, "expire-days")).itemDirectives(this.cleanStrings(section.getStringList("items"))).commands(this.cleanStrings(section.getStringList("commands")));
        List rawCommandItems = section.getMapList("command-items");
        if (rawCommandItems != null && !rawCommandItems.isEmpty()) {
            builder.commandItems(this.parseCommandItems(rawCommandItems));
        }
        ConfigurationSection schedule = section.getConfigurationSection("schedule");
        if (type == MailingType.REPEATING) {
            this.applyCronSchedule(id, builder, schedule, typeRaw);
        } else if (type == MailingType.FIRST_JOIN) {
            builder.firstJoinDelay(this.parseFirstJoinDelay(schedule));
        }
        return builder.build();
    }

    private void applyCronSchedule(String id, MailingDefinition.Builder builder, ConfigurationSection schedule, String rawType) {
        Long timestamp;
        String runAt;
        if (schedule == null) {
            this.plugin.getLogger().warning("Mailing " + id + " ignored: cron mailings require schedule.cron");
            builder.enabled(false);
            return;
        }
        Object cron = schedule.getString("cron");
        if ((cron == null || ((String)cron).isBlank()) && (runAt = schedule.getString("run-at")) != null && (timestamp = this.parseDateTime(runAt)) != null) {
            Calendar calendar = Calendar.getInstance(Locale.ROOT);
            calendar.setTimeInMillis(timestamp);
            cron = calendar.get(12) + " " + calendar.get(11) + " " + calendar.get(5) + " " + (calendar.get(2) + 1) + " *";
            builder.maxRuns(1);
        }
        if (cron == null || ((String)cron).isBlank()) {
            this.plugin.getLogger().warning("Mailing " + id + " ignored: missing cron expression");
            builder.enabled(false);
            return;
        }
        builder.cronExpression((String)cron);
        Integer maxRuns = this.parsePositiveInt(schedule, "max-runs");
        if (maxRuns != null) {
            builder.maxRuns(maxRuns);
        } else if ("ONE_TIME".equalsIgnoreCase(rawType)) {
            builder.maxRuns(1);
        }
    }

    private Duration parseFirstJoinDelay(ConfigurationSection schedule) {
        if (schedule == null) {
            return null;
        }
        Integer minutes = this.parsePositiveInt(schedule, "delay-minutes");
        if (minutes != null) {
            return Duration.ofMinutes(minutes.intValue());
        }
        Integer seconds = this.parsePositiveInt(schedule, "delay-seconds");
        if (seconds != null) {
            return Duration.ofSeconds(seconds.intValue());
        }
        return null;
    }

    private List<String> cleanStrings(List<String> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        ArrayList<String> cleaned = new ArrayList<String>();
        for (String entry : input) {
            String trimmed;
            if (entry == null || (trimmed = entry.trim()).isEmpty()) continue;
            cleaned.add(trimmed);
        }
        return cleaned;
    }

    private List<CommandItem> parseCommandItems(List<Map<?, ?>> rawItems) {
        ArrayList<CommandItem> items = new ArrayList<CommandItem>();
        for (Map<?, ?> rawItem : rawItems) {
            if (rawItem == null) continue;
            HashMap<String, Object> normalized = new HashMap<String, Object>();
            for (Map.Entry<?, ?> entry : rawItem.entrySet()) {
                if (entry.getKey() == null) continue;
                normalized.put(entry.getKey().toString(), entry.getValue());
            }
            CommandItem item = CommandItem.fromMap(normalized);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private Integer parsePositiveInt(ConfigurationSection section, String path) {
        if (section == null || !section.contains(path)) {
            return null;
        }
        int value = section.getInt(path, -1);
        return value > 0 ? Integer.valueOf(value) : null;
    }

    private Long parseDateTime(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        try {
            String[] parts = raw.trim().split(":");
            if (parts.length != 5) {
                return null;
            }
            int year = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]) - 1;
            int day = Integer.parseInt(parts[2]);
            int hour = Integer.parseInt(parts[3]);
            int minute = Integer.parseInt(parts[4]);
            Calendar calendar = Calendar.getInstance(Locale.ROOT);
            calendar.set(year, month, day, hour, minute, 0);
            calendar.set(14, 0);
            return calendar.getTimeInMillis();
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private void ensureFileExists() {
        if (!this.file.exists()) {
            this.plugin.saveResource("mailings.yml", false);
        }
    }

    public void saveDefaultIfMissing() {
        this.ensureFileExists();
    }

    public File getFile() {
        return this.file;
    }
}

