/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.mailing;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.lib.cronutils.model.Cron;
import com.yusaki.lammailbox.lib.cronutils.model.CronType;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinition;
import com.yusaki.lammailbox.lib.cronutils.model.definition.CronDefinitionBuilder;
import com.yusaki.lammailbox.lib.cronutils.model.time.ExecutionTime;
import com.yusaki.lammailbox.lib.cronutils.parser.CronParser;
import com.yusaki.lammailbox.lib.folialib.FoliaLib;
import com.yusaki.lammailbox.mailing.MailingDefinition;
import com.yusaki.lammailbox.mailing.MailingType;
import com.yusaki.lammailbox.mailing.status.MailingStatusRepository;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.service.MailDelivery;
import com.yusaki.lammailbox.service.MailService;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class MailingScheduler {
    private static final long CHECK_PERIOD_TICKS = 200L;
    private final LamMailBox plugin;
    private final MailService mailService;
    private final MailingStatusRepository statusRepository;
    private final FoliaLib foliaLib;
    private final CronParser cronParser;
    private final ZoneId zoneId;
    private volatile List<MailingDefinition> definitions = Collections.emptyList();
    private volatile List<CronEntry> cronEntries = Collections.emptyList();
    private volatile Map<String, CronEntry> cronEntryIndex = Collections.emptyMap();
    private volatile List<MailingDefinition> firstJoinDefinitions = Collections.emptyList();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile boolean running;

    public MailingScheduler(LamMailBox plugin, MailService mailService, MailingStatusRepository statusRepository, FoliaLib foliaLib) {
        this.plugin = plugin;
        this.mailService = mailService;
        this.statusRepository = statusRepository;
        this.foliaLib = foliaLib;
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX);
        this.cronParser = new CronParser(cronDefinition);
        this.zoneId = ZoneId.systemDefault();
    }

    public void start(List<MailingDefinition> initialDefinitions) {
        this.rebuildSchedules(initialDefinitions);
        if (this.started.compareAndSet(false, true)) {
            this.running = true;
            this.foliaLib.getScheduler().runTimer(this::tick, 200L, 200L);
        }
    }

    public void updateDefinitions(List<MailingDefinition> updated) {
        this.rebuildSchedules(updated);
    }

    public void shutdown() {
        this.running = false;
    }

    public void handlePlayerJoin(Player player) {
        if (!this.running) {
            return;
        }
        this.foliaLib.getScheduler().runAtEntity((Entity)player, task -> {
            boolean firstJoin;
            if (!player.isOnline()) {
                return;
            }
            boolean bl = firstJoin = !player.hasPlayedBefore();
            if (!firstJoin) {
                return;
            }
            String playerName = player.getName();
            UUID uuid = player.getUniqueId();
            for (MailingDefinition definition : this.firstJoinDefinitions) {
                if (!definition.enabled() || definition.type() != MailingType.FIRST_JOIN || definition.requiredPermission() != null && !player.hasPermission(definition.requiredPermission())) continue;
                long now = System.currentTimeMillis();
                if (!this.statusRepository.markReceivedIfNew(definition.id(), uuid, now)) continue;
                Runnable delivery = () -> this.deliverToSinglePlayer(definition, playerName);
                Duration delay = definition.firstJoinDelay();
                if (delay != null && !delay.isNegative() && !delay.isZero()) {
                    long ticks = Math.max(1L, delay.toMillis() / 50L);
                    this.foliaLib.getScheduler().runLater(delayTask -> delivery.run(), ticks);
                    continue;
                }
                this.submit(delivery);
            }
        });
    }

    private void tick() {
        if (!this.running) {
            return;
        }
        ZonedDateTime now = ZonedDateTime.now(this.zoneId);
        for (CronEntry entry : this.cronEntries) {
            this.handleCron(entry, now);
        }
    }

    private void handleCron(CronEntry entry, ZonedDateTime now) {
        ZonedDateTime next;
        Optional<ZonedDateTime> nextExecution;
        MailingDefinition definition = entry.definition();
        if (!definition.enabled()) {
            return;
        }
        Integer maxRuns = definition.maxRuns();
        long lastRunMillis = this.statusRepository.getLastRun(definition.id());
        ZonedDateTime reference = lastRunMillis > 0L ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastRunMillis), this.zoneId) : now.minusMinutes(1L);
        for (int executions = 0; executions < 5 && !(nextExecution = entry.executionTime().nextExecution(reference)).isEmpty() && !(next = nextExecution.get()).isAfter(now); ++executions) {
            long scheduledMillis = next.toInstant().toEpochMilli();
            this.statusRepository.setLastRun(definition.id(), scheduledMillis);
            if (maxRuns != null) {
                if (!this.statusRepository.incrementRunCountIfBelow(definition.id(), maxRuns)) {
                    break;
                }
            } else {
                this.statusRepository.incrementRunCount(definition.id());
            }
            if (!this.deliverGlobal(definition).isPresent()) break;
            reference = next.plusSeconds(1L);
        }
    }

    private Optional<MailDelivery> deliverGlobal(MailingDefinition definition) {
        return this.deliver(definition, this.resolveReceiver(definition.receiver())).map(delivery -> {
            this.plugin.dispatchMailNotifications(delivery.getReceiverSpec(), delivery.getMailId(), definition.sender());
            return delivery;
        });
    }

    private Optional<MailDelivery> deliverToSinglePlayer(MailingDefinition definition, String playerName) {
        return this.deliver(definition, playerName).map(delivery -> {
            this.plugin.dispatchMailNotifications(delivery.getReceiverSpec(), delivery.getMailId(), definition.sender());
            return delivery;
        });
    }

    private Optional<MailDelivery> deliver(MailingDefinition definition, String receiver) {
        MailCreationSession session = new MailCreationSession();
        session.setReceiver(receiver != null && !receiver.isBlank() ? receiver : "all");
        session.setMessage(definition.message());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String directive : definition.itemDirectives()) {
            ItemStack item = this.parseItemDirectiveToItemStack(directive);
            if (item == null) continue;
            items.add(item);
        }
        session.setItems(items);
        session.setCommands(new ArrayList<String>(definition.commands()));
        session.setCommandItems(new ArrayList<CommandItem>(definition.commandItems()));
        if (definition.expireDays() != null) {
            long expireAt = System.currentTimeMillis() + (long)definition.expireDays().intValue() * 86400000L;
            session.setExpireDate(expireAt);
        }
        if (!session.isComplete()) {
            this.plugin.getLogger().warning("Skipping mailing " + definition.id() + " due to incomplete session");
            return Optional.empty();
        }
        try {
            MailDelivery delivery = this.mailService.sendConsoleMail((CommandSender)Bukkit.getConsoleSender(), session);
            if (!definition.sender().equalsIgnoreCase(delivery.getSenderName())) {
                this.plugin.getMailRepository().saveMail(delivery.getMailId(), Map.of("sender", definition.sender()));
            }
            return Optional.of(delivery);
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().warning("Failed to send mailing " + definition.id() + ": " + ex.getMessage());
            return Optional.empty();
        }
    }

    private ItemStack parseItemDirectiveToItemStack(String directive) {
        Material material;
        String[] parts;
        if (directive == null || directive.isBlank()) {
            return null;
        }
        String trimmed = directive.trim();
        if (trimmed.startsWith("/")) {
            trimmed = trimmed.substring(1).trim();
        }
        if (trimmed.toLowerCase(Locale.ROOT).startsWith("give ")) {
            trimmed = trimmed.substring(4).trim();
        }
        if ((parts = trimmed.split("\\s+")).length == 0) {
            return null;
        }
        int index = 0;
        if (parts[index].equalsIgnoreCase("%player%") || parts[index].equalsIgnoreCase("@p") || parts[index].equalsIgnoreCase("@s")) {
            ++index;
        }
        if (index >= parts.length) {
            return null;
        }
        String materialToken = parts[index];
        int nbtStart = materialToken.indexOf(123);
        if (nbtStart >= 0) {
            materialToken = materialToken.substring(0, nbtStart);
        }
        if ((material = this.resolveMaterial(materialToken)) == null) {
            this.plugin.getLogger().warning("Invalid material in mailing item directive: " + directive);
            return null;
        }
        int amount = 1;
        if (++index < parts.length) {
            String candidate = parts[index];
            int braceIndex = candidate.indexOf(123);
            if (braceIndex >= 0) {
                candidate = candidate.substring(0, braceIndex);
            }
            if (!candidate.isEmpty()) {
                try {
                    amount = Integer.parseInt(candidate);
                }
                catch (NumberFormatException ex) {
                    this.plugin.getLogger().warning("Invalid amount in mailing item directive: " + directive + ". Using 1.");
                    amount = 1;
                }
            }
        }
        if (amount <= 0) {
            amount = 1;
        }
        return new ItemStack(material, amount);
    }

    private Material resolveMaterial(String token) {
        Material material;
        String normalized = token.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)normalized);
        if (key != null && (material = (Material)Registry.MATERIAL.get(key)) != null) {
            return material;
        }
        try {
            return Material.valueOf((String)token.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Material.matchMaterial((String)token, (boolean)false);
        }
    }

    private String resolveReceiver(String receiver) {
        return receiver == null || receiver.isBlank() ? "all" : receiver;
    }

    private void submit(Runnable task) {
        this.foliaLib.getScheduler().runNextTick(scheduledTask -> task.run());
    }

    public OptionalLong previewNextRunEpoch(String mailingId) {
        CronEntry entry = this.cronEntryIndex.get(mailingId);
        if (entry == null) {
            return OptionalLong.empty();
        }
        MailingDefinition definition = entry.definition();
        Integer maxRuns = definition.maxRuns();
        int runCount = this.statusRepository.getRunCount(definition.id());
        if (maxRuns != null && runCount >= maxRuns) {
            return OptionalLong.empty();
        }
        long lastRunMillis = this.statusRepository.getLastRun(definition.id());
        ZonedDateTime reference = lastRunMillis > 0L ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastRunMillis), this.zoneId) : ZonedDateTime.now(this.zoneId);
        Optional<ZonedDateTime> next = entry.executionTime().nextExecution(reference);
        return next.map(zonedDateTime -> OptionalLong.of(zonedDateTime.toInstant().toEpochMilli())).orElseGet(OptionalLong::empty);
    }

    private void rebuildSchedules(List<MailingDefinition> updated) {
        List<MailingDefinition> snapshot = Collections.unmodifiableList(new ArrayList<MailingDefinition>(updated));
        this.definitions = snapshot;
        ArrayList<CronEntry> cronList = new ArrayList<CronEntry>();
        HashMap<String, CronEntry> cronMap = new HashMap<String, CronEntry>();
        ArrayList<MailingDefinition> firstJoinList = new ArrayList<MailingDefinition>();
        for (MailingDefinition definition : snapshot) {
            if (definition.type() == MailingType.FIRST_JOIN) {
                firstJoinList.add(definition);
                continue;
            }
            if (definition.type() != MailingType.REPEATING) continue;
            String cronExpression = definition.cronExpression();
            if (cronExpression == null || cronExpression.isBlank()) {
                this.plugin.getLogger().warning("Skipping mailing " + definition.id() + " due to missing cron expression");
                continue;
            }
            try {
                Cron cron = this.cronParser.parse(cronExpression);
                cron.validate();
                ExecutionTime executionTime = ExecutionTime.forCron(cron);
                CronEntry entry = new CronEntry(definition, executionTime);
                cronList.add(entry);
                cronMap.put(definition.id(), entry);
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().warning("Invalid cron expression for mailing " + definition.id() + ": " + ex.getMessage());
            }
        }
        this.cronEntries = Collections.unmodifiableList(cronList);
        this.cronEntryIndex = Collections.unmodifiableMap(cronMap);
        this.firstJoinDefinitions = Collections.unmodifiableList(firstJoinList);
    }

    private record CronEntry(MailingDefinition definition, ExecutionTime executionTime) {
    }
}

