/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.mailing.status;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.mailing.status.MailingStatusRepository;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.sqlite.SQLiteDataSource;

public final class SqliteMailingStatusRepository
implements MailingStatusRepository {
    private static final String GLOBAL_KEY = "__GLOBAL__";
    private final LamMailBox plugin;
    private final SQLiteDataSource dataSource;

    public SqliteMailingStatusRepository(LamMailBox plugin, Path databasePath) {
        this.plugin = plugin;
        this.dataSource = new SQLiteDataSource();
        this.dataSource.setUrl("jdbc:sqlite:" + String.valueOf(databasePath.toAbsolutePath()));
        this.initialize();
    }

    private void initialize() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mailing_status (mailing_id TEXT NOT NULL,player_uuid TEXT NOT NULL,last_sent INTEGER NOT NULL,run_count INTEGER NOT NULL DEFAULT 0,PRIMARY KEY (mailing_id, player_uuid))");
            this.ensureRunCountColumn(connection);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("Failed to initialize mailing status table: " + ex.getMessage());
        }
    }

    private void ensureRunCountColumn(Connection connection) {
        try (ResultSet rs2 = connection.getMetaData().getColumns(null, null, "mailing_status", "run_count");){
            if (rs2.next()) {
                return;
            }
        }
        catch (SQLException rs2) {
            // empty catch block
        }
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("ALTER TABLE mailing_status ADD COLUMN run_count INTEGER NOT NULL DEFAULT 0");
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to add run_count column to mailing_status: " + ex.getMessage());
        }
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try (Statement pragma = connection.createStatement();){
            pragma.execute("PRAGMA foreign_keys = ON");
        }
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLastRun(String mailingId) {
        String sql = "SELECT last_sent FROM mailing_status WHERE mailing_id = ? AND player_uuid = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, mailingId);
            ps.setString(2, GLOBAL_KEY);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0L;
                long l = rs.getLong("last_sent");
                return l;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to read last run for mailing " + mailingId + ": " + ex.getMessage());
        }
        return 0L;
    }

    @Override
    public void setLastRun(String mailingId, long timestamp) {
        try (Connection connection = this.getConnection();){
            this.ensureRow(connection, mailingId, null);
            try (PreparedStatement ps = connection.prepareStatement("UPDATE mailing_status SET last_sent = ? WHERE mailing_id = ? AND player_uuid = ?");){
                ps.setLong(1, timestamp);
                ps.setString(2, mailingId);
                ps.setString(3, GLOBAL_KEY);
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to set last run for mailing " + mailingId + ": " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRunCount(String mailingId) {
        String sql = "SELECT run_count FROM mailing_status WHERE mailing_id = ? AND player_uuid = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, mailingId);
            ps.setString(2, GLOBAL_KEY);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("run_count");
                return n;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to read run count for mailing " + mailingId + ": " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public void incrementRunCount(String mailingId) {
        try (Connection connection = this.getConnection();){
            this.ensureRow(connection, mailingId, null);
            try (PreparedStatement ps = connection.prepareStatement("UPDATE mailing_status SET run_count = run_count + 1 WHERE mailing_id = ? AND player_uuid = ?");){
                ps.setString(1, mailingId);
                ps.setString(2, GLOBAL_KEY);
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to increment run count for mailing " + mailingId + ": " + ex.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean incrementRunCountIfBelow(String mailingId, int maxRuns) {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                this.ensureRow(connection, mailingId, null);
                PreparedStatement ps = connection.prepareStatement("UPDATE mailing_status SET run_count = run_count + 1 WHERE mailing_id = ? AND player_uuid = ? AND run_count < ?");
                try {
                    ps.setString(1, mailingId);
                    ps.setString(2, GLOBAL_KEY);
                    ps.setInt(3, maxRuns);
                    int affected = ps.executeUpdate();
                    boolean bl2 = bl = affected > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to conditionally increment run count for mailing " + mailingId + ": " + ex.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Long> getLastRunForPlayer(String mailingId, UUID playerId) {
        String sql = "SELECT last_sent FROM mailing_status WHERE mailing_id = ? AND player_uuid = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, mailingId);
            ps.setString(2, playerId.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Optional.empty();
                Optional<Long> optional = Optional.of(rs.getLong("last_sent"));
                return optional;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to read player run for mailing " + mailingId + ": " + ex.getMessage());
        }
        return Optional.empty();
    }

    @Override
    public void setLastRunForPlayer(String mailingId, UUID playerId, long timestamp) {
        try (Connection connection = this.getConnection();){
            this.ensureRow(connection, mailingId, playerId);
            try (PreparedStatement ps = connection.prepareStatement("UPDATE mailing_status SET last_sent = ? WHERE mailing_id = ? AND player_uuid = ?");){
                ps.setLong(1, timestamp);
                ps.setString(2, mailingId);
                ps.setString(3, playerId.toString());
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to set player run for mailing " + mailingId + ": " + ex.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasReceived(String mailingId, UUID playerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void markReceived(String mailingId, UUID playerId, long timestamp) {
        this.setLastRunForPlayer(mailingId, playerId, timestamp);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean markReceivedIfNew(String mailingId, UUID playerId, long timestamp) {
        String sql = "INSERT INTO mailing_status (mailing_id, player_uuid, last_sent, run_count) VALUES (?, ?, ?, 0) ON CONFLICT(mailing_id, player_uuid) DO NOTHING";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(sql);
                try {
                    ps.setString(1, mailingId);
                    ps.setString(2, playerId.toString());
                    ps.setLong(3, timestamp);
                    int affected = ps.executeUpdate();
                    boolean bl2 = bl = affected > 0;
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to conditionally mark received for mailing " + mailingId + ": " + ex.getMessage());
            return false;
        }
    }

    @Override
    public void flush() {
    }

    private void ensureRow(Connection connection, String mailingId, UUID playerId) throws SQLException {
        String sql = "INSERT INTO mailing_status (mailing_id, player_uuid, last_sent, run_count) VALUES (?, ?, 0, 0) ON CONFLICT(mailing_id, player_uuid) DO NOTHING";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, mailingId);
            ps.setString(2, playerId == null ? GLOBAL_KEY : playerId.toString());
            ps.executeUpdate();
        }
    }

    @Override
    public void purgeMissingMailings(Set<String> activeIds) {
        String sql = activeIds.isEmpty() ? "DELETE FROM mailing_status" : "DELETE FROM mailing_status WHERE mailing_id NOT IN (" + this.placeholders(activeIds.size()) + ")";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            if (!activeIds.isEmpty()) {
                int index = 1;
                for (String id : activeIds) {
                    ps.setString(index++, id);
                }
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().warning("Failed to purge mailing status entries: " + ex.getMessage());
        }
    }

    private String placeholders(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append('?');
        }
        return builder.toString();
    }
}

