/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.mailing.status;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.mailing.status.MailingStatusRepository;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public final class YamlMailingStatusRepository
implements MailingStatusRepository {
    private final LamMailBox plugin;
    private final File file;
    private final YamlConfiguration yaml;

    public YamlMailingStatusRepository(LamMailBox plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "mailing-status.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().warning("Unable to create mailing-status.yml: " + e.getMessage());
            }
        }
        this.yaml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public synchronized long getLastRun(String mailingId) {
        return this.yaml.getLong(this.nodePath(mailingId, "last-run"), 0L);
    }

    @Override
    public synchronized void setLastRun(String mailingId, long timestamp) {
        this.ensureMailingSection(mailingId);
        this.yaml.set(this.nodePath(mailingId, "last-run"), (Object)timestamp);
        this.saveQuietly();
    }

    @Override
    public synchronized int getRunCount(String mailingId) {
        return this.yaml.getInt(this.nodePath(mailingId, "run-count"), 0);
    }

    @Override
    public synchronized void incrementRunCount(String mailingId) {
        this.ensureMailingSection(mailingId);
        String path = this.nodePath(mailingId, "run-count");
        int current = this.yaml.getInt(path, 0) + 1;
        this.yaml.set(path, (Object)current);
        this.saveQuietly();
    }

    @Override
    public synchronized boolean incrementRunCountIfBelow(String mailingId, int maxRuns) {
        this.ensureMailingSection(mailingId);
        String path = this.nodePath(mailingId, "run-count");
        int current = this.yaml.getInt(path, 0);
        if (current >= maxRuns) {
            return false;
        }
        this.yaml.set(path, (Object)(current + 1));
        this.saveQuietly();
        return true;
    }

    @Override
    public synchronized Optional<Long> getLastRunForPlayer(String mailingId, UUID playerId) {
        String path = this.nodePath(mailingId, "players." + String.valueOf(playerId));
        if (!this.yaml.contains(path)) {
            return Optional.empty();
        }
        return Optional.of(this.yaml.getLong(path));
    }

    @Override
    public synchronized void setLastRunForPlayer(String mailingId, UUID playerId, long timestamp) {
        this.ensureMailingSection(mailingId);
        this.yaml.set(this.nodePath(mailingId, "players." + String.valueOf(playerId)), (Object)timestamp);
        this.saveQuietly();
    }

    @Override
    public synchronized boolean hasReceived(String mailingId, UUID playerId) {
        return this.yaml.contains(this.nodePath(mailingId, "players." + String.valueOf(playerId)));
    }

    @Override
    public synchronized void markReceived(String mailingId, UUID playerId, long timestamp) {
        this.setLastRunForPlayer(mailingId, playerId, timestamp);
    }

    @Override
    public synchronized boolean markReceivedIfNew(String mailingId, UUID playerId, long timestamp) {
        String path = this.nodePath(mailingId, "players." + String.valueOf(playerId));
        if (this.yaml.contains(path)) {
            return false;
        }
        this.ensureMailingSection(mailingId);
        this.yaml.set(path, (Object)timestamp);
        this.saveQuietly();
        return true;
    }

    @Override
    public synchronized void flush() {
        this.saveQuietly();
    }

    @Override
    public synchronized void purgeMissingMailings(Set<String> activeIds) {
        ConfigurationSection root = this.yaml.getConfigurationSection("mailings");
        if (root == null) {
            return;
        }
        boolean changed = false;
        for (String key : root.getKeys(false)) {
            if (activeIds.contains(key)) continue;
            this.yaml.set("mailings." + key, null);
            changed = true;
        }
        if (changed) {
            this.saveQuietly();
        }
    }

    private void saveQuietly() {
        try {
            this.yaml.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save mailing-status.yml: " + e.getMessage());
        }
    }

    private String nodePath(String mailingId, String suffix) {
        return "mailings." + mailingId + "." + suffix;
    }

    private void ensureMailingSection(String mailingId) {
        String base = "mailings." + mailingId;
        if (!this.yaml.contains(base)) {
            this.yaml.createSection(base);
        }
    }
}

