/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.model;

import com.yusaki.lammailbox.LamMailBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class CommandItem {
    private static final String DEFAULT_MATERIAL = "COMMAND_BLOCK";
    private final String materialKey;
    private final String displayName;
    private final List<String> lore;
    private final List<String> commands;
    private final Integer customModelData;

    private CommandItem(Builder builder) {
        this.materialKey = builder.materialKey;
        this.displayName = builder.displayName;
        this.lore = Collections.unmodifiableList(new ArrayList<String>(builder.lore));
        this.commands = Collections.unmodifiableList(new ArrayList<String>(builder.commands));
        this.customModelData = builder.customModelData;
    }

    public String materialKey() {
        return this.materialKey;
    }

    public String displayName() {
        return this.displayName;
    }

    public List<String> lore() {
        return this.lore;
    }

    public List<String> commands() {
        return this.commands;
    }

    public Integer customModelData() {
        return this.customModelData;
    }

    public ItemStack toPreviewItem(LamMailBox plugin) {
        ItemStack stack;
        ItemMeta meta;
        Material material = CommandItem.resolveMaterial(this.materialKey);
        if (material == null) {
            material = Material.COMMAND_BLOCK;
        }
        if ((meta = (stack = new ItemStack(material)).getItemMeta()) != null) {
            String name = this.displayName == null || this.displayName.isBlank() ? "&6Console Action" : this.displayName;
            meta.setDisplayName(plugin.colorize(name));
            List<Object> displayLore = this.lore.isEmpty() ? Collections.emptyList() : this.lore;
            List<String> loreLines = displayLore.stream().map(plugin::colorize).toList();
            meta.setLore(loreLines);
            if (this.customModelData != null) {
                meta.setCustomModelData(this.customModelData);
            }
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("material", this.materialKey);
        map.put("name", this.displayName);
        map.put("lore", new ArrayList<String>(this.lore));
        map.put("commands", new ArrayList<String>(this.commands));
        if (this.customModelData != null) {
            map.put("custom-model-data", this.customModelData);
        }
        return map;
    }

    public static CommandItem fromMap(Map<String, Object> map) {
        Object customModelData;
        Object commandsRaw;
        Object loreRaw;
        Object name;
        String materialStr;
        if (map == null) {
            return null;
        }
        Builder builder = new Builder();
        Object material = map.get("material");
        if (material instanceof String && !(materialStr = (String)material).isBlank()) {
            builder.material(materialStr.trim());
        }
        if ((name = map.get("name")) instanceof String) {
            String nameStr = (String)name;
            builder.displayName(nameStr);
        }
        if ((loreRaw = map.get("lore")) instanceof List) {
            List list = (List)loreRaw;
            for (Object entry : list) {
                if (entry == null) continue;
                builder.addLoreLine(entry.toString());
            }
        }
        if ((commandsRaw = map.get("commands")) instanceof List) {
            List list = (List)commandsRaw;
            for (Object entry : list) {
                if (entry == null) continue;
                builder.addCommand(entry.toString());
            }
        }
        if ((customModelData = map.get("custom-model-data")) instanceof Number) {
            Number number = (Number)customModelData;
            builder.customModelData(number.intValue());
        } else if (customModelData instanceof String) {
            String value = (String)customModelData;
            try {
                builder.customModelData(Integer.parseInt(value.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public static CommandItem legacyFromCommand(String command) {
        Builder builder = new Builder();
        builder.addCommand(command);
        builder.displayName("&6Console Command");
        builder.addLoreLine("&7Runs:&f " + command);
        return builder.build();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.material(this.materialKey);
        builder.displayName(this.displayName);
        builder.lore.addAll(this.lore);
        builder.commands.addAll(this.commands);
        builder.customModelData(this.customModelData);
        return builder;
    }

    private static Material resolveMaterial(String materialKey) {
        if (materialKey == null || materialKey.isBlank()) {
            return Material.matchMaterial((String)DEFAULT_MATERIAL);
        }
        Material match = Material.matchMaterial((String)materialKey);
        if (match != null) {
            return match;
        }
        try {
            return Material.valueOf((String)materialKey.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignored) {
            return Material.matchMaterial((String)DEFAULT_MATERIAL);
        }
    }

    public static final class Builder {
        private String materialKey = "COMMAND_BLOCK";
        private String displayName = "&6Command Item";
        private final List<String> lore = new ArrayList<String>();
        private final List<String> commands = new ArrayList<String>();
        private Integer customModelData;

        public Builder material(String materialKey) {
            if (materialKey != null && !materialKey.isBlank()) {
                this.materialKey = materialKey.trim().toUpperCase(Locale.ROOT);
            }
            return this;
        }

        public Builder displayName(String displayName) {
            if (displayName != null) {
                this.displayName = displayName;
            }
            return this;
        }

        public Builder clearLore() {
            this.lore.clear();
            return this;
        }

        public Builder addLoreLine(String line) {
            if (line != null) {
                this.lore.add(line);
            }
            return this;
        }

        public boolean removeLastLoreLine() {
            if (this.lore.isEmpty()) {
                return false;
            }
            this.lore.remove(this.lore.size() - 1);
            return true;
        }

        public Builder setLore(List<String> lines) {
            this.lore.clear();
            if (lines != null) {
                lines.forEach(this::addLoreLine);
            }
            return this;
        }

        public Builder clearCommands() {
            this.commands.clear();
            return this;
        }

        public Builder addCommand(String command) {
            if (command != null && !command.isBlank()) {
                this.commands.add(command.trim());
            }
            return this;
        }

        public boolean removeLastCommand() {
            if (this.commands.isEmpty()) {
                return false;
            }
            this.commands.remove(this.commands.size() - 1);
            return true;
        }

        public Builder setCommands(List<String> commands) {
            this.commands.clear();
            if (commands != null) {
                commands.forEach(this::addCommand);
            }
            return this;
        }

        public String materialKey() {
            return this.materialKey;
        }

        public List<String> lore() {
            return this.lore;
        }

        public List<String> commands() {
            return this.commands;
        }

        public String displayName() {
            return this.displayName;
        }

        public Integer customModelData() {
            return this.customModelData;
        }

        public Builder customModelData(Integer customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public CommandItem build() {
            return new CommandItem(this);
        }

        public ItemStack buildPreviewItem(LamMailBox plugin) {
            return this.build().toPreviewItem(plugin);
        }
    }
}

