/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.repository;

import com.yusaki.lammailbox.repository.MailRecord;
import com.yusaki.lammailbox.repository.MailRepository;
import com.yusaki.lammailbox.util.ItemSerialization;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.sqlite.SQLiteDataSource;

public class SqliteMailRepository
implements MailRepository {
    private static final Map<String, String> COLUMN_MAPPING = SqliteMailRepository.createColumnMapping();
    private final JavaPlugin plugin;
    private final SQLiteDataSource dataSource;

    public SqliteMailRepository(JavaPlugin plugin, Path databasePath) {
        this.plugin = plugin;
        this.dataSource = this.createDataSource(databasePath);
        this.initialize();
    }

    private SQLiteDataSource createDataSource(Path databasePath) {
        SQLiteDataSource dataSource = new SQLiteDataSource();
        dataSource.setUrl("jdbc:sqlite:" + String.valueOf(databasePath.toAbsolutePath()));
        return dataSource;
    }

    private void initialize() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mail (mail_id TEXT PRIMARY KEY,sender TEXT,receiver TEXT,message TEXT,sent_date INTEGER,schedule_date INTEGER,expire_date INTEGER,active INTEGER NOT NULL DEFAULT 1,admin_mail INTEGER NOT NULL DEFAULT 0,command_block TEXT)");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mail_claimed (mail_id TEXT NOT NULL,player TEXT NOT NULL,PRIMARY KEY (mail_id, player),FOREIGN KEY (mail_id) REFERENCES mail(mail_id) ON DELETE CASCADE)");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mail_commands (mail_id TEXT NOT NULL,ordinal INTEGER NOT NULL,command TEXT NOT NULL,PRIMARY KEY (mail_id, ordinal),FOREIGN KEY (mail_id) REFERENCES mail(mail_id) ON DELETE CASCADE)");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mail_command_items (mail_id TEXT NOT NULL,ordinal INTEGER NOT NULL,material TEXT,display_name TEXT,lore TEXT,commands TEXT,custom_model_data INTEGER,PRIMARY KEY (mail_id, ordinal),FOREIGN KEY (mail_id) REFERENCES mail(mail_id) ON DELETE CASCADE)");
            this.addColumnIfAbsent(connection, "mail_command_items", "custom_model_data", "INTEGER");
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS mail_items (mail_id TEXT NOT NULL,ordinal INTEGER NOT NULL,item TEXT NOT NULL,PRIMARY KEY (mail_id, ordinal),FOREIGN KEY (mail_id) REFERENCES mail(mail_id) ON DELETE CASCADE)");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize SQLite database: " + e.getMessage());
        }
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try (Statement pragma = connection.createStatement();){
            pragma.execute("PRAGMA foreign_keys = ON");
        }
        return connection;
    }

    @Override
    public Map<String, Object> loadMail(String mailId) {
        Map<String, Object> map;
        block8: {
            Connection connection = this.getConnection();
            try {
                map = this.loadMail(connection, mailId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning("Failed to load mail " + mailId + ": " + e.getMessage());
                    return Collections.emptyMap();
                }
            }
            connection.close();
        }
        return map;
    }

    private Map<String, Object> loadMail(Connection connection, String mailId) throws SQLException {
        String sql = "SELECT sender, receiver, message, sent_date, schedule_date, expire_date, active, admin_mail, command_block FROM mail WHERE mail_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            HashMap<String, Object> hashMap;
            block16: {
                ResultSet rs;
                block14: {
                    Map<String, Object> map;
                    block15: {
                        statement.setString(1, mailId);
                        rs = statement.executeQuery();
                        try {
                            if (rs.next()) break block14;
                            map = Collections.emptyMap();
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return map;
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("sender", rs.getString("sender"));
                data.put("receiver", rs.getString("receiver"));
                data.put("message", rs.getString("message"));
                data.put("sent-date", rs.getLong("sent_date"));
                Long scheduleDate = SqliteMailRepository.getNullableLong(rs, "schedule_date");
                Long expireDate = SqliteMailRepository.getNullableLong(rs, "expire_date");
                data.put("schedule-date", scheduleDate);
                data.put("expire-date", expireDate);
                data.put("active", rs.getInt("active") != 0);
                data.put("is-admin-mail", rs.getInt("admin_mail") != 0);
                data.put("command-block", rs.getString("command_block"));
                data.put("claimed-players", this.loadClaimedPlayers(connection, mailId));
                data.put("commands", this.loadCommands(connection, mailId));
                data.put("command-items", this.loadCommandItems(connection, mailId));
                hashMap = data;
                if (rs == null) break block16;
                rs.close();
            }
            return hashMap;
        }
    }

    @Override
    public void saveMail(String mailId, Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        try (Connection connection = this.getConnection();){
            boolean previousAutoCommit = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                this.ensureMailRow(connection, mailId);
                ArrayList<String> columns = new ArrayList<String>();
                ArrayList<Object> values = new ArrayList<Object>();
                block24: for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    switch (key) {
                        case "claimed-players": {
                            this.replaceClaimedPlayers(connection, mailId, SqliteMailRepository.asStringList(value));
                            continue block24;
                        }
                        case "commands": {
                            this.replaceCommands(connection, mailId, SqliteMailRepository.asStringList(value));
                            continue block24;
                        }
                        case "command-items": {
                            this.replaceCommandItems(connection, mailId, SqliteMailRepository.asCommandItemMapList(value));
                            continue block24;
                        }
                    }
                    String column = SqliteMailRepository.toColumnName(key);
                    if (column == null) continue;
                    columns.add(column);
                    values.add(value);
                }
                if (!columns.isEmpty()) {
                    this.updateColumns(connection, mailId, columns, values);
                }
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException rollback) {
                    this.plugin.getLogger().warning("Failed to rollback SQLite transaction: " + rollback.getMessage());
                }
                throw e;
            }
            finally {
                connection.setAutoCommit(previousAutoCommit);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save mail " + mailId + ": " + e.getMessage());
        }
    }

    private void updateColumns(Connection connection, String mailId, List<String> columns, List<Object> values) throws SQLException {
        StringBuilder sql = new StringBuilder("UPDATE mail SET ");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i)).append(" = ?");
        }
        sql.append(" WHERE mail_id = ?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int i = 0; i < columns.size(); ++i) {
                this.applyValue(statement, i + 1, columns.get(i), values.get(i));
            }
            statement.setString(columns.size() + 1, mailId);
            statement.executeUpdate();
        }
    }

    private void applyValue(PreparedStatement statement, int index, String column, Object value) throws SQLException {
        switch (column) {
            case "sender": 
            case "receiver": 
            case "message": 
            case "command_block": {
                if (value == null) {
                    statement.setNull(index, 12);
                    break;
                }
                statement.setString(index, value.toString());
                break;
            }
            case "sent_date": 
            case "schedule_date": 
            case "expire_date": {
                if (value == null) {
                    statement.setNull(index, -5);
                    break;
                }
                statement.setLong(index, SqliteMailRepository.toLong(value));
                break;
            }
            case "active": 
            case "admin_mail": {
                statement.setInt(index, SqliteMailRepository.toBoolean(value) ? 1 : 0);
                break;
            }
            default: {
                throw new SQLException("Unknown column " + column);
            }
        }
    }

    private void ensureMailRow(Connection connection, String mailId) throws SQLException {
        String sql = "INSERT INTO mail (mail_id, sent_date) VALUES (?, ?) ON CONFLICT(mail_id) DO UPDATE SET sent_date = sent_date";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, mailId);
            statement.setLong(2, Instant.now().toEpochMilli());
            statement.executeUpdate();
        }
    }

    private void replaceClaimedPlayers(Connection connection, String mailId, List<String> players) throws SQLException {
        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM mail_claimed WHERE mail_id = ?");){
            delete.setString(1, mailId);
            delete.executeUpdate();
        }
        if (players.isEmpty()) {
            return;
        }
        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO mail_claimed (mail_id, player) VALUES (?, ?)");){
            for (String player : players) {
                insert.setString(1, mailId);
                insert.setString(2, player);
                insert.addBatch();
            }
            insert.executeBatch();
        }
    }

    private void replaceCommands(Connection connection, String mailId, List<String> commands) throws SQLException {
        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM mail_commands WHERE mail_id = ?");){
            delete.setString(1, mailId);
            delete.executeUpdate();
        }
        if (commands.isEmpty()) {
            return;
        }
        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO mail_commands (mail_id, ordinal, command) VALUES (?, ?, ?)");){
            for (int i = 0; i < commands.size(); ++i) {
                insert.setString(1, mailId);
                insert.setInt(2, i);
                insert.setString(3, commands.get(i));
                insert.addBatch();
            }
            insert.executeBatch();
        }
    }

    private void replaceCommandItems(Connection connection, String mailId, List<Map<String, Object>> commandItems) throws SQLException {
        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM mail_command_items WHERE mail_id = ?");){
            delete.setString(1, mailId);
            delete.executeUpdate();
        }
        if (commandItems.isEmpty()) {
            return;
        }
        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO mail_command_items (mail_id, ordinal, material, display_name, lore, commands, custom_model_data) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            for (int i = 0; i < commandItems.size(); ++i) {
                Map<String, Object> item = commandItems.get(i);
                insert.setString(1, mailId);
                insert.setInt(2, i);
                insert.setString(3, SqliteMailRepository.nullableString(item.get("material")));
                insert.setString(4, SqliteMailRepository.nullableString(item.get("name")));
                insert.setString(5, SqliteMailRepository.joinList(SqliteMailRepository.asStringList(item.get("lore"))));
                insert.setString(6, SqliteMailRepository.joinList(SqliteMailRepository.asStringList(item.get("commands"))));
                Integer customModel = SqliteMailRepository.toNullableInteger(item.get("custom-model-data"));
                if (customModel != null) {
                    insert.setInt(7, customModel);
                } else {
                    insert.setNull(7, 4);
                }
                insert.addBatch();
            }
            insert.executeBatch();
        }
    }

    private List<String> loadClaimedPlayers(Connection connection, String mailId) throws SQLException {
        ArrayList<String> players = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT player FROM mail_claimed WHERE mail_id = ? ORDER BY player");){
            statement.setString(1, mailId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    players.add(rs.getString("player"));
                }
            }
        }
        return players;
    }

    private List<String> loadCommands(Connection connection, String mailId) throws SQLException {
        ArrayList<String> commands = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement("SELECT command FROM mail_commands WHERE mail_id = ? ORDER BY ordinal");){
            statement.setString(1, mailId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    commands.add(rs.getString("command"));
                }
            }
        }
        return commands;
    }

    private List<Map<String, Object>> loadCommandItems(Connection connection, String mailId) throws SQLException {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        String sql = "SELECT material, display_name, lore, commands, custom_model_data FROM mail_command_items WHERE mail_id = ? ORDER BY ordinal";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, mailId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("material", rs.getString("material"));
                    item.put("name", rs.getString("display_name"));
                    item.put("lore", SqliteMailRepository.splitString(rs.getString("lore")));
                    item.put("commands", SqliteMailRepository.splitString(rs.getString("commands")));
                    Integer customModel = SqliteMailRepository.getNullableInteger(rs, "custom_model_data");
                    if (customModel != null) {
                        item.put("custom-model-data", customModel);
                    }
                    items.add(item);
                }
            }
        }
        return items;
    }

    @Override
    public void deleteMail(String mailId) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement("DELETE FROM mail WHERE mail_id = ?");){
            statement.setString(1, mailId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to delete mail " + mailId + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> listMailIds() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> listMailIdsBySender(String sender) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<String> listActiveMailIdsFor(String playerName) {
        String sql = "SELECT mail_id FROM mail WHERE active = 1";
        ArrayList<String> ids = new ArrayList<String>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String mailId = rs.getString("mail_id");
                Map<String, Object> data = this.loadMail(connection, mailId);
                MailRecord.from(mailId, data).ifPresent(record -> {
                    if (record.canBeClaimedBy(playerName)) {
                        ids.add(mailId);
                    }
                });
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to list active mails for " + playerName + ": " + e.getMessage());
        }
        return ids;
    }

    @Override
    public Optional<Map<String, Object>> findMail(String mailId) {
        Map<String, Object> data = this.loadMail(mailId);
        return data.isEmpty() ? Optional.empty() : Optional.of(data);
    }

    @Override
    public void save() {
    }

    @Override
    public void saveMailItems(String mailId, List<ItemStack> items) {
        List<String> serialized = ItemSerialization.serializeItems(items);
        try (Connection connection = this.getConnection();){
            boolean previousAutoCommit = connection.getAutoCommit();
            try {
                connection.setAutoCommit(false);
                try (PreparedStatement delete = connection.prepareStatement("DELETE FROM mail_items WHERE mail_id = ?");){
                    delete.setString(1, mailId);
                    delete.executeUpdate();
                }
                if (!serialized.isEmpty()) {
                    try (PreparedStatement insert = connection.prepareStatement("INSERT INTO mail_items (mail_id, ordinal, item) VALUES (?, ?, ?)");){
                        for (int i = 0; i < serialized.size(); ++i) {
                            insert.setString(1, mailId);
                            insert.setInt(2, i);
                            insert.setString(3, serialized.get(i));
                            insert.addBatch();
                        }
                        insert.executeBatch();
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException rollback) {
                    this.plugin.getLogger().warning("Failed to rollback SQLite transaction: " + rollback.getMessage());
                }
                throw e;
            }
            finally {
                connection.setAutoCommit(previousAutoCommit);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save items for mail " + mailId + ": " + e.getMessage());
        }
    }

    @Override
    public List<ItemStack> loadMailItems(String mailId) {
        String sql = "SELECT item FROM mail_items WHERE mail_id = ? ORDER BY ordinal";
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, mailId);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String serialized = rs.getString("item");
                    ItemStack item = ItemSerialization.deserializeItem(serialized);
                    if (item == null) continue;
                    items.add(item);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load items for mail " + mailId + ": " + e.getMessage());
        }
        return items;
    }

    @Override
    public Optional<MailRecord> findRecord(String mailId) {
        Map<String, Object> data = this.loadMail(mailId);
        return MailRecord.from(mailId, data);
    }

    @Override
    public int countActiveMailFor(String playerName) {
        List<String> ids = this.listActiveMailIdsFor(playerName);
        return ids.size();
    }

    @Override
    public void shutdown() {
    }

    private static Map<String, String> createColumnMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sender", "sender");
        map.put("receiver", "receiver");
        map.put("message", "message");
        map.put("sent-date", "sent_date");
        map.put("schedule-date", "schedule_date");
        map.put("expire-date", "expire_date");
        map.put("active", "active");
        map.put("is-admin-mail", "admin_mail");
        map.put("command-block", "command_block");
        return Collections.unmodifiableMap(map);
    }

    private static String toColumnName(String key) {
        return COLUMN_MAPPING.get(key);
    }

    private static long toLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(((String)value).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(value) + " to long");
    }

    private static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(((String)value).trim());
        }
        return false;
    }

    private static List<String> asStringList(Object value) {
        if (value instanceof List) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object element : (List)value) {
                if (element == null) continue;
                result.add(element.toString());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static List<Map<String, Object>> asCommandItemMapList(Object value) {
        if (value instanceof List) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Object element : (List)value) {
                if (!(element instanceof Map)) continue;
                Map raw = (Map)element;
                HashMap map = new HashMap();
                for (Map.Entry entry : raw.entrySet()) {
                    if (entry.getKey() == null) continue;
                    map.put(entry.getKey().toString(), entry.getValue());
                }
                result.add(map);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static String joinList(List<String> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"\n", values);
    }

    private static List<String> splitString(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = value.split("\n", -1);
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            list.add(part);
        }
        return list;
    }

    private void addColumnIfAbsent(Connection connection, String table, String column, String definition) {
        try {
            if (this.columnExists(connection, table, column)) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("ALTER TABLE " + table + " ADD COLUMN " + column + " " + definition);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to add column " + column + " to table " + table + ": " + e.getMessage());
        }
    }

    private boolean columnExists(Connection connection, String table, String column) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("PRAGMA table_info(" + table + ")");){
            while (true) {
                if (rs.next()) {
                    String name = rs.getString("name");
                    if (name == null || !name.equalsIgnoreCase(column)) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return false;
    }

    private static String nullableString(Object value) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        return str.isEmpty() ? null : str;
    }

    private static Integer toNullableInteger(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            String trimmed = text.trim();
            if (trimmed.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(trimmed);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    private static Long getNullableLong(ResultSet rs, String column) throws SQLException {
        long value = rs.getLong(column);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    private static Integer getNullableInteger(ResultSet rs, String column) throws SQLException {
        int value = rs.getInt(column);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }
}

