/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.session;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.model.CommandItem;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class MailCreationController {
    private final LamMailBox plugin;

    public MailCreationController(LamMailBox plugin) {
        this.plugin = plugin;
    }

    public void showInputTitle(Player player, String type) {
        String path = "titles.input." + type;
        String rawTitle = this.config().getString(path + ".title", this.config().getString("titles.input.command.title"));
        String rawSubtitle = this.config().getString(path + ".subtitle", this.config().getString("titles.input.command.subtitle"));
        String title = this.plugin.colorize(rawTitle != null ? rawTitle : "");
        String subtitle = this.plugin.colorize(rawSubtitle != null ? rawSubtitle : "");
        int fadeIn = this.config().getInt("titles.input.fadein");
        int stay = this.config().getInt("titles.input.stay");
        int fadeOut = this.config().getInt("titles.input.fadeout");
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public void showResponseTitle(Player player, boolean success, String customSubtitle) {
        String type = success ? "success" : "error";
        String titlePath = "titles.response." + type;
        String title = this.plugin.colorize(this.config().getString(titlePath + ".title"));
        String subtitle = customSubtitle != null ? this.plugin.colorize(customSubtitle) : this.plugin.colorize(this.config().getString(titlePath + ".subtitle"));
        int fadeIn = this.config().getInt("titles.response.fadein");
        int stay = this.config().getInt("titles.response.stay");
        int fadeOut = this.config().getInt("titles.response.fadeout");
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public boolean handleReceiverInput(Player sender, String input, MailCreationSession session) {
        if (input.equalsIgnoreCase(sender.getName())) {
            sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.self-mail")));
            return false;
        }
        if (this.isBulkTarget(input)) {
            if (!sender.hasPermission(this.config().getString("settings.admin-permission"))) {
                sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.no-permission")));
                return false;
            }
            session.setReceiver(input);
            return true;
        }
        int currentMails = this.plugin.getMailRepository().countActiveMailFor(input);
        if (currentMails >= this.config().getInt("settings.max-mails-per-player")) {
            sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.mailbox-full")));
            return false;
        }
        session.setReceiver(input);
        return true;
    }

    public boolean handleCommandInput(Player player, String command, MailCreationSession session) {
        ArrayList<String> commands = new ArrayList<String>(session.getCommands());
        commands.add(command);
        session.setCommands(commands);
        return true;
    }

    public boolean handleCommandItemMaterialInput(Player player, String input, MailCreationSession session) {
        CommandItem.Builder draft = this.ensureCommandItemDraft(session);
        if (input == null || input.trim().isEmpty()) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.invalid-material")));
            return false;
        }
        String trimmed = input.trim();
        Material material = Material.matchMaterial((String)trimmed, (boolean)false);
        if (material == null) {
            String upper = trimmed.toUpperCase(Locale.ROOT);
            material = Material.matchMaterial((String)upper, (boolean)false);
        }
        if (material == null && !trimmed.contains(":")) {
            try {
                material = Material.valueOf((String)trimmed.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException upper) {
                // empty catch block
            }
        }
        if (material == null) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.invalid-material")));
            return false;
        }
        draft.material(material.name());
        String materialTemplate = this.config().getString("messages.command-item-material-set", "&a\u2714 Material set to %material%");
        player.sendMessage(this.plugin.colorize(this.prefix() + this.plugin.applyPlaceholderVariants(materialTemplate, "material", material.name())));
        return true;
    }

    public boolean handleCommandItemNameInput(Player player, String input, MailCreationSession session) {
        CommandItem.Builder draft = this.ensureCommandItemDraft(session);
        if (input == null || input.trim().isEmpty()) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-name-failed", "&c\u2716 Name update failed.")));
            return false;
        }
        draft.displayName(input);
        player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-name-set", "&a\u2714 Name updated.")));
        return true;
    }

    public boolean handleCommandItemLoreInput(Player player, String input, MailCreationSession session) {
        String trimmed;
        CommandItem.Builder draft = this.ensureCommandItemDraft(session);
        String string = trimmed = input == null ? "" : input.trim();
        if (trimmed.isEmpty()) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-lore-failed", "&c\u2716 Lore update failed")));
            return false;
        }
        draft.addLoreLine(input);
        player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-lore-added", "&a\u2714 Added lore line.")));
        return true;
    }

    public boolean handleCommandItemCommandInput(Player player, String input, MailCreationSession session) {
        CommandItem.Builder draft = this.ensureCommandItemDraft(session);
        if (input == null || input.trim().isEmpty()) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-command-failed", "&c\u2716 Command update failed")));
            return false;
        }
        String trimmed = input.startsWith("/") ? input.substring(1) : input;
        draft.addCommand(trimmed);
        player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-command-added", "&a\u2714 Added command.")));
        return true;
    }

    public boolean handleCommandItemCustomModelInput(Player player, String input, MailCreationSession session) {
        CommandItem.Builder draft = this.ensureCommandItemDraft(session);
        if (input == null) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-model-invalid", "&c\u2716 Invalid custom model data.")));
            return false;
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty() || trimmed.equalsIgnoreCase("clear") || trimmed.equalsIgnoreCase("none") || trimmed.equalsIgnoreCase("reset")) {
            draft.customModelData(null);
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-model-cleared", "&a\u2714 Custom model data cleared.")));
            return true;
        }
        try {
            int value = Integer.parseInt(trimmed);
            if (value < 0) {
                throw new NumberFormatException("negative");
            }
            draft.customModelData(value);
            String template = this.config().getString("messages.command-item-model-set", "&a\u2714 Custom model data updated.");
            String formatted = this.plugin.applyPlaceholderVariants(template, "value", String.valueOf(value));
            player.sendMessage(this.plugin.colorize(this.prefix() + formatted));
            return true;
        }
        catch (NumberFormatException ex) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-model-invalid", "&c\u2716 Invalid custom model data.")));
            return false;
        }
    }

    public boolean finalizeCommandItem(Player player, MailCreationSession session) {
        CommandItem.Builder draft = session.getCommandItemDraft();
        if (draft == null) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-no-draft", "&c\u2716 Nothing to save.")));
            return false;
        }
        if (draft.commands().isEmpty()) {
            player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-requires-command", "&c\u2716 Add at least one command.")));
            return false;
        }
        CommandItem built = draft.build();
        ArrayList<CommandItem> items = new ArrayList<CommandItem>(session.getCommandItems());
        Integer editIndex = session.getCommandItemEditIndex();
        if (editIndex != null && editIndex >= 0 && editIndex < items.size()) {
            items.set(editIndex, built);
        } else {
            items.add(built);
        }
        session.setCommandItems(items);
        session.setCommandItemDraft(null);
        session.setCommandItemEditIndex(null);
        player.sendMessage(this.plugin.colorize(this.prefix() + this.config().getString("messages.command-item-saved", "&a\u2714 Command item saved!")));
        return true;
    }

    public void cancelCommandItemEdit(MailCreationSession session) {
        session.setCommandItemDraft(null);
        session.setCommandItemEditIndex(null);
    }

    public boolean handleDateInput(Player player, String input, MailCreationSession session, boolean isSchedule) {
        try {
            String[] parts = input.split(":");
            if (parts.length != 5) {
                throw new IllegalArgumentException();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]) - 1, Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), 0);
            long timestamp = calendar.getTimeInMillis();
            if (isSchedule) {
                session.setScheduleDate(timestamp);
                String template = this.config().getString("messages.schedule-set");
                String formatted = this.plugin.applyPlaceholderVariants(template, "date", calendar.getTime().toString());
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + formatted));
            } else {
                session.setExpireDate(timestamp);
                String template = this.config().getString("messages.expire-set");
                String formatted = this.plugin.applyPlaceholderVariants(template, "date", calendar.getTime().toString());
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + formatted));
            }
            return true;
        }
        catch (Exception e) {
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.invalid-date-format")));
            return false;
        }
    }

    private boolean isBulkTarget(String input) {
        return input.equalsIgnoreCase("all") || input.equalsIgnoreCase("allonline") || input.contains(";");
    }

    public void reopenCreationAsync(Player player) {
        if (player == null) {
            return;
        }
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCreateMailGUI(player));
    }

    public void reopenCommandItemCreatorAsync(Player player) {
        if (player == null) {
            return;
        }
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCommandItemCreator(player));
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    private CommandItem.Builder ensureCommandItemDraft(MailCreationSession session) {
        CommandItem.Builder draft = session.getCommandItemDraft();
        if (draft == null) {
            draft = new CommandItem.Builder();
            session.setCommandItemDraft(draft);
        }
        return draft;
    }

    private String prefix() {
        return this.config().getString("messages.prefix", "");
    }
}

