/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class ItemSerialization {
    private ItemSerialization() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeItem(ItemStack item) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item);
                dataOutput.flush();
                string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Error serializing item: " + e.getMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack deserializeItem(String data) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            ItemStack itemStack;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStack = (ItemStack)dataInput.readObject();
            }
            return itemStack;
        }
        catch (IOException | ClassNotFoundException e) {
            Bukkit.getLogger().severe("Error deserializing item: " + e.getMessage());
            return null;
        }
    }

    public static List<String> serializeItems(List<ItemStack> items) {
        ArrayList<String> serialized = new ArrayList<String>();
        for (ItemStack item : items) {
            serialized.add(ItemSerialization.serializeItem(item));
        }
        return serialized;
    }

    public static List<ItemStack> deserializeItems(List<String> data) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String value : data) {
            ItemStack item = ItemSerialization.deserializeItem(value);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }
}

