/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.config;

import com.yusaki.lammailbox.LamMailBox;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.yusaki.lib.config.ConfigMigration;
import org.yusaki.lib.config.ConfigUpdateOptions;
import org.yusaki.lib.config.ConfigUpdateService;

public class MailBoxConfigUpdater {
    private final LamMailBox plugin;
    private static final double CURRENT_CONFIG_VERSION = 1.0;

    public MailBoxConfigUpdater(LamMailBox plugin) {
        this.plugin = plugin;
    }

    public void updateConfigs() {
        this.updateMainConfig();
        this.updateDatabaseConfig();
    }

    private void updateMainConfig() {
        ConfigUpdateOptions options = ConfigUpdateOptions.builder().fileName("config.yml").resourcePath("config.yml").versionPath("version").backupEnabled(true).preserveExistingValues(true).reorderToTemplate(true).skipMergeIfVersionMatches(true).reloadAction(this::reloadMainConfig).addMigration(this.createVersionMigration()).build();
        ConfigUpdateService.update((JavaPlugin)this.plugin, (ConfigUpdateOptions)options);
    }

    private void updateDatabaseConfig() {
        ConfigUpdateOptions options = ConfigUpdateOptions.builder().fileName("database.yml").resourcePath("database.yml").backupEnabled(true).preserveExistingValues(true).reorderToTemplate(false).skipMergeIfVersionMatches(false).build();
        ConfigUpdateService.update((JavaPlugin)this.plugin, (ConfigUpdateOptions)options);
    }

    private ConfigMigration createVersionMigration() {
        return ConfigMigration.guarded((double)1.0, config -> !config.contains("version") || config.getDouble("version", 0.0) < 1.0, this::migrateToCurrentConfigVersion, (String)"Update config schema to version 1.0");
    }

    private void migrateToCurrentConfigVersion(FileConfiguration config) {
        this.plugin.getLogger().info("Migrating config schema to version 1.0...");
        config.set("version", (Object)1.0);
        this.plugin.getLogger().info("Config schema migration to version 1.0 completed.");
    }

    private void reloadMainConfig(File configFile) {
        this.plugin.reloadConfig();
        this.plugin.getLogger().info("Main configuration reloaded after update.");
    }
}

