/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.service;

import com.yusaki.lammailbox.lib.folialib.FoliaLib;
import com.yusaki.lammailbox.repository.MailRepository;
import com.yusaki.lammailbox.service.MailDelivery;
import com.yusaki.lammailbox.service.MailService;
import com.yusaki.lammailbox.session.MailCreationSession;
import com.yusaki.lammailbox.util.ItemSerialization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class DefaultMailService
implements MailService {
    private final JavaPlugin plugin;
    private final MailRepository repository;
    private final FoliaLib foliaLib;

    public DefaultMailService(JavaPlugin plugin, MailRepository repository, FoliaLib foliaLib) {
        this.plugin = plugin;
        this.repository = repository;
        this.foliaLib = foliaLib;
    }

    @Override
    public MailDelivery sendMail(Player sender, MailCreationSession session) {
        this.validateSession(session);
        boolean isAdminMail = sender.hasPermission(this.config().getString("settings.admin-permission"));
        return this.persistMail(sender.getName(), session, isAdminMail, session.getItems());
    }

    @Override
    public MailDelivery sendConsoleMail(CommandSender sender, MailCreationSession session) {
        this.validateSession(session);
        return this.persistMail(sender.getName(), session, true, Collections.emptyList());
    }

    @Override
    public boolean deleteMail(String mailId) {
        this.repository.deleteMail(mailId);
        this.saveAsync();
        return true;
    }

    @Override
    public boolean claimMail(Player player, String mailId) {
        Optional<Map<String, Object>> mailOpt = this.repository.findMail(mailId);
        if (mailOpt.isEmpty()) {
            return false;
        }
        Map<String, Object> mail = mailOpt.get();
        Object receiverObj = mail.get("receiver");
        if (!(receiverObj instanceof String)) {
            return false;
        }
        String receiver = (String)receiverObj;
        boolean changed = false;
        if ("all".equalsIgnoreCase(receiver)) {
            ArrayList<String> claimed = new ArrayList<String>();
            Object claimedObj = mail.get("claimed-players");
            if (claimedObj instanceof List) {
                for (Object value : (List)claimedObj) {
                    if (value == null) continue;
                    claimed.add(value.toString());
                }
            }
            if (!claimed.contains(player.getName())) {
                claimed.add(player.getName());
                this.repository.saveMail(mailId, Map.of("claimed-players", claimed));
                changed = true;
            }
        } else if (receiver.contains(";")) {
            ArrayList<String> receivers = new ArrayList<String>(Arrays.asList(receiver.split(";")));
            if (receivers.remove(player.getName())) {
                if (receivers.isEmpty()) {
                    this.repository.deleteMail(mailId);
                } else {
                    this.repository.saveMail(mailId, Map.of("receiver", String.join((CharSequence)";", receivers)));
                }
                changed = true;
            }
        } else if (receiver.equalsIgnoreCase(player.getName())) {
            this.repository.deleteMail(mailId);
            changed = true;
        }
        if (changed) {
            this.saveAsync();
        }
        return changed;
    }

    @Override
    public List<MailDelivery> schedulePendingMails() {
        long now = System.currentTimeMillis();
        ArrayList<MailDelivery> deliveries = new ArrayList<MailDelivery>();
        for (String mailId : this.repository.listMailIds()) {
            Map<String, Object> mail = this.repository.loadMail(mailId);
            Long scheduleDate = this.getLong(mail.get("schedule-date"));
            if (scheduleDate == null || scheduleDate > now) continue;
            String receiver = (String)mail.get("receiver");
            String sender = (String)mail.get("sender");
            this.repository.saveMail(mailId, Map.of("schedule-date", null, "active", true));
            deliveries.add(new MailDelivery(mailId, receiver, sender, true));
        }
        if (!deliveries.isEmpty()) {
            this.saveAsync();
        }
        return deliveries;
    }

    @Override
    public int removeExpiredMails() {
        long now = System.currentTimeMillis();
        int removed = 0;
        for (String mailId : this.repository.listMailIds()) {
            Map<String, Object> mail = this.repository.loadMail(mailId);
            Long expireDate = this.getLong(mail.get("expire-date"));
            if (expireDate == null || expireDate > now) continue;
            this.repository.deleteMail(mailId);
            ++removed;
        }
        if (removed > 0) {
            this.saveAsync();
        }
        return removed;
    }

    private MailDelivery persistMail(String senderName, MailCreationSession session, boolean isAdminMail, List<ItemStack> items) {
        String normalizedReceiver = this.normalizeReceiver(session.getReceiver());
        String mailId = UUID.randomUUID().toString();
        long now = System.currentTimeMillis();
        Long scheduleDate = session.getScheduleDate();
        Long expireDate = session.getExpireDate();
        if (expireDate == null) {
            int expireAfterDays = this.config().getInt("settings.admin-mail-expire-days");
            expireDate = now + (long)expireAfterDays * 86400000L;
        }
        boolean active = scheduleDate == null || scheduleDate <= now;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sender", senderName);
        data.put("receiver", normalizedReceiver);
        data.put("message", session.getMessage());
        data.put("sent-date", now);
        data.put("schedule-date", scheduleDate);
        data.put("expire-date", expireDate);
        data.put("active", active);
        data.put("is-admin-mail", isAdminMail);
        data.put("claimed-players", new ArrayList());
        if (session.getCommandBlock() != null) {
            data.put("command-block", ItemSerialization.serializeItem(session.getCommandBlock()));
            data.put("commands", new ArrayList<String>(session.getCommands()));
        } else {
            data.put("command-block", null);
            data.put("commands", new ArrayList());
        }
        this.repository.saveMail(mailId, data);
        this.repository.saveMailItems(mailId, items);
        this.saveAsync();
        return new MailDelivery(mailId, normalizedReceiver, senderName, active);
    }

    private String normalizeReceiver(String receiverSpec) {
        if (receiverSpec == null) {
            return "";
        }
        if (receiverSpec.equalsIgnoreCase("allonline")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.joining(";"));
        }
        return receiverSpec;
    }

    private void validateSession(MailCreationSession session) {
        if (session == null || !session.isComplete()) {
            throw new IllegalArgumentException("Mail session is incomplete");
        }
    }

    private Long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    private void saveAsync() {
        this.foliaLib.getScheduler().runAsync(task -> this.repository.save());
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }
}

