/*
 * Decompiled with CFR 0.152.
 */
package com.yusaki.lammailbox.session;

import com.yusaki.lammailbox.LamMailBox;
import com.yusaki.lammailbox.session.MailCreationSession;
import java.util.ArrayList;
import java.util.Calendar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class MailCreationController {
    private final LamMailBox plugin;

    public MailCreationController(LamMailBox plugin) {
        this.plugin = plugin;
    }

    public void showInputTitle(Player player, String type) {
        String path = "titles.input." + type;
        String title = this.plugin.colorize(this.config().getString(path + ".title"));
        String subtitle = this.plugin.colorize(this.config().getString(path + ".subtitle"));
        int fadeIn = this.config().getInt("titles.input.fadein");
        int stay = this.config().getInt("titles.input.stay");
        int fadeOut = this.config().getInt("titles.input.fadeout");
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public void showResponseTitle(Player player, boolean success, String customSubtitle) {
        String type = success ? "success" : "error";
        String titlePath = "titles.response." + type;
        String title = this.plugin.colorize(this.config().getString(titlePath + ".title"));
        String subtitle = customSubtitle != null ? this.plugin.colorize(customSubtitle) : this.plugin.colorize(this.config().getString(titlePath + ".subtitle"));
        int fadeIn = this.config().getInt("titles.response.fadein");
        int stay = this.config().getInt("titles.response.stay");
        int fadeOut = this.config().getInt("titles.response.fadeout");
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    public boolean handleReceiverInput(Player sender, String input, MailCreationSession session) {
        if (input.equalsIgnoreCase(sender.getName())) {
            sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.self-mail")));
            return false;
        }
        if (this.isBulkTarget(input)) {
            if (!sender.hasPermission(this.config().getString("settings.admin-permission"))) {
                sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.no-permission")));
                return false;
            }
            session.setReceiver(input);
            return true;
        }
        int currentMails = this.database().getInt("player-mail-counts." + input, 0);
        if (currentMails >= this.config().getInt("settings.max-mails-per-player")) {
            sender.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.mailbox-full")));
            return false;
        }
        session.setReceiver(input);
        return true;
    }

    public boolean handleCommandInput(Player player, String command, MailCreationSession session) {
        ArrayList<String> commands = new ArrayList<String>(session.getCommands());
        commands.add(command);
        session.setCommands(commands);
        return true;
    }

    public boolean handleDateInput(Player player, String input, MailCreationSession session, boolean isSchedule) {
        try {
            String[] parts = input.split(":");
            if (parts.length != 5) {
                throw new IllegalArgumentException();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]) - 1, Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]), 0);
            long timestamp = calendar.getTimeInMillis();
            if (isSchedule) {
                session.setScheduleDate(timestamp);
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.schedule-set").replace("%date%", calendar.getTime().toString())));
            } else {
                session.setExpireDate(timestamp);
                player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.expire-set").replace("%date%", calendar.getTime().toString())));
            }
            return true;
        }
        catch (Exception e) {
            player.sendMessage(this.plugin.colorize(this.config().getString("messages.prefix") + this.config().getString("messages.invalid-date-format")));
            return false;
        }
    }

    private boolean isBulkTarget(String input) {
        return input.equalsIgnoreCase("all") || input.equalsIgnoreCase("allonline") || input.contains(";");
    }

    private FileConfiguration config() {
        return this.plugin.getConfig();
    }

    public void reopenCreationAsync(Player player) {
        if (player == null) {
            return;
        }
        this.plugin.getFoliaLib().getScheduler().runNextTick(task -> this.plugin.openCreateMailGUI(player));
    }

    private FileConfiguration database() {
        return this.plugin.getMailRepository().getBackingConfiguration();
    }
}

