/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import win.demistorm.ConfigHelper;
import win.demistorm.WeaponEffectType;
import win.demistorm.client.config.ClientOnlyConfig;

public final class ConfigScreen {
    private ConfigScreen() {
    }

    public static class SimpleToggleScreen
    extends Screen {
        private final Screen parent;
        private final Minecraft client = Minecraft.getInstance();
        private WeaponEffectType weaponEffectValue;
        private boolean aimAssistValue;
        private boolean bloodEffectValue;

        protected SimpleToggleScreen(Screen parent) {
            super((Component)Component.literal((String)"VR Throwing Extensions Configuration"));
            this.weaponEffectValue = ConfigHelper.CLIENT.weaponEffect;
            this.aimAssistValue = ConfigHelper.CLIENT.aimAssist;
            this.bloodEffectValue = ClientOnlyConfig.ACTIVE.bloodEffect;
            this.parent = parent;
        }

        public static SimpleToggleScreen create(Screen parent) {
            return new SimpleToggleScreen(parent);
        }

        protected void init() {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Weapon Effect: " + this.weaponEffectValue.name())), btn -> {
                this.weaponEffectValue = switch (this.weaponEffectValue) {
                    default -> throw new MatchException(null, null);
                    case WeaponEffectType.OFF -> WeaponEffectType.BOOMERANG;
                    case WeaponEffectType.BOOMERANG -> WeaponEffectType.EMBED;
                    case WeaponEffectType.EMBED -> WeaponEffectType.OFF;
                };
                btn.setMessage((Component)Component.literal((String)("Weapon Effect: " + this.weaponEffectValue.name())));
            }).bounds(this.width / 2 - 80, this.height / 4 + 24, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"OFF: Weapons drop normally\nBOOMERANG: Weapons return after hitting (catch them!)\nEMBED: Weapons stick in enemies and cause bleeding"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Aim Assist: " + (this.aimAssistValue ? "ON" : "OFF"))), btn -> {
                this.aimAssistValue = !this.aimAssistValue;
                btn.setMessage((Component)Component.literal((String)("Aim Assist: " + (this.aimAssistValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 4 + 54, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Helps aim at nearby targets"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Blood Effects: " + (this.bloodEffectValue ? "ON" : "OFF"))), btn -> {
                this.bloodEffectValue = !this.bloodEffectValue;
                btn.setMessage((Component)Component.literal((String)("Blood Effects: " + (this.bloodEffectValue ? "ON" : "OFF"))));
            }).bounds(this.width / 2 - 80, this.height / 4 + 84, 160, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Show blood particles when weapons hit"))).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
                ConfigHelper.CLIENT.weaponEffect = this.weaponEffectValue;
                ConfigHelper.CLIENT.aimAssist = this.aimAssistValue;
                ConfigHelper.write(ConfigHelper.CLIENT);
                ClientOnlyConfig.ACTIVE.bloodEffect = this.bloodEffectValue;
                ClientOnlyConfig.write(ClientOnlyConfig.ACTIVE);
                if (this.client.hasSingleplayerServer()) {
                    ConfigHelper.ACTIVE.weaponEffect = ConfigHelper.CLIENT.weaponEffect;
                    ConfigHelper.ACTIVE.aimAssist = ConfigHelper.CLIENT.aimAssist;
                }
                this.client.setScreen(this.parent);
            }).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.render(context, mouseX, mouseY, delta);
            context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        }
    }
}

