/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.forge;

import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import win.demistorm.Platform;
import win.demistorm.forge.PlatformClientImpl;
import win.demistorm.forge.VRThrowingExtensionsForge;

public class PlatformImpl {
    public static boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    public static boolean isForgeLike() {
        return true;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static void registerServerPostTickListener(Consumer<MinecraftServer> listener) {
        TickEvent.ServerTickEvent.Post.BUS.addListener(event -> listener.accept(event.getServer()));
    }

    public static void registerServerPlayerPostTickListener(Consumer<ServerPlayer> listener) {
        TickEvent.ServerTickEvent.Post.BUS.addListener(event -> event.getServer().getPlayerList().getPlayers().forEach(listener));
    }

    public static void registerServerPlayerJoinListener(Consumer<ServerPlayer> listener) {
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerServerPlayerLeaveListener(Consumer<ServerPlayer> listener) {
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                listener.accept(sp);
            }
        });
    }

    public static void registerCommands(Consumer<CommandDispatcher<CommandSourceStack>> listener) {
        RegisterCommandsEvent.BUS.addListener(event -> listener.accept(event.getDispatcher()));
    }

    public static void sendToServer(RegistryFriendlyByteBuf message) {
        FriendlyByteBuf forgeBuf = new FriendlyByteBuf((ByteBuf)message);
        VRThrowingExtensionsForge.NETWORK.send((Object)forgeBuf, PacketDistributor.SERVER.noArg());
    }

    public static void sendToPlayer(ServerPlayer player, RegistryFriendlyByteBuf message) {
        FriendlyByteBuf forgeBuf = new FriendlyByteBuf((ByteBuf)message);
        VRThrowingExtensionsForge.NETWORK.send((Object)forgeBuf, PacketDistributor.PLAYER.with((Object)player));
    }

    public static void registerC2SPacketHandler(ResourceLocation packetId, Consumer<Platform.PacketContext> handler) {
    }

    public static void registerS2CPacketHandler(ResourceLocation packetId, Consumer<Platform.PacketContext> handler) {
    }

    public static void registerEntityType(Object entityType) {
    }

    public static String getMinecraftVersion() {
        Optional container = ModList.get().getModContainerById("minecraft");
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getVersion().toString();
        }
        return "unknown";
    }

    public static String getLoaderName() {
        return "forge";
    }

    public static RegistryAccess getClientRegistryAccess() {
        Minecraft client = Minecraft.getInstance();
        if (client.getConnection() != null) {
            return client.getConnection().registryAccess();
        }
        return null;
    }

    public static void registerClientInputEventHandlers() {
        PlatformClientImpl.register();
    }
}

