/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;

public final class AimHelper {
    private static final double maxAssistDistance = 25.0;
    private static final double assistViewAngle = 35.0;
    private static final double assistStrength = 0.5;
    private static final double maxPredictionTime = 2.5;
    private static final double gravityCalc = 0.06;
    private static final double ticksPerSecond = 20.0;

    public static class_243 applyAimAssist(class_746 player, class_243 origin, class_243 originalVelocity) {
        VRThrowingExtensions.log.debug("[Aim Assist] Checking ACTIVE.aimAssist = {}, CLIENT.aimAssist = {}", (Object)ConfigHelper.ACTIVE.aimAssist, (Object)ConfigHelper.CLIENT.aimAssist);
        if (!ConfigHelper.ACTIVE.aimAssist) {
            VRThrowingExtensions.log.debug("[Aim Assist] Aim assist is DISABLED by server config - returning original velocity");
            return originalVelocity;
        }
        Optional<TargetInfo> bestTarget = AimHelper.findBestTarget(player, origin, originalVelocity);
        if (bestTarget.isEmpty()) {
            VRThrowingExtensions.log.debug("[Aim Assist] No suitable target found");
            return originalVelocity;
        }
        TargetInfo target = bestTarget.get();
        class_243 assistedVelocity = AimHelper.calculateBallisticAssist(origin, originalVelocity, target);
        double adjustment = assistedVelocity.method_1020(originalVelocity).method_1033();
        VRThrowingExtensions.log.debug("[Aim Assist] Target: {}, distance: {}, time: {}s, adjustment: {}", new Object[]{target.entity.method_5477().getString(), target.distance, target.interceptTime, adjustment});
        return assistedVelocity;
    }

    private static Optional<TargetInfo> findBestTarget(class_746 player, class_243 origin, class_243 velocity) {
        class_243 throwDirection = velocity.method_1029();
        double throwSpeed = velocity.method_1033();
        class_243 min = origin.method_1023(25.0, 25.0, 25.0);
        class_243 max = origin.method_1031(25.0, 25.0, 25.0);
        class_238 searchBox = new class_238(min, max);
        List candidates = player.method_37908().method_8390(class_1309.class, searchBox, entity -> entity != player && entity.method_5805() && !entity.method_7325());
        TargetInfo bestTarget = null;
        double bestScore = 0.0;
        for (class_1309 entity2 : candidates) {
            double score;
            TargetInfo targetInfo = AimHelper.evaluateTarget(entity2, origin, throwDirection, throwSpeed);
            if (targetInfo == null || !((score = AimHelper.calculateTargetScore(targetInfo)) > bestScore)) continue;
            bestScore = score;
            bestTarget = targetInfo;
        }
        return Optional.ofNullable(bestTarget);
    }

    private static TargetInfo evaluateTarget(class_1309 entity, class_243 origin, class_243 throwDirection, double throwSpeed) {
        class_243 targetPos = entity.method_19538().method_1031(0.0, (double)entity.method_5751() / 1.5, 0.0);
        class_243 toTarget = targetPos.method_1020(origin);
        double distance = toTarget.method_1033();
        if (distance > 25.0) {
            return null;
        }
        double angle = Math.toDegrees(Math.acos(class_3532.method_15350((double)throwDirection.method_1026(toTarget.method_1029()), (double)-1.0, (double)1.0)));
        if (angle > 35.0) {
            return null;
        }
        class_243 entityVelocity = entity.method_18798();
        double interceptTime = AimHelper.calculateOptimalInterceptTime(origin, targetPos, entityVelocity, throwSpeed);
        if (interceptTime < 0.0 || interceptTime > 2.5) {
            return null;
        }
        double tTicks = interceptTime * 20.0;
        class_243 predictedPos = targetPos.method_1019(entityVelocity.method_1021(tTicks));
        double trajectoryConfidence = AimHelper.calculateTrajectoryPossibility(origin, predictedPos, throwSpeed, interceptTime);
        if (trajectoryConfidence < 0.3) {
            return null;
        }
        return new TargetInfo(entity, targetPos, predictedPos, distance, angle, trajectoryConfidence, interceptTime);
    }

    private static double calculateOptimalInterceptTime(class_243 origin, class_243 targetPos, class_243 targetVel, double throwSpeed) {
        double minTicks = 1.0;
        double maxTicks = 50.0;
        if (throwSpeed <= 1.0E-6) {
            return -1.0;
        }
        DoubleUnaryOperator speedErrorAtTicks = tTicks -> {
            if (tTicks <= 1.0E-6) {
                return Double.POSITIVE_INFINITY;
            }
            class_243 predicted = targetPos.method_1019(targetVel.method_1021(tTicks));
            double tSec = tTicks / 20.0;
            class_243 requiredVel = AimHelper.calculateRequiredBallisticVelocity(origin, predicted, tSec);
            return requiredVel.method_1033() - throwSpeed;
        };
        class_243 r0 = targetPos.method_1020(origin);
        double a = targetVel.method_1027() - throwSpeed * throwSpeed;
        double b = 2.0 * r0.method_1026(targetVel);
        double c = r0.method_1027();
        double tGuess = -1.0;
        double disc = b * b - 4.0 * a * c;
        if (Math.abs(a) < 1.0E-8) {
            double t;
            if (Math.abs(b) > 1.0E-8 && (t = -c / b) > 0.0) {
                tGuess = t;
            }
        } else if (disc >= 0.0) {
            double sqrt = Math.sqrt(disc);
            double t1 = (-b - sqrt) / (2.0 * a);
            double t2 = (-b + sqrt) / (2.0 * a);
            double best = Double.POSITIVE_INFINITY;
            if (t1 > 0.0) {
                best = Math.min(best, t1);
            }
            if (t2 > 0.0) {
                best = Math.min(best, t2);
            }
            if (Double.isFinite(best)) {
                tGuess = best;
            }
        }
        if (!(tGuess > 0.0)) {
            double linearDistance = r0.method_1033();
            tGuess = Math.max(1.0, Math.min(50.0, linearDistance / Math.max(1.0E-6, throwSpeed)));
        } else {
            tGuess = class_3532.method_15350((double)tGuess, (double)1.0, (double)50.0);
        }
        int steps = 12;
        double prevT = 1.0;
        double prevErr = speedErrorAtTicks.applyAsDouble(prevT);
        double brLo = Double.NaN;
        double brHi = Double.NaN;
        double errLo = 0.0;
        for (int i = 1; i <= 12; ++i) {
            double alpha = (double)i / 12.0;
            double t = class_3532.method_16436((double)alpha, (double)1.0, (double)50.0);
            t = class_3532.method_16436((double)0.25, (double)t, (double)class_3532.method_15363((float)((float)tGuess), (float)1.0f, (float)50.0f));
            double err = speedErrorAtTicks.applyAsDouble(t);
            if (prevErr == 0.0 || err == 0.0 || prevErr < 0.0 && err > 0.0 || prevErr > 0.0 && err < 0.0) {
                brLo = Math.min(prevT, t);
                brHi = Math.max(prevT, t);
                errLo = brLo == prevT ? prevErr : err;
                break;
            }
            prevT = t;
            prevErr = err;
        }
        double absTol = Math.max(0.01, 0.03 * throwSpeed);
        if (Double.isFinite(brLo) && Double.isFinite(brHi)) {
            double lo = brLo;
            double hi = brHi;
            double fLo = errLo;
            for (int iter = 0; iter < 18; ++iter) {
                double mid = 0.5 * (lo + hi);
                double fMid = speedErrorAtTicks.applyAsDouble(mid);
                if (Math.abs(fMid) <= absTol) {
                    double solvedTicks = mid;
                    double errPct = Math.abs(fMid) / Math.max(1.0E-6, throwSpeed);
                    VRThrowingExtensions.log.debug("[Aim Assist] Intercept refined: T={} ticks (~{}s), err={} ({}%)", new Object[]{String.format("%.2f", solvedTicks), String.format("%.2f", solvedTicks / 20.0), String.format("%.4f", fMid), errPct * 100.0});
                    return solvedTicks / 20.0;
                }
                if (fLo < 0.0 && fMid > 0.0 || fLo > 0.0 && fMid < 0.0) {
                    hi = mid;
                    continue;
                }
                lo = mid;
                fLo = fMid;
            }
            double solvedTicks = 0.5 * (lo + hi);
            return solvedTicks / 20.0;
        }
        double[] testTimes = new double[]{class_3532.method_15350((double)(tGuess * 0.5), (double)1.0, (double)50.0), class_3532.method_15350((double)(tGuess * 0.75), (double)1.0, (double)50.0), class_3532.method_15350((double)tGuess, (double)1.0, (double)50.0), class_3532.method_15350((double)(tGuess * 1.25), (double)1.0, (double)50.0), class_3532.method_15350((double)(tGuess * 1.5), (double)1.0, (double)50.0)};
        double bestT = -1.0;
        double bestAbsErr = Double.MAX_VALUE;
        for (double t : testTimes) {
            double e = speedErrorAtTicks.applyAsDouble(t);
            double ae = Math.abs(e);
            if (!(ae < bestAbsErr)) continue;
            bestAbsErr = ae;
            bestT = t;
        }
        double relErr = bestAbsErr / Math.max(1.0E-6, throwSpeed);
        if (relErr <= 0.15) {
            VRThrowingExtensions.log.debug("[Aim Assist] Using close fallback time: T={} ticks (~{}s), relErr={}%", new Object[]{String.format("%.2f", bestT), String.format("%.2f", bestT / 20.0), relErr * 100.0});
            return bestT / 20.0;
        }
        VRThrowingExtensions.log.debug("[Aim Assist] No valid intercept (bestRelErr={}%)", (Object)String.format("%.1f", relErr * 100.0));
        return -1.0;
    }

    private static class_243 calculateRequiredBallisticVelocity(class_243 origin, class_243 target, double flightTimeSeconds) {
        class_243 displacement = target.method_1020(origin);
        double flightTimeTicks = flightTimeSeconds * 20.0;
        double vx = displacement.field_1352 / flightTimeTicks;
        double vz = displacement.field_1350 / flightTimeTicks;
        double vy = (displacement.field_1351 + 0.03 * flightTimeTicks * flightTimeTicks) / flightTimeTicks;
        return new class_243(vx, vy, vz);
    }

    private static double calculateTrajectoryPossibility(class_243 origin, class_243 target, double throwSpeed, double timeSeconds) {
        class_243 requiredVel = AimHelper.calculateRequiredBallisticVelocity(origin, target, timeSeconds);
        double requiredSpeed = requiredVel.method_1033();
        return Math.min(throwSpeed, requiredSpeed) / Math.max(throwSpeed, requiredSpeed);
    }

    private static class_243 calculateBallisticAssist(class_243 origin, class_243 originalVelocity, TargetInfo target) {
        class_243 idealVelocity = AimHelper.calculateRequiredBallisticVelocity(origin, target.predictedPos, target.interceptTime);
        double originalSpeed = originalVelocity.method_1033();
        double idealSpeed = idealVelocity.method_1033();
        if (idealSpeed > 1.0E-6) {
            idealVelocity = idealVelocity.method_1021(originalSpeed / idealSpeed);
        }
        if (idealVelocity.method_1033() > originalSpeed * 1.6) {
            idealVelocity = idealVelocity.method_1029().method_1021(originalSpeed * 1.6);
        }
        double effectiveStrength = 0.5 * target.confidence;
        return AimHelper.blendVelocities(originalVelocity, idealVelocity, effectiveStrength);
    }

    private static class_243 blendVelocities(class_243 current, class_243 target, double strength) {
        return current.method_1021(1.0 - strength).method_1019(target.method_1021(strength));
    }

    private static double calculateTargetScore(TargetInfo target) {
        double baseScore = target.confidence;
        double distanceScore = 1.0 - target.distance / 25.0;
        double angleScore = 1.0 - target.angle / 35.0;
        double typeMultiplier = 0.7;
        if (target.entity instanceof class_1588) {
            typeMultiplier = 1.0;
        }
        if (target.entity instanceof class_1657) {
            typeMultiplier = 0.6;
        }
        return (baseScore + distanceScore + angleScore) / 3.0 * typeMultiplier;
    }

    private AimHelper() {
    }

    private record TargetInfo(class_1309 entity, class_243 currentPos, class_243 predictedPos, double distance, double angle, double confidence, double interceptTime) {
    }
}

