/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends class_897<ThrownProjectileEntity> {
    private final class_918 itemRenderer = class_310.method_1551().method_1480();
    private final float scale;

    public ThrownItemRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.scale = 0.7f;
        this.field_4672 = 0.0f;
    }

    public void render(ThrownProjectileEntity entity, float entityYaw, float tickDelta, class_4587 matrices, class_4597 vcp, int light) {
        matrices.method_22903();
        class_1799 itemStack = entity.method_7495();
        class_243 velocity = entity.method_18798();
        float age = (float)entity.field_6012 + tickDelta;
        float handRollDeg = entity.getHandRoll();
        boolean isCatching = entity.isCatching();
        boolean isBounceActive = entity.isBounceActive();
        boolean isEmbedded = entity.isEmbedded();
        if (isEmbedded) {
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f - entity.getEmbedYaw()));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-entity.getEmbedPitch()));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(entity.getEmbedTilt()));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(entity.getEmbedRoll()));
            matrices.method_22905(this.scale, this.scale, this.scale);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            try {
                this.itemRenderer.method_23178(itemStack, class_811.field_4322, light, class_4608.field_21444, matrices, vcp, (class_1937)class_310.method_1551().field_1687, 0);
            }
            catch (Exception e) {
                System.err.println("VR Throwing Extensions: Could not render embedded item: " + e.getMessage());
            }
            matrices.method_22909();
            super.method_3936((class_1297)entity, entityYaw, tickDelta, matrices, vcp, light);
            return;
        }
        if (velocity.method_1033() > 0.001) {
            float yaw = (float)(class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) * 180.0 / Math.PI);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f - yaw));
            float hor = class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)));
            float pitch = (float)(class_3532.method_15349((double)velocity.field_1351, (double)hor) * 180.0 / Math.PI);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-pitch));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(-handRollDeg));
        }
        if (isCatching) {
            float smoothSpin = age * 5.0f % 360.0f;
            matrices.method_22907(class_7833.field_40714.rotationDegrees(smoothSpin));
            float bobOffset = class_3532.method_15374((float)(age * 0.5f)) * 0.05f;
            matrices.method_46416(0.0f, bobOffset, 0.0f);
        } else if (isBounceActive) {
            float returnSpin = age * 8.0f % 360.0f;
            matrices.method_22907(class_7833.field_40714.rotationDegrees(returnSpin));
            float wobble = class_3532.method_15374((float)(age * 0.35f)) * 3.0f;
            matrices.method_22907(class_7833.field_40716.rotationDegrees(wobble));
            float pulseScale = 1.0f + class_3532.method_15374((float)(age * 0.4f)) * 0.05f;
            matrices.method_22905(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = age * spinSpeed % 360.0f;
            matrices.method_22907(class_7833.field_40714.rotationDegrees(spin));
        }
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22905(this.scale, this.scale, this.scale);
        try {
            this.itemRenderer.method_23178(itemStack, class_811.field_4322, light, class_4608.field_21444, matrices, vcp, (class_1937)class_310.method_1551().field_1687, 0);
        }
        catch (Exception e) {
            System.err.println("VR Throwing Extensions: Could not render thrown item: " + e.getMessage());
        }
        matrices.method_22909();
        super.method_3936((class_1297)entity, entityYaw, tickDelta, matrices, vcp, light);
    }

    @NotNull
    public class_2960 getTextureLocation(ThrownProjectileEntity entity) {
        return class_1059.field_5275;
    }
}

