/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;

public final class BoomerangEffect {
    public static final double baseReturnSpeed = 1.0;
    public static final double closeDistance = 3.0;
    public static final double farDistance = 25.0;
    public static final double closeSpeedMultiplier = 0.3;
    public static final double farSpeedMultiplier = 2.0;
    public static final double scalingCurve = 1.2;
    public static final double arcGain = 0.6;
    public static final double arcMin = 0.8;
    public static final double arcMax = 6.0;
    public static final double arcDecayPerStep = 0.8;
    public static final double maxTurnRateNear = Math.toRadians(30.0);
    public static final double maxTurnRateFar = Math.toRadians(55.0);
    public static final double lateralStartBoost = 0.35;
    public static final double dampFactor = 0.95;
    public static final double maxOverTarget = 1.6;
    public static final double minUnderTarget = 0.45;
    public static final Set<class_1792> bounceTools = new HashSet<class_1792>();

    public static boolean canBounce(class_1792 i) {
        return bounceTools.contains(i);
    }

    public static void startBounce(ThrownProjectileEntity proj) {
        proj.hasBounced = true;
        proj.bounceActive = true;
        proj.clearSpawnImmunity();
        class_243 currentPos = proj.method_19538();
        class_243 toOrigin = proj.originalThrowPos.method_1020(currentPos);
        double distanceToOrigin = toOrigin.method_1033();
        if (distanceToOrigin < 0.1) {
            VRThrowingExtensions.log.debug("[Boomerang] Too close to origin, dropping normally");
            proj.bounceActive = false;
            return;
        }
        class_243 dir = toOrigin.method_1029();
        double rollRad = Math.toRadians(proj.getHandRoll());
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 upRolled = BoomerangEffect.rotateAroundAxis(worldUp, dir, rollRad);
        class_243 upProj = BoomerangEffect.projectPerp(upRolled, dir);
        class_243 right = dir.method_1036(upRolled).method_1029();
        double cosR = Math.cos(rollRad);
        double sinR = Math.sin(rollRad);
        class_243 curveDir = upProj.method_1021(cosR).method_1019(right.method_1021(sinR)).method_1029();
        proj.bounceInverse = proj.getHandRoll() < 0.0f;
        class_243 planeNormal = dir.method_1036(curveDir).method_1029();
        if (proj.bounceInverse) {
            planeNormal = planeNormal.method_1021(-1.0);
        }
        double arcMag = class_3532.method_15350((double)(distanceToOrigin * 0.6), (double)0.8, (double)6.0);
        proj.bouncePlaneNormal = planeNormal;
        proj.bounceArcMag = arcMag;
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(distanceToOrigin);
        double bounceSpeed = 1.0 * speedMultiplier;
        class_243 baseVel = dir.method_1021(bounceSpeed);
        class_243 lateralVel = curveDir.method_1021(bounceSpeed * 0.35);
        class_243 finalVel = baseVel.method_1019(lateralVel).method_1031(0.0, 0.02, 0.0);
        proj.method_18799(finalVel);
        proj.method_5875(true);
        if (!proj.method_37908().method_8608()) {
            proj.method_37908().method_8396(null, proj.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.6f, 1.5f);
        }
        VRThrowingExtensions.log.debug("[Boomerang] Projectile {} started return. Dist={}. Roll={}\u00b0, Speed={} (mult={}), ArcMag={}", new Object[]{proj.method_5628(), String.format("%.2f", distanceToOrigin), String.format("%.1f", Float.valueOf(proj.getHandRoll())), String.format("%.3f", bounceSpeed), String.format("%.2f", speedMultiplier), String.format("%.2f", arcMag)});
    }

    public static boolean tickReturn(ThrownProjectileEntity proj) {
        class_243 currentPos = proj.method_19538();
        class_243 toOrigin = proj.originalThrowPos.method_1020(currentPos);
        double distSq = toOrigin.method_1027();
        boolean reachedOrigin = false;
        if (distSq < 0.36) {
            reachedOrigin = true;
            VRThrowingExtensions.log.debug("[Boomerang] Projectile {} reached origin (dist={})", (Object)proj.method_5628(), (Object)String.format("%.3f", Math.sqrt(distSq)));
        } else {
            double dot;
            class_243 currentVel = proj.method_18798();
            if (currentVel.method_1033() > 0.01 && (dot = currentVel.method_1029().method_1026(toOrigin.method_1029())) < -0.8 && distSq < 4.0) {
                reachedOrigin = true;
                VRThrowingExtensions.log.debug("[Boomerang] Projectile {} overshot origin (dist={}, dot={})", new Object[]{proj.method_5628(), String.format("%.3f", Math.sqrt(distSq)), String.format("%.3f", dot)});
            }
        }
        if (reachedOrigin) {
            return true;
        }
        class_243 target = proj.originalThrowPos.method_1019(proj.bounceCurveOffset);
        class_243 toTarget = target.method_1020(currentPos);
        double distance = toTarget.method_1033();
        if (distance < 1.0E-4) {
            return false;
        }
        class_243 wantDir = toTarget.method_1029();
        class_243 currentVel = proj.method_18798();
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(Math.sqrt(distSq));
        double targetSpeed = 1.0 * speedMultiplier;
        double turnRate = class_3532.method_16436((double)class_3532.method_15363((float)((float)(distance / 25.0)), (float)0.0f, (float)1.0f), (double)maxTurnRateNear, (double)maxTurnRateFar);
        class_243 turned = BoomerangEffect.turnTowards(currentVel, wantDir, turnRate);
        class_243 newVel = turned.method_1021(0.95);
        double newSpeed = newVel.method_1033();
        double maxSpeed = targetSpeed * 1.6;
        double minSpeed = targetSpeed * 0.45;
        if (newSpeed > maxSpeed) {
            newVel = newVel.method_1029().method_1021(maxSpeed);
        } else if (newSpeed < minSpeed && newSpeed > 1.0E-4) {
            newVel = newVel.method_1029().method_1021(minSpeed);
        }
        proj.method_18799(newVel);
        double nearFactor = class_3532.method_15350((double)(1.0 - distance / 25.0), (double)0.0, (double)0.8);
        double decay = class_3532.method_16436((double)nearFactor, (double)0.8, (double)0.6000000000000001);
        proj.bounceCurveOffset = proj.bounceCurveOffset.method_1021(decay);
        if (proj.field_6012 % 20 == 0) {
            VRThrowingExtensions.log.debug("[Boomerang] Return: dist={}, speed={}, target={}, arcLen={}", new Object[]{String.format("%.2f", Math.sqrt(distSq)), String.format("%.3f", newVel.method_1033()), String.format("%.3f", targetSpeed), String.format("%.2f", proj.bounceCurveOffset.method_1027() > 0.0 ? Math.sqrt(proj.bounceCurveOffset.method_1027()) : 0.0)});
        }
        return false;
    }

    private static double calculateSpeedMultiplier(double distance) {
        if (distance <= 3.0) {
            return 0.3;
        }
        if (distance >= 25.0) {
            return 2.0;
        }
        double t = (distance - 3.0) / 22.0;
        t = Math.pow(t, 1.2);
        return class_3532.method_16439((float)((float)t), (float)0.3f, (float)2.0f);
    }

    private static class_243 rotateAroundAxis(class_243 v, class_243 axis, double angle) {
        class_243 k = axis.method_1029();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double dot = v.method_1026(k);
        class_243 term1 = v.method_1021(cos);
        class_243 term2 = k.method_1036(v).method_1021(sin);
        class_243 term3 = k.method_1021(dot * (1.0 - cos));
        return term1.method_1019(term2).method_1019(term3);
    }

    private static class_243 projectPerp(class_243 v, class_243 normal) {
        double d = v.method_1026(normal);
        return v.method_1020(normal.method_1021(d)).method_1029();
    }

    private static class_243 turnTowards(class_243 currentVel, class_243 wantDir, double maxAngle) {
        double speed = currentVel.method_1033();
        if (speed < 1.0E-6) {
            return wantDir.method_1021(speed);
        }
        class_243 curDir = currentVel.method_1029();
        double dot = class_3532.method_15350((double)curDir.method_1026(wantDir), (double)-1.0, (double)1.0);
        double angle = Math.acos(dot);
        if (angle <= maxAngle) {
            return wantDir.method_1021(speed);
        }
        class_243 axis = curDir.method_1036(wantDir);
        if (axis.method_1027() < 1.0E-9) {
            class_243 turnDir = curDir.method_1021(0.999).method_1019(wantDir.method_1021(0.001)).method_1029();
            return turnDir.method_1021(speed);
        }
        class_243 rotated = BoomerangEffect.rotateAroundAxis(curDir, axis, maxAngle);
        return rotated.method_1029().method_1021(speed);
    }

    private BoomerangEffect() {
    }

    static {
        class_7923.field_41178.method_10220().filter(i -> !class_7923.field_41178.method_10221(i).equals((Object)new class_2960("minecraft", "air"))).forEach(bounceTools::add);
    }
}

