/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.fabric;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.ThrowHelper;
import win.demistorm.client.ThrownItemRenderer;
import win.demistorm.client.VRThrowingExtensionsClient;
import win.demistorm.fabric.BufferPacket;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.NetworkHandlers;

public class PlatformClientImpl
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BufferPacket.ID, (client, handler, buf, responseSender) -> {
            buf.retain();
            client.execute(() -> {
                try {
                    PlatformClientImpl.handleBufferPacket(buf);
                }
                finally {
                    buf.release();
                }
            });
        });
        VRThrowingExtensionsClient.initializeClient();
        PlatformClientImpl.registerClientInputEventHandlers();
        EntityRendererRegistry.register(VRThrowingExtensions.THROWN_ITEM_TYPE, ThrownItemRenderer::new);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ConfigHelper.clientDisconnected();
            VRThrowingExtensions.log.debug("Client disconnected, restored local config");
        });
    }

    private static void handleBufferPacket(class_2540 buffer) {
        int packetId = buffer.readInt();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        switch (packetId) {
            case 4: {
                BloodParticleData bloodData = new BloodParticleData(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
                VRThrowingExtensions.log.debug("[Client] Received blood particle packet ID 4 at ({}, {}, {})", new Object[]{bloodData.posX(), bloodData.posY(), bloodData.posZ()});
                NetworkHandlers.handleBloodParticle((class_1657)client.field_1724, bloodData);
                break;
            }
            case 5: {
                BleedingParticleData bleedingData = new BleedingParticleData(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
                VRThrowingExtensions.log.debug("[Client] Received bleeding particle packet ID 5 at ({}, {}, {})", new Object[]{bleedingData.posX(), bleedingData.posY(), bleedingData.posZ()});
                NetworkHandlers.handleBleedingParticle((class_1657)client.field_1724, bleedingData);
                break;
            }
            case 6: {
                int length = buffer.method_10816();
                String json = buffer.method_10800(length);
                ConfigSyncData configData = new ConfigSyncData(json);
                NetworkHandlers.handleConfigSync((class_1657)client.field_1724, configData);
                break;
            }
            default: {
                VRThrowingExtensions.log.warn("[Client] Received unknown packet ID: {}", (Object)packetId);
            }
        }
    }

    private static void registerClientInputEventHandlers() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, dir) -> {
            if (ThrowHelper.cancellingBreaks()) {
                VRThrowingExtensions.log.debug("[VR Cancel] Block breaking cancelled due to throwing motion");
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (ThrowHelper.cancellingUse()) {
                VRThrowingExtensions.log.debug("[VR Cancel] Block placing cancelled due to throwing motion");
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (ThrowHelper.cancellingUse()) {
                VRThrowingExtensions.log.debug("[VR Cancel] Item use cancelled due to throwing motion");
                return class_1271.method_22431((Object)player.method_5998(hand));
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
    }
}

