/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import win.demistorm.ThrownProjectileEntity;

public class ThrownItemRenderer
extends class_897<ThrownProjectileEntity, ThrownItemRenderState> {
    private final class_10442 itemModelResolver;
    private final float scale;

    public ThrownItemRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.itemModelResolver = ctx.method_65566();
        this.scale = 0.7f;
        this.field_4673 = 0.0f;
    }

    @NotNull
    public ThrownItemRenderState createRenderState() {
        return new ThrownItemRenderState();
    }

    public void extractRenderState(ThrownProjectileEntity entity, ThrownItemRenderState state, float tickDelta) {
        super.method_62354((class_1297)entity, (class_10017)state, tickDelta);
        state.itemStack = entity.method_7495();
        state.velocity = entity.method_18798();
        state.age = (float)entity.field_6012 + tickDelta;
        state.handRollDeg = entity.getHandRoll();
        state.isCatching = entity.isCatching();
        state.isBounceActive = entity.isBounceActive();
        class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23318(), (double)entity.method_23321());
        state.lightCoords = class_761.method_23794((class_1920)entity.method_73183(), (class_2338)pos);
        state.isEmbedded = entity.isEmbedded();
        if (state.isEmbedded) {
            state.embedYawDeg = entity.getEmbedYaw();
            state.embedPitchDeg = entity.getEmbedPitch();
            state.embedRollDeg = entity.getEmbedRoll();
            state.embedTiltDeg = entity.getEmbedTilt();
        }
        this.itemModelResolver.method_65595(state.item, state.itemStack, class_811.field_4322, (class_1297)entity);
    }

    public void submit(ThrownItemRenderState state, class_4587 matrices, class_11659 collector, class_12075 cameraState) {
        super.method_3936((class_10017)state, matrices, collector, cameraState);
        if (state.item.method_65606()) {
            return;
        }
        matrices.method_22903();
        if (state.isEmbedded) {
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f - state.embedYawDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-state.embedPitchDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(state.embedTiltDeg));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(state.embedRollDeg));
            matrices.method_22905(this.scale, this.scale, this.scale);
            matrices.method_22905(1.0f, 1.0f, -1.0f);
            state.item.method_65604(matrices, collector, state.lightCoords, class_4608.field_21444, state.field_61821);
            matrices.method_22909();
            return;
        }
        class_243 vel = state.velocity;
        if (vel.method_1033() > 0.001) {
            float yaw = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 180.0 / Math.PI);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f - yaw));
            float hor = class_3532.method_15355((float)((float)(vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350)));
            float pitch = (float)(class_3532.method_15349((double)vel.field_1351, (double)hor) * 180.0 / Math.PI);
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-pitch));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-state.handRollDeg));
        }
        if (state.isCatching) {
            float smoothSpin = state.age * 5.0f % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(smoothSpin));
            float bobOffset = class_3532.method_15374((float)(state.age * 0.5f)) * 0.05f;
            matrices.method_46416(0.0f, bobOffset, 0.0f);
        } else if (state.isBounceActive) {
            float returnSpin = state.age * 8.0f % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(returnSpin));
            float wobble = class_3532.method_15374((float)(state.age * 0.35f)) * 3.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(wobble));
            float pulseScale = 1.0f + class_3532.method_15374((float)(state.age * 0.4f)) * 0.05f;
            matrices.method_22905(pulseScale, pulseScale, pulseScale);
        } else {
            float spinSpeed = 15.0f;
            float spin = state.age * spinSpeed % 360.0f;
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(spin));
        }
        matrices.method_22905(this.scale, this.scale, this.scale);
        matrices.method_22905(1.0f, 1.0f, -1.0f);
        state.item.method_65604(matrices, collector, state.lightCoords, class_4608.field_21444, state.field_61821);
        matrices.method_22909();
    }

    public static class ThrownItemRenderState
    extends class_10017 {
        public class_1799 itemStack = class_1799.field_8037;
        public final class_10444 item = new class_10444();
        public class_243 velocity = class_243.field_1353;
        public float age = 0.0f;
        public float handRollDeg = 0.0f;
        public boolean isCatching = false;
        public boolean isBounceActive = false;
        public boolean isEmbedded = false;
        public float embedYawDeg = 0.0f;
        public float embedPitchDeg = 0.0f;
        public float embedRollDeg = 0.0f;
        public float embedTiltDeg = 0.0f;
        public int lightCoords = 0;
    }
}

