/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client.particles;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.config.ClientOnlyConfig;
import win.demistorm.network.BleedingParticleData;

public final class BleedingParticle {
    private static final int baseCount = 10;
    private static final int countVariation = 4;
    private static final double lateralJitter = 0.02;
    private static final double velDownMin = -0.08;
    private static final double velDownMax = -0.02;
    private static final double velSideMin = -0.015;
    private static final double velSideMax = 0.015;
    private static final float dustScaleBase = 0.45f;
    private static final float dustScaleVar = 0.2f;
    private static final double redDyeChance = 0.35;

    public static void spawnBleedingParticles(BleedingParticleData data) {
        if (!ClientOnlyConfig.ACTIVE.bloodEffect) {
            VRThrowingExtensions.log.debug("[Bleeding Effect] Bleeding particles disabled by config, skipping spawn at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
            return;
        }
        VRThrowingExtensions.log.debug("[Bleeding Effect] Spawning bleeding particles at ({}, {}, {})", new Object[]{data.posX(), data.posY(), data.posZ()});
        class_243 pos = new class_243(data.posX(), data.posY(), data.posZ());
        BleedingParticle.spawnBleedTrickle(pos);
    }

    private static void spawnBleedTrickle(class_243 pos) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        int count = 10 + rng.nextInt(-4, 5);
        for (int i = 0; i < count; ++i) {
            double ox = rng.nextDouble(-0.02, 0.02);
            double oy = rng.nextDouble(-0.02, 0.02);
            double oz = rng.nextDouble(-0.02, 0.02);
            double vx = rng.nextDouble(-0.015, 0.015);
            double vy = rng.nextDouble(-0.08, -0.02);
            double vz = rng.nextDouble(-0.015, 0.015);
            if (rng.nextDouble() < 0.35) {
                mc.field_1687.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8264)), pos.field_1352 + ox, pos.field_1351 + oy, pos.field_1350 + oz, vx, vy, vz);
                continue;
            }
            int packedColor = BleedingParticle.packColor(0.6f + rng.nextFloat() * 0.35f, rng.nextFloat() * 0.08f, rng.nextFloat() * 0.06f);
            float scale = 0.45f + (rng.nextFloat() - 0.5f) * 0.2f;
            class_2390 bloodDust = new class_2390(packedColor, scale);
            mc.field_1687.method_8406((class_2394)bloodDust, pos.field_1352 + ox, pos.field_1351 + oy, pos.field_1350 + oz, vx, vy, vz);
        }
    }

    private static int packColor(float r, float g, float b) {
        int ri = Math.max(0, Math.min(255, (int)(r * 255.0f)));
        int gi = Math.max(0, Math.min(255, (int)(g * 255.0f)));
        int bi = Math.max(0, Math.min(255, (int)(b * 255.0f)));
        return ri << 16 | gi << 8 | bi;
    }

    private BleedingParticle() {
    }
}

