/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.fabric;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import win.demistorm.Platform;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.fabric.BufferPacket;
import win.demistorm.network.Network;

public class VRThrowingExtensionsFabric
implements ModInitializer {
    public void onInitialize() {
        VRThrowingExtensions.log.info("VR Throwing Extensions (FABRIC) starting!");
        this.registerEntities();
        PayloadTypeRegistry.playC2S().register(BufferPacket.ID, BufferPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(BufferPacket.ID, BufferPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(BufferPacket.ID, (payload, context) -> {
            payload.buffer().method_52938();
            context.server().execute(() -> {
                try {
                    Network.INSTANCE.handlePacket(context.player(), payload.buffer());
                }
                finally {
                    payload.buffer().release();
                }
            });
        });
        Network.initialize();
        try {
            Class.forName("org.vivecraft.api.VRAPI");
            VRThrowingExtensions.log.info("Vivecraft detected! VR throwing enabled.");
        }
        catch (ClassNotFoundException e) {
            VRThrowingExtensions.log.error("Vivecraft not found! VR Throwing Extensions requires Vivecraft to function.");
            throw new RuntimeException("Vivecraft is required for VR Throwing Extensions");
        }
        VRThrowingExtensions.initialize();
        if (Platform.isModLoaded("modmenu")) {
            VRThrowingExtensions.log.info("Mod Menu detected! Configuration available through mod menu.");
        }
    }

    private void registerEntities() {
        class_2960 entityLocation = class_2960.method_60655((String)"vr_throwing_extensions", (String)"generic_thrown_item");
        VRThrowingExtensions.THROWN_ITEM_TYPE = class_1299.class_1300.method_5903(ThrownProjectileEntity::new, (class_1311)class_1311.field_17715).method_17687(0.25f, 0.25f).method_27299(64).method_27300(5).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)entityLocation));
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)entityLocation, VRThrowingExtensions.THROWN_ITEM_TYPE);
        VRThrowingExtensions.log.info("Registered entity type: {}", (Object)entityLocation);
    }
}

