/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;

public final class BoomerangEffect {
    public static final double baseReturnSpeed = 1.0;
    public static final double closeDistance = 3.0;
    public static final double farDistance = 25.0;
    public static final double closeSpeedMultiplier = 0.3;
    public static final double farSpeedMultiplier = 2.0;
    public static final double scalingCurve = 1.2;
    public static final double arcGain = 0.6;
    public static final double arcMin = 0.8;
    public static final double arcMax = 6.0;
    public static final double arcDecayPerStep = 0.8;
    public static final double maxTurnRateNear = Math.toRadians(30.0);
    public static final double maxTurnRateFar = Math.toRadians(55.0);
    public static final double lateralStartBoost = 0.35;
    public static final double dampFactor = 0.95;
    public static final double maxOverTarget = 1.6;
    public static final double minUnderTarget = 0.45;
    public static final Set<Item> bounceTools = new HashSet<Item>();

    public static boolean canBounce(Item i) {
        return bounceTools.contains(i);
    }

    public static void startBounce(ThrownProjectileEntity proj) {
        proj.hasBounced = true;
        proj.bounceActive = true;
        proj.clearSpawnImmunity();
        Vec3 currentPos = proj.m_20182_();
        Vec3 toOrigin = proj.originalThrowPos.m_82546_(currentPos);
        double distanceToOrigin = toOrigin.m_82553_();
        if (distanceToOrigin < 0.1) {
            VRThrowingExtensions.log.debug("[Boomerang] Too close to origin, dropping normally");
            proj.bounceActive = false;
            return;
        }
        Vec3 dir = toOrigin.m_82541_();
        double rollRad = Math.toRadians(proj.getHandRoll());
        Vec3 worldUp = new Vec3(0.0, 1.0, 0.0);
        Vec3 upRolled = BoomerangEffect.rotateAroundAxis(worldUp, dir, rollRad);
        Vec3 upProj = BoomerangEffect.projectPerp(upRolled, dir);
        Vec3 right = dir.m_82537_(upRolled).m_82541_();
        double cosR = Math.cos(rollRad);
        double sinR = Math.sin(rollRad);
        Vec3 curveDir = upProj.m_82490_(cosR).m_82549_(right.m_82490_(sinR)).m_82541_();
        proj.bounceInverse = proj.getHandRoll() < 0.0f;
        Vec3 planeNormal = dir.m_82537_(curveDir).m_82541_();
        if (proj.bounceInverse) {
            planeNormal = planeNormal.m_82490_(-1.0);
        }
        double arcMag = Mth.m_14008_((double)(distanceToOrigin * 0.6), (double)0.8, (double)6.0);
        proj.bouncePlaneNormal = planeNormal;
        proj.bounceArcMag = arcMag;
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(distanceToOrigin);
        double bounceSpeed = 1.0 * speedMultiplier;
        Vec3 baseVel = dir.m_82490_(bounceSpeed);
        Vec3 lateralVel = curveDir.m_82490_(bounceSpeed * 0.35);
        Vec3 finalVel = baseVel.m_82549_(lateralVel).m_82520_(0.0, 0.02, 0.0);
        proj.m_20256_(finalVel);
        proj.m_20242_(true);
        if (!proj.m_9236_().m_5776_()) {
            proj.m_9236_().m_5594_(null, proj.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.6f, 1.5f);
        }
        VRThrowingExtensions.log.debug("[Boomerang] Projectile {} started return. Dist={}. Roll={}\u00b0, Speed={} (mult={}), ArcMag={}", new Object[]{proj.m_19879_(), String.format("%.2f", distanceToOrigin), String.format("%.1f", Float.valueOf(proj.getHandRoll())), String.format("%.3f", bounceSpeed), String.format("%.2f", speedMultiplier), String.format("%.2f", arcMag)});
    }

    public static boolean tickReturn(ThrownProjectileEntity proj) {
        Vec3 currentPos = proj.m_20182_();
        Vec3 toOrigin = proj.originalThrowPos.m_82546_(currentPos);
        double distSq = toOrigin.m_82556_();
        boolean reachedOrigin = false;
        if (distSq < 0.36) {
            reachedOrigin = true;
            VRThrowingExtensions.log.debug("[Boomerang] Projectile {} reached origin (dist={})", (Object)proj.m_19879_(), (Object)String.format("%.3f", Math.sqrt(distSq)));
        } else {
            double dot;
            Vec3 currentVel = proj.m_20184_();
            if (currentVel.m_82553_() > 0.01 && (dot = currentVel.m_82541_().m_82526_(toOrigin.m_82541_())) < -0.8 && distSq < 4.0) {
                reachedOrigin = true;
                VRThrowingExtensions.log.debug("[Boomerang] Projectile {} overshot origin (dist={}, dot={})", new Object[]{proj.m_19879_(), String.format("%.3f", Math.sqrt(distSq)), String.format("%.3f", dot)});
            }
        }
        if (reachedOrigin) {
            return true;
        }
        Vec3 target = proj.originalThrowPos.m_82549_(proj.bounceCurveOffset);
        Vec3 toTarget = target.m_82546_(currentPos);
        double distance = toTarget.m_82553_();
        if (distance < 1.0E-4) {
            return false;
        }
        Vec3 wantDir = toTarget.m_82541_();
        Vec3 currentVel = proj.m_20184_();
        double speedMultiplier = BoomerangEffect.calculateSpeedMultiplier(Math.sqrt(distSq));
        double targetSpeed = 1.0 * speedMultiplier;
        double turnRate = Mth.m_14139_((double)Mth.m_14036_((float)((float)(distance / 25.0)), (float)0.0f, (float)1.0f), (double)maxTurnRateNear, (double)maxTurnRateFar);
        Vec3 turned = BoomerangEffect.turnTowards(currentVel, wantDir, turnRate);
        Vec3 newVel = turned.m_82490_(0.95);
        double newSpeed = newVel.m_82553_();
        double maxSpeed = targetSpeed * 1.6;
        double minSpeed = targetSpeed * 0.45;
        if (newSpeed > maxSpeed) {
            newVel = newVel.m_82541_().m_82490_(maxSpeed);
        } else if (newSpeed < minSpeed && newSpeed > 1.0E-4) {
            newVel = newVel.m_82541_().m_82490_(minSpeed);
        }
        proj.m_20256_(newVel);
        double nearFactor = Mth.m_14008_((double)(1.0 - distance / 25.0), (double)0.0, (double)0.8);
        double decay = Mth.m_14139_((double)nearFactor, (double)0.8, (double)0.6000000000000001);
        proj.bounceCurveOffset = proj.bounceCurveOffset.m_82490_(decay);
        if (proj.f_19797_ % 20 == 0) {
            VRThrowingExtensions.log.debug("[Boomerang] Return: dist={}, speed={}, target={}, arcLen={}", new Object[]{String.format("%.2f", Math.sqrt(distSq)), String.format("%.3f", newVel.m_82553_()), String.format("%.3f", targetSpeed), String.format("%.2f", proj.bounceCurveOffset.m_82556_() > 0.0 ? Math.sqrt(proj.bounceCurveOffset.m_82556_()) : 0.0)});
        }
        return false;
    }

    private static double calculateSpeedMultiplier(double distance) {
        if (distance <= 3.0) {
            return 0.3;
        }
        if (distance >= 25.0) {
            return 2.0;
        }
        double t = (distance - 3.0) / 22.0;
        t = Math.pow(t, 1.2);
        return Mth.m_14179_((float)((float)t), (float)0.3f, (float)2.0f);
    }

    private static Vec3 rotateAroundAxis(Vec3 v, Vec3 axis, double angle) {
        Vec3 k = axis.m_82541_();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double dot = v.m_82526_(k);
        Vec3 term1 = v.m_82490_(cos);
        Vec3 term2 = k.m_82537_(v).m_82490_(sin);
        Vec3 term3 = k.m_82490_(dot * (1.0 - cos));
        return term1.m_82549_(term2).m_82549_(term3);
    }

    private static Vec3 projectPerp(Vec3 v, Vec3 normal) {
        double d = v.m_82526_(normal);
        return v.m_82546_(normal.m_82490_(d)).m_82541_();
    }

    private static Vec3 turnTowards(Vec3 currentVel, Vec3 wantDir, double maxAngle) {
        double speed = currentVel.m_82553_();
        if (speed < 1.0E-6) {
            return wantDir.m_82490_(speed);
        }
        Vec3 curDir = currentVel.m_82541_();
        double dot = Mth.m_14008_((double)curDir.m_82526_(wantDir), (double)-1.0, (double)1.0);
        double angle = Math.acos(dot);
        if (angle <= maxAngle) {
            return wantDir.m_82490_(speed);
        }
        Vec3 axis = curDir.m_82537_(wantDir);
        if (axis.m_82556_() < 1.0E-9) {
            Vec3 turnDir = curDir.m_82490_(0.999).m_82549_(wantDir.m_82490_(0.001)).m_82541_();
            return turnDir.m_82490_(speed);
        }
        Vec3 rotated = BoomerangEffect.rotateAroundAxis(curDir, axis, maxAngle);
        return rotated.m_82541_().m_82490_(speed);
    }

    private BoomerangEffect() {
    }

    static {
        BuiltInRegistries.f_257033_.m_123024_().filter(i -> !BuiltInRegistries.f_257033_.m_7981_(i).equals((Object)new ResourceLocation("minecraft", "air"))).forEach(bounceTools::add);
    }
}

