/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.effects;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.Network;

public final class EmbeddingEffect {
    public static final float targetRollDegX = 70.0f;
    public static final float rollApproachPerTick = 20.0f;
    private static final float forwardSpinSpeedDegPerTick = 15.0f;
    private static final double embedAdjust = 0.3;
    private static final int bleedIntervalTicks = 30;
    private static final float bleedDamage = 1.0f;

    private EmbeddingEffect() {
    }

    public static void startEmbedding(ThrownProjectileEntity proj, EntityHitResult hit, Vec3 clampedHitPos) {
        if (proj.m_9236_().m_5776_()) {
            return;
        }
        Entity target = hit.m_82443_();
        if (!(target instanceof LivingEntity)) {
            proj.dropAndDiscard();
            return;
        }
        LivingEntity living = (LivingEntity)target;
        Vec3 dir = proj.m_20184_();
        if (dir.m_82556_() < 1.0E-6) {
            dir = hit.m_82450_().m_82546_(proj.m_20182_());
        }
        if (dir.m_82556_() < 1.0E-6) {
            dir = new Vec3(1.0, 0.0, 0.0);
        }
        dir = dir.m_82541_();
        Vec3 embedPos = EmbeddingEffect.calculateEmbedPosition(target, clampedHitPos);
        float yaw = (float)(Mth.m_14136_((double)dir.f_82481_, (double)dir.f_82479_) * 180.0 / Math.PI);
        float pitch = (float)(Mth.m_14136_((double)dir.f_82480_, (double)Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 180.0 / Math.PI);
        float tiltDeg = -proj.getHandRoll();
        float initialXRollDeg = (float)proj.f_19797_ * 15.0f % 360.0f;
        Vec3 worldOffset = embedPos.m_82546_(target.m_20182_());
        proj.beginEmbedding(living, worldOffset, yaw, pitch, tiltDeg, initialXRollDeg);
        BleedManager.register(living, proj.m_9236_().m_46467_(), proj);
        proj.m_9236_().m_5594_(null, proj.m_20183_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 0.45f, 0.8f);
        double finalEmbedDepth = clampedHitPos.m_82554_(embedPos);
        VRThrowingExtensions.log.debug("[Embed] Projectile {} embedded into {} at {} (+{}), yaw={}, pitch={}, tilt={}, xRollStart={}", new Object[]{proj.m_19879_(), target.m_7755_().getString(), clampedHitPos, String.format("%.2f", finalEmbedDepth), String.format("%.1f", Float.valueOf(yaw)), String.format("%.1f", Float.valueOf(pitch)), String.format("%.1f", Float.valueOf(tiltDeg)), String.format("%.1f", Float.valueOf(initialXRollDeg))});
    }

    private static Vec3 calculateEmbedPosition(Entity target, Vec3 hitPos) {
        AABB boundingBox = target.m_20191_();
        Vec3 centerAtHitY = new Vec3(boundingBox.m_82399_().f_82479_, hitPos.f_82480_, boundingBox.m_82399_().f_82481_);
        Vec3 toCenter = centerAtHitY.m_82546_(hitPos);
        Vec3 adjustment = toCenter.m_82490_(0.3);
        return hitPos.m_82549_(adjustment);
    }

    public static void tickEmbedded(ThrownProjectileEntity proj) {
        LivingEntity living;
        if (!proj.isEmbedded()) {
            return;
        }
        if (proj.m_9236_().m_5776_()) {
            return;
        }
        Entity target = proj.getEmbeddedTarget();
        if (!(target instanceof LivingEntity) || !(living = (LivingEntity)target).m_6084_() || target.m_213877_()) {
            VRThrowingExtensions.log.debug("[Embed] Host entity lost; dropping projectile {}", (Object)proj.m_19879_());
            proj.clearEmbedding();
            proj.dropAndDiscard();
            return;
        }
        float hostBodyYaw = living.m_6080_();
        float hostPitch = living.m_146909_();
        Vec3 base = target.m_20182_();
        Vec3 offsetWorld = EmbeddingEffect.rotateY(proj.getEmbeddedOffset(), hostBodyYaw);
        Vec3 newPos = base.m_82549_(offsetWorld);
        proj.m_146884_(newPos);
        proj.m_20256_(Vec3.f_82478_);
        proj.m_20242_(true);
        float worldYaw = Mth.m_14177_((float)(hostBodyYaw + proj.getEmbeddedLocalYaw()));
        float worldPitch = Mth.m_14177_((float)(hostPitch + proj.getEmbeddedLocalPitch()));
        proj.setEmbedYaw(worldYaw);
        proj.setEmbedPitch(worldPitch);
        float current = proj.getEmbedRoll();
        float baseAngle = 70.0f;
        float nearestTarget = baseAngle + 360.0f * (float)Math.round((current - baseAngle) / 360.0f);
        float diff = nearestTarget - current;
        if (Math.abs(diff) > 0.01f) {
            float step = Math.copySign(20.0f, diff);
            float next = Math.abs(diff) <= 20.0f ? nearestTarget : current + step;
            proj.setEmbedRoll(next);
        }
        BleedManager.tryApplyBleed(living, proj.m_9236_().m_46467_());
        if (proj.f_19797_ % 20 == 0) {
            VRThrowingExtensions.log.debug("[Embed] Following host. proj={} bodyYaw={} worldYaw={} pos={}", new Object[]{proj.m_19879_(), String.format("%.1f", Float.valueOf(hostBodyYaw)), String.format("%.1f", Float.valueOf(worldYaw)), proj.m_20182_()});
        }
    }

    public static void releaseEmbedding(ThrownProjectileEntity proj) {
        if (!proj.isEmbedded()) {
            return;
        }
        proj.clearEmbedding();
        proj.m_20242_(true);
        proj.m_20256_(Vec3.f_82478_);
        VRThrowingExtensions.log.debug("[Embed] Released projectile {} from embed state for catching", (Object)proj.m_19879_());
    }

    private static Vec3 rotateY(Vec3 v, float degrees) {
        double rad = Math.toRadians(degrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = v.f_82479_ * cos - v.f_82481_ * sin;
        double z = v.f_82479_ * sin + v.f_82481_ * cos;
        return new Vec3(x, v.f_82480_, z);
    }

    public static final class BleedManager {
        private static final Map<LivingEntity, BleedState> STATES = new WeakHashMap<LivingEntity, BleedState>();

        static void register(LivingEntity host, long worldTime, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                st = new BleedState(worldTime);
                STATES.put(host, st);
                VRThrowingExtensions.log.debug("[Bleed] Anchor set for {} at worldTick={}", (Object)host.m_7755_().getString(), (Object)worldTime);
            }
            st.projs.add(proj);
            VRThrowingExtensions.log.debug("[Bleed] Added embed for {}. count={}", (Object)host.m_7755_().getString(), (Object)st.projs.size());
        }

        public static void unregister(LivingEntity host, ThrownProjectileEntity proj) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            st.projs.remove((Object)proj);
            if (st.projs.isEmpty()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Cleared bleed state for {} (no more embeds)", (Object)host.m_7755_().getString());
            } else {
                VRThrowingExtensions.log.debug("[Bleed] Removed embed for {}. Remaining count={}", (Object)host.m_7755_().getString(), (Object)st.projs.size());
            }
        }

        static void tryApplyBleed(LivingEntity host, long worldTime) {
            BleedState st = STATES.get(host);
            if (st == null) {
                return;
            }
            if (!host.m_6084_()) {
                STATES.remove(host);
                VRThrowingExtensions.log.debug("[Bleed] Host {} died. Removing bleed state.", (Object)host.m_7755_().getString());
                return;
            }
            long delta = worldTime - st.anchorTick;
            if (delta < 30L) {
                return;
            }
            if (delta % 30L != 0L) {
                return;
            }
            if (st.lastAppliedTick == worldTime) {
                return;
            }
            st.lastAppliedTick = worldTime;
            int activeCount = 0;
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.m_213877_() || !p.isEmbedded()) continue;
                ++activeCount;
            }
            if (activeCount <= 0) {
                STATES.remove(host);
                return;
            }
            float total = 1.0f * (float)activeCount;
            ServerLevel sw = (ServerLevel)host.m_9236_();
            host.m_6469_(sw.m_269111_().m_269264_(), total);
            for (ThrownProjectileEntity p : st.projs) {
                if (p == null || p.m_213877_() || !p.isEmbedded()) continue;
                Vec3 pos = p.m_20182_();
                for (ServerPlayer player : sw.m_7654_().m_6846_().m_11314_()) {
                    if (player.m_9236_() != sw || !(player.m_20238_(pos) < 4096.0)) continue;
                    Network.INSTANCE.sendToPlayer(player, new BleedingParticleData(pos.f_82479_, pos.f_82480_, pos.f_82481_));
                }
            }
            VRThrowingExtensions.log.debug("[Bleed] Applied {} bleed to {} at tick {} (embeds={}, anchor={})", new Object[]{Float.valueOf(total), host.m_7755_().getString(), worldTime, activeCount, st.anchorTick});
        }

        private static final class BleedState {
            final long anchorTick;
            long lastAppliedTick = Long.MIN_VALUE;
            final Set<ThrownProjectileEntity> projs = Collections.newSetFromMap(new IdentityHashMap());

            BleedState(long anchorTick) {
                this.anchorTick = anchorTick;
            }
        }
    }
}

