/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import win.demistorm.Platform;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.ThrownItemRenderer;
import win.demistorm.client.VRThrowingExtensionsClient;
import win.demistorm.network.BleedingParticleData;
import win.demistorm.network.BloodParticleData;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.NetworkHandlers;

@Mod.EventBusSubscriber(modid="vr_throwing_extensions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    public static void doClientSetup() {
        VRThrowingExtensionsClient.initializeClient();
        Platform.registerClientInputEventHandlers();
        VRThrowingExtensions.log.info("Scheduling entity renderer registration...");
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (VRThrowingExtensions.THROWN_ITEM_TYPE != null) {
            event.registerEntityRenderer(VRThrowingExtensions.THROWN_ITEM_TYPE, ThrownItemRenderer::new);
            VRThrowingExtensions.log.info("Registered entity renderer for thrown items");
        } else {
            VRThrowingExtensions.log.warn("Entity type not yet initialized, skipping renderer registration");
        }
    }

    public static void handleNetworkPacket(FriendlyByteBuf buffer) {
        int packetId = buffer.readInt();
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        switch (packetId) {
            case 4: {
                BloodParticleData bloodData = new BloodParticleData(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
                VRThrowingExtensions.log.debug("[Forge Client] Received blood particle packet ID 4 at ({}, {}, {})", new Object[]{bloodData.posX(), bloodData.posY(), bloodData.posZ()});
                NetworkHandlers.handleBloodParticle((Player)client.f_91074_, bloodData);
                break;
            }
            case 5: {
                BleedingParticleData bleedingData = new BleedingParticleData(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
                VRThrowingExtensions.log.debug("[Forge Client] Received bleeding particle packet ID 5 at ({}, {}, {})", new Object[]{bleedingData.posX(), bleedingData.posY(), bleedingData.posZ()});
                NetworkHandlers.handleBleedingParticle((Player)client.f_91074_, bleedingData);
                break;
            }
            case 6: {
                int length = buffer.m_130242_();
                String json = buffer.m_130136_(length);
                ConfigSyncData configData = new ConfigSyncData(json);
                NetworkHandlers.handleConfigSync((Player)client.f_91074_, configData);
                break;
            }
            default: {
                VRThrowingExtensions.log.warn("[Forge Client] Received unknown packet ID: {}", (Object)packetId);
            }
        }
    }
}

