/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.forge;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegisterEvent;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.forge.BufferPacket;
import win.demistorm.forge.ClientSetup;
import win.demistorm.forge.ForgeConfigScreen;
import win.demistorm.network.Network;

@Mod(value="vr_throwing_extensions")
public class VRThrowingExtensionsForge {
    private static final IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("vr_throwing_extensions", "network")).networkProtocolVersion(() -> "1.0").serverAcceptedVersions("1.0"::equals).clientAcceptedVersions("1.0"::equals).simpleChannel();

    public VRThrowingExtensionsForge() {
        VRThrowingExtensions.log.info("VR Throwing Extensions (FORGE) starting!");
        try {
            Class.forName("org.vivecraft.api.VRAPI");
            VRThrowingExtensions.log.info("Vivecraft detected! VR throwing enabled.");
        }
        catch (ClassNotFoundException e) {
            VRThrowingExtensions.log.error("Vivecraft not found! VR Throwing Extensions requires Vivecraft to function.");
            throw new RuntimeException("Vivecraft is required for VR Throwing Extensions");
        }
        VRThrowingExtensions.initialize();
        NETWORK.registerMessage(0, BufferPacket.class, BufferPacket::encode, BufferPacket::decode, BufferPacket::handle);
        MOD_EVENT_BUS.register(VRThrowingExtensionsForge.class);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientSetup.doClientSetup();
            ForgeConfigScreen.register();
        }
        VRThrowingExtensions.log.info("VR Throwing Extensions (FORGE) initialization complete!");
    }

    @SubscribeEvent
    public static void registerEntities(RegisterEvent event) {
        ResourceLocation entityLocation = new ResourceLocation("vr_throwing_extensions", "generic_thrown_item");
        event.register(Registries.f_256939_, entityLocation, () -> {
            VRThrowingExtensions.THROWN_ITEM_TYPE = EntityType.Builder.m_20704_(ThrownProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(64).m_20717_(5).m_20712_("vr_throwing_extensions:generic_thrown_item");
            VRThrowingExtensions.log.info("Registered entity type: {}", (Object)entityLocation);
            VRThrowingExtensions.log.info("Entity type created: {}", VRThrowingExtensions.THROWN_ITEM_TYPE);
            VRThrowingExtensions.log.info("Initializing networking after entity registration...");
            Network.initialize();
            return VRThrowingExtensions.THROWN_ITEM_TYPE;
        });
    }
}

